DNA_VOCAB = {"A", "T", "C", "G", "X"}
RNA_VOCAB = {"A", "U", "C", "G", "X"}
AA_VOCAB = {
    "G",
    "A",
    "L",
    "M",
    "F",
    "W",
    "K",
    "Q",
    "E",
    "S",
    "P",
    "V",
    "I",
    "C",
    "Y",
    "H",
    "R",
    "N",
    "D",
    "T",
    "*",
}

CODON_TABLE = {
    "AUA": "I",
    "AUC": "I",
    "AUU": "I",
    "AUG": "M",
    "ACA": "T",
    "ACC": "T",
    "ACG": "T",
    "ACU": "T",
    "AAC": "N",
    "AAU": "N",
    "AAA": "K",
    "AAG": "K",
    "AGC": "S",
    "AGU": "S",
    "AGA": "R",
    "AGG": "R",
    "CUA": "L",
    "CUC": "L",
    "CUG": "L",
    "CUU": "L",
    "CCA": "P",
    "CCC": "P",
    "CCG": "P",
    "CCU": "P",
    "CAC": "H",
    "CAU": "H",
    "CAA": "Q",
    "CAG": "Q",
    "CGA": "R",
    "CGC": "R",
    "CGG": "R",
    "CGU": "R",
    "GUA": "V",
    "GUC": "V",
    "GUG": "V",
    "GUU": "V",
    "GCA": "A",
    "GCC": "A",
    "GCG": "A",
    "GCU": "A",
    "GAC": "D",
    "GAU": "D",
    "GAA": "E",
    "GAG": "E",
    "GGA": "G",
    "GGC": "G",
    "GGG": "G",
    "GGU": "G",
    "UCA": "S",
    "UCC": "S",
    "UCG": "S",
    "UCU": "S",
    "UUC": "F",
    "UUU": "F",
    "UUA": "L",
    "UUG": "L",
    "UAC": "Y",
    "UAU": "Y",
    "UAA": "*",
    "UAG": "*",
    "UGC": "C",
    "UGU": "C",
    "UGA": "*",
    "UGG": "W",
}

RC_TABLE = {"A": "T", "T": "A", "C": "G", "G": "C"}

NT_MW_TABLE = {"A": 313.21, "T": 304.2, "C": 289.18, "G": 329.21, "U": 290.17}

AA_MW_TABLE = {
    "G": 75,
    "A": 89,
    "L": 131,
    "M": 149,
    "F": 165,
    "W": 204,
    "K": 146,
    "Q": 146,
    "E": 147,
    "S": 105,
    "P": 115,
    "V": 117,
    "I": 131,
    "C": 121,
    "Y": 181,
    "H": 155,
    "R": 174,
    "N": 132,
    "D": 133,
    "T": 119,
    "*": 0,
}

if __name__ == "__main__":
    pass
