"use strict";
const assert_1 = require("@aws-cdk/assert");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'simple destination'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const role = new iam.Role(stack, 'Role', {
            assumedBy: new iam.ServicePrincipal('logs.us-east-2.amazonaws.com'),
        });
        // WHEN
        new lib_1.CrossAccountDestination(stack, 'Dest', {
            destinationName: 'MyDestination',
            role,
            targetArn: 'arn:bogus',
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Logs::Destination', {
            DestinationName: 'MyDestination',
            RoleArn: { 'Fn::GetAtt': ['Role1ABCC5F0', 'Arn'] },
            TargetArn: 'arn:bogus',
        }));
        test.done();
    },
    'add policy to destination'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const role = new iam.Role(stack, 'Role', {
            assumedBy: new iam.ServicePrincipal('logs.us-east-2.amazonaws.com'),
        });
        const dest = new lib_1.CrossAccountDestination(stack, 'Dest', {
            destinationName: 'MyDestination',
            role,
            targetArn: 'arn:bogus',
        });
        // WHEN
        dest.addToPolicy(new iam.PolicyStatement({
            actions: ['logs:TalkToMe'],
        }));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Logs::Destination', (props) => {
            const pol = JSON.parse(props.DestinationPolicy);
            return pol.Statement[0].Action === 'logs:TalkToMe';
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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