# Generated by Django 2.2.3 on 2019-08-19 15:07

import datetime

import django.contrib.postgres.fields.jsonb
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [("response", "0001_initial")]

    operations = [
        migrations.CreateModel(
            name="TimelineEvent",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(
                        default=datetime.datetime.now,
                        help_text="Time of when this event occurred.",
                    ),
                ),
                (
                    "text",
                    models.TextField(help_text="Freeform text describing this event"),
                ),
                (
                    "event_type",
                    models.CharField(
                        choices=[("text", "Freeform text field")],
                        help_text="Type of event.",
                        max_length=10,
                    ),
                ),
                (
                    "metadata",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        help_text="Additional fields that can be added by other event types",
                        null=True,
                    ),
                ),
                (
                    "incident",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="response.Incident",
                    ),
                ),
            ],
        )
    ]
