"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WhiteListReceiptFilter = exports.AllowListReceiptFilter = exports.ReceiptFilter = exports.ReceiptFilterPolicy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const ses_generated_1 = require("./ses.generated");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * The policy for the receipt filter.
 *
 * @stability stable
 */
var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    ReceiptFilterPolicy["ALLOW"] = "Allow";
    ReceiptFilterPolicy["BLOCK"] = "Block";
})(ReceiptFilterPolicy = exports.ReceiptFilterPolicy || (exports.ReceiptFilterPolicy = {}));
/**
 * A receipt filter.
 *
 * When instantiated without props, it creates a
 * block all receipt filter.
 *
 * @stability stable
 */
class ReceiptFilter extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptFilterName,
        });
        jsiiDeprecationWarnings._aws_cdk_aws_ses_ReceiptFilterProps(props);
        new ses_generated_1.CfnReceiptFilter(this, 'Resource', {
            filter: {
                ipFilter: {
                    cidr: props.ip || '0.0.0.0/0',
                    policy: props.policy || ReceiptFilterPolicy.BLOCK,
                },
                name: this.physicalName,
            },
        });
    }
}
exports.ReceiptFilter = ReceiptFilter;
_a = JSII_RTTI_SYMBOL_1;
ReceiptFilter[_a] = { fqn: "@aws-cdk/aws-ses.ReceiptFilter", version: "1.134.0" };
/**
 * An allow list receipt filter.
 *
 * @stability stable
 */
class AllowListReceiptFilter extends core_2.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_ses_AllowListReceiptFilterProps(props);
        new ReceiptFilter(this, 'BlockAll');
        props.ips.forEach(ip => {
            new ReceiptFilter(this, `Allow${ip.replace(/[^\d]/g, '')}`, {
                ip,
                policy: ReceiptFilterPolicy.ALLOW,
            });
        });
    }
}
exports.AllowListReceiptFilter = AllowListReceiptFilter;
_b = JSII_RTTI_SYMBOL_1;
AllowListReceiptFilter[_b] = { fqn: "@aws-cdk/aws-ses.AllowListReceiptFilter", version: "1.134.0" };
/**
 * (deprecated) An allow list receipt filter.
 *
 * @deprecated use `AllowListReceiptFilter`
 */
class WhiteListReceiptFilter extends AllowListReceiptFilter {
    /**
     * @deprecated
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        jsiiDeprecationWarnings.print("@aws-cdk/aws-ses.WhiteListReceiptFilter", "");
        jsiiDeprecationWarnings._aws_cdk_aws_ses_WhiteListReceiptFilterProps(props);
    }
}
exports.WhiteListReceiptFilter = WhiteListReceiptFilter;
_c = JSII_RTTI_SYMBOL_1;
WhiteListReceiptFilter[_c] = { fqn: "@aws-cdk/aws-ses.WhiteListReceiptFilter", version: "1.134.0" };
//# sourceMappingURL=data:application/json;base64,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