import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AwsSecretBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The path of the AWS Secret Backend the role belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role#backend AwsSecretBackendRole#backend}
    */
    readonly backend: string;
    /**
    * Role credential type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role#credential_type AwsSecretBackendRole#credential_type}
    */
    readonly credentialType: string;
    /**
    * The default TTL in seconds for STS credentials. When a TTL is not specified when STS credentials are requested, and a default TTL is specified on the role, then this default TTL will be used. Valid only when credential_type is one of assumed_role or federation_token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role#default_sts_ttl AwsSecretBackendRole#default_sts_ttl}
    */
    readonly defaultStsTtl?: number;
    /**
    * A list of IAM group names. IAM users generated against this vault role will be added to these IAM Groups. For a credential type of assumed_role or federation_token, the policies sent to the corresponding AWS call (sts:AssumeRole or sts:GetFederation) will be the policies from each group in iam_groups combined with the policy_document and policy_arns parameters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role#iam_groups AwsSecretBackendRole#iam_groups}
    */
    readonly iamGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role#id AwsSecretBackendRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The max allowed TTL in seconds for STS credentials (credentials TTL are capped to max_sts_ttl). Valid only when credential_type is one of assumed_role or federation_token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role#max_sts_ttl AwsSecretBackendRole#max_sts_ttl}
    */
    readonly maxStsTtl?: number;
    /**
    * Unique name for the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role#name AwsSecretBackendRole#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role#namespace AwsSecretBackendRole#namespace}
    */
    readonly namespace?: string;
    /**
    * The ARN of the AWS Permissions Boundary to attach to IAM users created in the role. Valid only when credential_type is iam_user. If not specified, then no permissions boundary policy will be attached.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role#permissions_boundary_arn AwsSecretBackendRole#permissions_boundary_arn}
    */
    readonly permissionsBoundaryArn?: string;
    /**
    * ARN for an existing IAM policy the role should use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role#policy_arns AwsSecretBackendRole#policy_arns}
    */
    readonly policyArns?: string[];
    /**
    * IAM policy the role should use in JSON format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role#policy_document AwsSecretBackendRole#policy_document}
    */
    readonly policyDocument?: string;
    /**
    * ARNs of AWS roles allowed to be assumed. Only valid when credential_type is 'assumed_role'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role#role_arns AwsSecretBackendRole#role_arns}
    */
    readonly roleArns?: string[];
    /**
    * The path for the user name. Valid only when credential_type is iam_user. Default is /
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role#user_path AwsSecretBackendRole#user_path}
    */
    readonly userPath?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role vault_aws_secret_backend_role}
*/
export declare class AwsSecretBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_aws_secret_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend_role vault_aws_secret_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsSecretBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: AwsSecretBackendRoleConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _credentialType?;
    get credentialType(): string;
    set credentialType(value: string);
    get credentialTypeInput(): string | undefined;
    private _defaultStsTtl?;
    get defaultStsTtl(): number;
    set defaultStsTtl(value: number);
    resetDefaultStsTtl(): void;
    get defaultStsTtlInput(): number | undefined;
    private _iamGroups?;
    get iamGroups(): string[];
    set iamGroups(value: string[]);
    resetIamGroups(): void;
    get iamGroupsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxStsTtl?;
    get maxStsTtl(): number;
    set maxStsTtl(value: number);
    resetMaxStsTtl(): void;
    get maxStsTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _permissionsBoundaryArn?;
    get permissionsBoundaryArn(): string;
    set permissionsBoundaryArn(value: string);
    resetPermissionsBoundaryArn(): void;
    get permissionsBoundaryArnInput(): string | undefined;
    private _policyArns?;
    get policyArns(): string[];
    set policyArns(value: string[]);
    resetPolicyArns(): void;
    get policyArnsInput(): string[] | undefined;
    private _policyDocument?;
    get policyDocument(): string;
    set policyDocument(value: string);
    resetPolicyDocument(): void;
    get policyDocumentInput(): string | undefined;
    private _roleArns?;
    get roleArns(): string[];
    set roleArns(value: string[]);
    resetRoleArns(): void;
    get roleArnsInput(): string[] | undefined;
    private _userPath?;
    get userPath(): string;
    set userPath(value: string);
    resetUserPath(): void;
    get userPathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
