import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultApproleAuthBackendRoleIdConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/approle_auth_backend_role_id#backend DataVaultApproleAuthBackendRoleId#backend}
    */
    readonly backend?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/approle_auth_backend_role_id#id DataVaultApproleAuthBackendRoleId#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/approle_auth_backend_role_id#namespace DataVaultApproleAuthBackendRoleId#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/approle_auth_backend_role_id#role_name DataVaultApproleAuthBackendRoleId#role_name}
    */
    readonly roleName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/approle_auth_backend_role_id vault_approle_auth_backend_role_id}
*/
export declare class DataVaultApproleAuthBackendRoleId extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_approle_auth_backend_role_id";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/approle_auth_backend_role_id vault_approle_auth_backend_role_id} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultApproleAuthBackendRoleIdConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultApproleAuthBackendRoleIdConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get roleId(): string;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
