import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultIdentityGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_group#alias_id DataVaultIdentityGroup#alias_id}
    */
    readonly aliasId?: string;
    /**
    * Accessor of the mount to which the alias belongs to. This should be supplied in conjunction with `alias_name`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_group#alias_mount_accessor DataVaultIdentityGroup#alias_mount_accessor}
    */
    readonly aliasMountAccessor?: string;
    /**
    * Name of the alias. This should be supplied in conjunction with `alias_mount_accessor`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_group#alias_name DataVaultIdentityGroup#alias_name}
    */
    readonly aliasName?: string;
    /**
    * ID of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_group#group_id DataVaultIdentityGroup#group_id}
    */
    readonly groupId?: string;
    /**
    * Name of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_group#group_name DataVaultIdentityGroup#group_name}
    */
    readonly groupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_group#id DataVaultIdentityGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_group#namespace DataVaultIdentityGroup#namespace}
    */
    readonly namespace?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/identity_group vault_identity_group}
*/
export declare class DataVaultIdentityGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_identity_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/identity_group vault_identity_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultIdentityGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataVaultIdentityGroupConfig);
    get aliasCanonicalId(): string;
    get aliasCreationTime(): string;
    private _aliasId?;
    get aliasId(): string;
    set aliasId(value: string);
    resetAliasId(): void;
    get aliasIdInput(): string | undefined;
    get aliasLastUpdateTime(): string;
    get aliasMergedFromCanonicalIds(): string[];
    private _aliasMetadata;
    get aliasMetadata(): cdktf.StringMap;
    private _aliasMountAccessor?;
    get aliasMountAccessor(): string;
    set aliasMountAccessor(value: string);
    resetAliasMountAccessor(): void;
    get aliasMountAccessorInput(): string | undefined;
    get aliasMountPath(): string;
    get aliasMountType(): string;
    private _aliasName?;
    get aliasName(): string;
    set aliasName(value: string);
    resetAliasName(): void;
    get aliasNameInput(): string | undefined;
    get creationTime(): string;
    get dataJson(): string;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    resetGroupId(): void;
    get groupIdInput(): string | undefined;
    private _groupName?;
    get groupName(): string;
    set groupName(value: string);
    resetGroupName(): void;
    get groupNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastUpdateTime(): string;
    get memberEntityIds(): string[];
    get memberGroupIds(): string[];
    private _metadata;
    get metadata(): cdktf.StringMap;
    get modifyIndex(): number;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get namespaceId(): string;
    get parentGroupIds(): string[];
    get policies(): string[];
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
