import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultKvSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secret#id DataVaultKvSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secret#namespace DataVaultKvSecret#namespace}
    */
    readonly namespace?: string;
    /**
    * Full path of the KV-V1 secret.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secret#path DataVaultKvSecret#path}
    */
    readonly path: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/kv_secret vault_kv_secret}
*/
export declare class DataVaultKvSecret extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_kv_secret";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/kv_secret vault_kv_secret} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultKvSecretConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultKvSecretConfig);
    private _data;
    get data(): cdktf.StringMap;
    get dataJson(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get leaseDuration(): number;
    get leaseId(): string;
    get leaseRenewable(): cdktf.IResolvable;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
