import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultTransformDecodeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a list of items to be decoded in a single batch. If this parameter is set, the top-level parameters 'value', 'transformation' and 'tweak' will be ignored. Each batch item within the list can specify these parameters instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_decode#batch_input DataVaultTransformDecode#batch_input}
    */
    readonly batchInput?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
    * The result of decoding batch_input.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_decode#batch_results DataVaultTransformDecode#batch_results}
    */
    readonly batchResults?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
    * The result of decoding a value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_decode#decoded_value DataVaultTransformDecode#decoded_value}
    */
    readonly decodedValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_decode#id DataVaultTransformDecode#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_decode#namespace DataVaultTransformDecode#namespace}
    */
    readonly namespace?: string;
    /**
    * Path to backend from which to retrieve data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_decode#path DataVaultTransformDecode#path}
    */
    readonly path: string;
    /**
    * The name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_decode#role_name DataVaultTransformDecode#role_name}
    */
    readonly roleName: string;
    /**
    * The transformation to perform. If no value is provided and the role contains a single transformation, this value will be inferred from the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_decode#transformation DataVaultTransformDecode#transformation}
    */
    readonly transformation?: string;
    /**
    * The tweak value to use. Only applicable for FPE transformations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_decode#tweak DataVaultTransformDecode#tweak}
    */
    readonly tweak?: string;
    /**
    * The value in which to decode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_decode#value DataVaultTransformDecode#value}
    */
    readonly value?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/transform_decode vault_transform_decode}
*/
export declare class DataVaultTransformDecode extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_transform_decode";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/transform_decode vault_transform_decode} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultTransformDecodeConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultTransformDecodeConfig);
    private _batchInput?;
    get batchInput(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set batchInput(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    resetBatchInput(): void;
    get batchInputInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _batchResults?;
    get batchResults(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set batchResults(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    resetBatchResults(): void;
    get batchResultsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _decodedValue?;
    get decodedValue(): string;
    set decodedValue(value: string);
    resetDecodedValue(): void;
    get decodedValueInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _transformation?;
    get transformation(): string;
    set transformation(value: string);
    resetTransformation(): void;
    get transformationInput(): string | undefined;
    private _tweak?;
    get tweak(): string;
    set tweak(value: string);
    resetTweak(): void;
    get tweakInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
