import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultTransitDecryptConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Transit secret backend the key belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt#backend DataVaultTransitDecrypt#backend}
    */
    readonly backend: string;
    /**
    * Transit encrypted cipher text.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt#ciphertext DataVaultTransitDecrypt#ciphertext}
    */
    readonly ciphertext: string;
    /**
    * Specifies the context for key derivation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt#context DataVaultTransitDecrypt#context}
    */
    readonly context?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt#id DataVaultTransitDecrypt#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the decryption key to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt#key DataVaultTransitDecrypt#key}
    */
    readonly key: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt#namespace DataVaultTransitDecrypt#namespace}
    */
    readonly namespace?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt vault_transit_decrypt}
*/
export declare class DataVaultTransitDecrypt extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_transit_decrypt";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt vault_transit_decrypt} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultTransitDecryptConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultTransitDecryptConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _ciphertext?;
    get ciphertext(): string;
    set ciphertext(value: string);
    get ciphertextInput(): string | undefined;
    private _context?;
    get context(): string;
    set context(value: string);
    resetContext(): void;
    get contextInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get plaintext(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
