import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmipSecretBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * Client certificate key bits, valid values depend on key type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend#default_tls_client_key_bits KmipSecretBackend#default_tls_client_key_bits}
    */
    readonly defaultTlsClientKeyBits?: number;
    /**
    * Client certificate key type, rsa or ec
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend#default_tls_client_key_type KmipSecretBackend#default_tls_client_key_type}
    */
    readonly defaultTlsClientKeyType?: string;
    /**
    * Client certificate TTL in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend#default_tls_client_ttl KmipSecretBackend#default_tls_client_ttl}
    */
    readonly defaultTlsClientTtl?: number;
    /**
    * Human-friendly description of the mount for the backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend#description KmipSecretBackend#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend#id KmipSecretBackend#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Addresses the KMIP server should listen on (host:port)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend#listen_addrs KmipSecretBackend#listen_addrs}
    */
    readonly listenAddrs?: string[];
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend#namespace KmipSecretBackend#namespace}
    */
    readonly namespace?: string;
    /**
    * Path where KMIP secret backend will be mounted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend#path KmipSecretBackend#path}
    */
    readonly path: string;
    /**
    * Hostnames to include in the server's TLS certificate as SAN DNS names. The first will be used as the common name (CN)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend#server_hostnames KmipSecretBackend#server_hostnames}
    */
    readonly serverHostnames?: string[];
    /**
    * IPs to include in the server's TLS certificate as SAN IP addresses
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend#server_ips KmipSecretBackend#server_ips}
    */
    readonly serverIps?: string[];
    /**
    * CA key bits, valid values depend on key type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend#tls_ca_key_bits KmipSecretBackend#tls_ca_key_bits}
    */
    readonly tlsCaKeyBits?: number;
    /**
    * CA key type, rsa or ec
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend#tls_ca_key_type KmipSecretBackend#tls_ca_key_type}
    */
    readonly tlsCaKeyType?: string;
    /**
    * Minimum TLS version to accept
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend#tls_min_version KmipSecretBackend#tls_min_version}
    */
    readonly tlsMinVersion?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend vault_kmip_secret_backend}
*/
export declare class KmipSecretBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_kmip_secret_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend vault_kmip_secret_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmipSecretBackendConfig
    */
    constructor(scope: Construct, id: string, config: KmipSecretBackendConfig);
    private _defaultTlsClientKeyBits?;
    get defaultTlsClientKeyBits(): number;
    set defaultTlsClientKeyBits(value: number);
    resetDefaultTlsClientKeyBits(): void;
    get defaultTlsClientKeyBitsInput(): number | undefined;
    private _defaultTlsClientKeyType?;
    get defaultTlsClientKeyType(): string;
    set defaultTlsClientKeyType(value: string);
    resetDefaultTlsClientKeyType(): void;
    get defaultTlsClientKeyTypeInput(): string | undefined;
    private _defaultTlsClientTtl?;
    get defaultTlsClientTtl(): number;
    set defaultTlsClientTtl(value: number);
    resetDefaultTlsClientTtl(): void;
    get defaultTlsClientTtlInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _listenAddrs?;
    get listenAddrs(): string[];
    set listenAddrs(value: string[]);
    resetListenAddrs(): void;
    get listenAddrsInput(): string[] | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _serverHostnames?;
    get serverHostnames(): string[];
    set serverHostnames(value: string[]);
    resetServerHostnames(): void;
    get serverHostnamesInput(): string[] | undefined;
    private _serverIps?;
    get serverIps(): string[];
    set serverIps(value: string[]);
    resetServerIps(): void;
    get serverIpsInput(): string[] | undefined;
    private _tlsCaKeyBits?;
    get tlsCaKeyBits(): number;
    set tlsCaKeyBits(value: number);
    resetTlsCaKeyBits(): void;
    get tlsCaKeyBitsInput(): number | undefined;
    private _tlsCaKeyType?;
    get tlsCaKeyType(): string;
    set tlsCaKeyType(value: string);
    resetTlsCaKeyType(): void;
    get tlsCaKeyTypeInput(): string | undefined;
    private _tlsMinVersion?;
    get tlsMinVersion(): string;
    set tlsMinVersion(value: string);
    resetTlsMinVersion(): void;
    get tlsMinVersionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
