import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesSecretBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The list of Kubernetes namespaces this role can generate credentials for. If set to '*' all namespaces are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#allowed_kubernetes_namespaces KubernetesSecretBackendRole#allowed_kubernetes_namespaces}
    */
    readonly allowedKubernetesNamespaces: string[];
    /**
    * The mount path for the Kubernetes secrets engine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#backend KubernetesSecretBackendRole#backend}
    */
    readonly backend: string;
    /**
    * Additional annotations to apply to all generated Kubernetes objects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#extra_annotations KubernetesSecretBackendRole#extra_annotations}
    */
    readonly extraAnnotations?: {
        [key: string]: string;
    };
    /**
    * Additional labels to apply to all generated Kubernetes objects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#extra_labels KubernetesSecretBackendRole#extra_labels}
    */
    readonly extraLabels?: {
        [key: string]: string;
    };
    /**
    * The Role or ClusterRole rules to use when generating a role. Accepts either JSON or YAML formatted rules. Mutually exclusive with 'service_account_name' and 'kubernetes_role_name'. If set, the entire chain of Kubernetes objects will be generated when credentials are requested.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#generated_role_rules KubernetesSecretBackendRole#generated_role_rules}
    */
    readonly generatedRoleRules?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#id KubernetesSecretBackendRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The pre-existing Role or ClusterRole to bind a generated service account to. Mutually exclusive with 'service_account_name' and 'generated_role_rules'. If set, Kubernetes token, service account, and role binding objects will be created when credentials are requested.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#kubernetes_role_name KubernetesSecretBackendRole#kubernetes_role_name}
    */
    readonly kubernetesRoleName?: string;
    /**
    * Specifies whether the Kubernetes role is a Role or ClusterRole.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#kubernetes_role_type KubernetesSecretBackendRole#kubernetes_role_type}
    */
    readonly kubernetesRoleType?: string;
    /**
    * The name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#name KubernetesSecretBackendRole#name}
    */
    readonly name: string;
    /**
    * The name template to use when generating service accounts, roles and role bindings. If unset, a default template is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#name_template KubernetesSecretBackendRole#name_template}
    */
    readonly nameTemplate?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#namespace KubernetesSecretBackendRole#namespace}
    */
    readonly namespace?: string;
    /**
    * The pre-existing service account to generate tokens for. Mutually exclusive with 'kubernetes_role_name' and 'generated_role_rules'. If set, only a Kubernetes token will be created when credentials are requested.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#service_account_name KubernetesSecretBackendRole#service_account_name}
    */
    readonly serviceAccountName?: string;
    /**
    * The default TTL for generated Kubernetes tokens in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#token_default_ttl KubernetesSecretBackendRole#token_default_ttl}
    */
    readonly tokenDefaultTtl?: number;
    /**
    * The maximum TTL for generated Kubernetes tokens in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role#token_max_ttl KubernetesSecretBackendRole#token_max_ttl}
    */
    readonly tokenMaxTtl?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role vault_kubernetes_secret_backend_role}
*/
export declare class KubernetesSecretBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_kubernetes_secret_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_secret_backend_role vault_kubernetes_secret_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesSecretBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: KubernetesSecretBackendRoleConfig);
    private _allowedKubernetesNamespaces?;
    get allowedKubernetesNamespaces(): string[];
    set allowedKubernetesNamespaces(value: string[]);
    get allowedKubernetesNamespacesInput(): string[] | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _extraAnnotations?;
    get extraAnnotations(): {
        [key: string]: string;
    };
    set extraAnnotations(value: {
        [key: string]: string;
    });
    resetExtraAnnotations(): void;
    get extraAnnotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _extraLabels?;
    get extraLabels(): {
        [key: string]: string;
    };
    set extraLabels(value: {
        [key: string]: string;
    });
    resetExtraLabels(): void;
    get extraLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _generatedRoleRules?;
    get generatedRoleRules(): string;
    set generatedRoleRules(value: string);
    resetGeneratedRoleRules(): void;
    get generatedRoleRulesInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kubernetesRoleName?;
    get kubernetesRoleName(): string;
    set kubernetesRoleName(value: string);
    resetKubernetesRoleName(): void;
    get kubernetesRoleNameInput(): string | undefined;
    private _kubernetesRoleType?;
    get kubernetesRoleType(): string;
    set kubernetesRoleType(value: string);
    resetKubernetesRoleType(): void;
    get kubernetesRoleTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nameTemplate?;
    get nameTemplate(): string;
    set nameTemplate(value: string);
    resetNameTemplate(): void;
    get nameTemplateInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _serviceAccountName?;
    get serviceAccountName(): string;
    set serviceAccountName(value: string);
    resetServiceAccountName(): void;
    get serviceAccountNameInput(): string | undefined;
    private _tokenDefaultTtl?;
    get tokenDefaultTtl(): number;
    set tokenDefaultTtl(value: number);
    resetTokenDefaultTtl(): void;
    get tokenDefaultTtlInput(): number | undefined;
    private _tokenMaxTtl?;
    get tokenMaxTtl(): number;
    set tokenMaxTtl(value: number);
    resetTokenMaxTtl(): void;
    get tokenMaxTtlInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
