# Generated by Django 3.1.13 on 2021-08-12 20:17

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("nautobot_version_control", "0004_constraintviolations"),
    ]

    operations = [
        migrations.CreateModel(
            name="PullRequest",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                    ),
                ),
                ("title", models.CharField(max_length=240)),
                ("state", models.IntegerField(default=0)),
                ("source_branch", models.TextField()),
                ("destination_branch", models.TextField()),
                ("description", models.TextField()),
                ("created_at", models.DateField(auto_now_add=True, null=True)),
                (
                    "creator",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "pull requests",
                "db_table": "nautobot_version_control_pull_request",
            },
        ),
        migrations.CreateModel(
            name="PullRequestReview",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                    ),
                ),
                ("reviewed_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("state", models.IntegerField(null=True)),
                ("summary", models.TextField()),
                (
                    "pull_request",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="nautobot_version_control.pullrequest",
                    ),
                ),
                (
                    "reviewer",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "pull request reviews",
                "db_table": "nautobot_version_control_pull_request_review",
            },
        ),
    ]
