# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nautobot_version_control',
 'nautobot_version_control.api',
 'nautobot_version_control.dynamic',
 'nautobot_version_control.graphql',
 'nautobot_version_control.management.commands',
 'nautobot_version_control.migrations']

package_data = \
{'': ['*'],
 'nautobot_version_control': ['templates/nautobot_version_control/*',
                              'templates/nautobot_version_control/pull_request/*']}

install_requires = \
['mysqlclient>=2.0.3,<3.0.0', 'nautobot>=1.2.0,<1.3.0']

setup_kwargs = {
    'name': 'nautobot-version-control',
    'version': '1.0.0a0',
    'description': 'Nautobot Version Control',
    'long_description': '# Nautobot Version Control\n\nThe Nautobot Version Control app brings version control to the [Nautobot](https://github.com/nautobot/nautobot) open source Network Source of Truth and Network Automation Platform. \n\nNautobot provides a number of features to validate its data model and safeguard network configuration from errors. Adding database versioning provides another layer of assurance by enabling human review of proposed changes to production data, use of automated testing pipelines, and database rollback in the case of errors. \n\nThe database versioning is made possible by the use of a [Dolt](https://github.com/dolthub/dolt) database. Dolt is a MySQL-compatible SQL database that you can fork, clone, branch, merge, push and pull just like a Git repository.\n\nDolt’s *branch* and *merge* versioning model allows operators to safely modify the data model on feature branches, merging to production only after validation is complete.\n\n## Documentation\n\nIn addition to this `README` file, there are docs covering the following topics:\n\n* [Version control operations](docs/version-control-operations.md)\n  * Covers common version control operations in the Version Control app\n* [Common workflows](docs/workflows/common_workflows.md)\n  * Covers common workflows enabled by the Version Control app\n* [Design](docs/design.md)\n  * Describes the technical design and implementation details of the Version Control app\n\n## Installation\n\n### Installation Considerations\n\nThere are some special considerations for running the Version Control app:\n\n* Nautobot 1.2.0 or later is required\n* The Nautobot installation **must** be running a Dolt database\n* There are some [additional configurations](#configuring-nautobot-to-use-version-control) required in `nautobot_config.py`\n\nThe version control app can be installed with pip3:\n\n```no-highlight\npip3 install nautobot-version-control\n```\n\nTo ensure the version control app is automatically reinstalled during future upgrades, create a new file named `local_requirements.txt` (if not already existing) in the Nautobot root directory (e.g. `/opt/nautobot`) to include the `nautobot-version-control` package:\n\n```no-highlight\necho nautobot-version-control >> local_requirements.txt\n```\n\n### Configuring Nautobot to use Version Control\n\nAdd this to your `nautobot_config.py` to prepare your Nautobot settings for Dolt:\n\n```python\n# Dolt requires a second database using the same credentials as the default database so that it may \n# generate diffs.\nDATABASES["global"] = DATABASES["default"]\n\n# Dolt requires a custom database router to generate the before & after queries for generating diffs.\nDATABASE_ROUTERS = ["dolt.routers.GlobalStateRouter"]\n\n# Because Dolt creates branches of the database, the default database sessions cannot be used. We \n# must tell Nautobot to use Redis for sessions instead. This adds a distinct cache configuration for\n# using Redis cache for sessions.\n# See: https://github.com/jazzband/django-redis#configure-as-session-backend\nCACHES["sessions"] = {\n    "BACKEND": "django_redis.cache.RedisCache",\n    "LOCATION": parse_redis_connection(redis_database=2),\n    "TIMEOUT": 300,\n    "OPTIONS": {\n        "CLIENT_CLASS": "django_redis.client.DefaultClient",\n    },\n}\n\n# Use the sessions alias defined in CACHES for sessions caching\nSESSION_CACHE_ALIAS = "sessions"\n\n# Use the Redis cache as the session engine\nSESSION_ENGINE = "django.contrib.sessions.backends.cache"\n\n# Enable the Version Control app\nPLUGINS = [ "nautobot_version_control" ]\n```\n\nThen run database migrations:\n\n```no-highlight\n$ nautobot-server migrate\n```\n\n### Production Deployment\n\nTBD as we progress towards stable release.\n\n## Development Environment\n\nIn addition to the instructions below, we also have a [demonstration video](https://youtu.be/XHrTHwhbZLc) that walks the user through the dev and test setup process described below. \n\n### Getting Started\n\nGetting started with development for the Version Control plugin is straightforward. It is modeled directly after the development environment of Nautobot itself, and should feel very familiar to anyone with Django development experience.\n\nThe Version Control app uses a Docker Compose environment to make it simple to manage dependencies like Dolt and Redis.\n\n### Install Invoke\n\nBecause it is used to execute all common Docker workflow tasks, Invoke must be installed for your user environment. \nOn most systems, if you\'re installing without root/superuser permissions, the default will install into your local user environment.\n\n```no-highlight\n$ pip3 install invoke\n```\n\nIf you run into issues, you may also deliberately tell pip3 to install into your user environment by adding the --user flag:\n\n```no-highlight\n$ pip3 install --user invoke\n```\n\n### List Invoke Tasks\n\nNow that you have an invoke command, list the tasks defined in tasks.py with `invoke --list`:\n\n```no-highlight\n$ invoke --list\nAvailable tasks:\n\n  bandit              Run bandit to validate basic static code security analysis.\n  black               Check Python code style with Black.\n  build               Build Nautobot docker image.\n  check-migrations    Check for missing migrations.\n  cli                 Launch a bash shell inside the running Nautobot container.\n  createsuperuser     Create a new Nautobot superuser account (default: "admin"), will prompt for password.\n  debug               Start Nautobot and its dependencies in debug mode.\n  destroy             Destroy all containers and volumes.\n  flake8              Check for PEP8 compliance and other style issues.\n  generate-packages   Generate all Python packages inside docker and copy the file locally under dist/.\n  hadolint            Check Dockerfile for hadolint compliance and other style issues.\n  load-data           Load data.\n  makemigrations      Perform makemigrations operation in Django.\n  migrate             Perform migrate operation in Django.\n  nbshell             Launch an interactive nbshell session.\n  post-upgrade        Performs Nautobot common post-upgrade operations using a single entrypoint.\n  pydocstyle          Run pydocstyle to validate docstring formatting adheres to NTC defined standards.\n  pylint              Run pylint code analysis.\n  restart             Gracefully restart all containers.\n  sphinx              Rebuild Sphinx documentation on changes, with live-reload in the\n                      browser.\n  start               Start Nautobot and its dependencies in detached mode.\n  stop                Stop Nautobot and its dependencies.\n  tests               Run all tests for this plugin.\n  unittest            Run Nautobot unit tests.\n  unittest-coverage   Report on code test coverage as measured by \'invoke unittest\'.\n  vscode              Launch Visual Studio Code with the appropriate Environment variables to run in a container.\n  yamllint            Run yamllint to validate formating adheres to NTC defined YAML standards.\n```\n\n### Using Docker with Invoke\n\nA development environment can be easily started up from the root of the project using commands detailed below.\n\n### Initialize the Local environment\n\nRun the following commmands to initialize the local environment:\n\n```\ncp development/creds.example.env development/creds.env\ninvoke build\n```\n\nFrom here, you can either [start the local environment with a sample database](#start-the-local-environment-with-a-sample-database) or [start the local environment with an empty database](#start-the-local-environment-with-an-empty-database).\n\n### Start the Local environment with a sample database\n\nThis is a good option for those who want to quickly spin up a working instance of Nautobot running the Version Control app. The steps below will create a Nautobot instance running Version Control and install sample data to experiment with.\n\n```\ninvoke migrate\ninvoke load-data\ninvoke start\n```\n\n> `invoke load-data` can take up to 30 min to run and it will generate many warning messages which may be safely ignored.\n\nAfter a few minutes, Nautobot will be available at `http://0.0.0.0:8080` \n\nYou can connect with either of these 2 accounts:\n\n* Login `admin` / Password `admin`\n* Login `demo` / Password `nautobot`\n\n\nRun the following commands to reset the local environment and load the sample dataset again:\n\n```\ninvoke stop\ninvoke destroy\ninvoke migrate\ninvoke load-data\ninvoke start\n```\n\n### Start the Local environment with an empty database\n\nThis option will simply start the local dev environment. Nautobot will have an empty database:\n\n```\ninvoke migrate\ninvoke start\n```\n\nAfter a few minutes, Nautobot will be available at `http://0.0.0.0:8080` \n\nYou can connect with:\n\n- Login `admin` / Password `admin`\n\nRun the following commands to reset the local environment:\n\n```\ninvoke stop\ninvoke destroy\ninvoke migrate\ninvoke start\n```\n',
    'author': 'Network to Code, LLC',
    'author_email': 'opensource@networktocode.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/nautobot/nautobot-plugin-version-control',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
