# coding: utf-8

"""
    FINBOURNE Notifications API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.1.311
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from lusid_notifications.configuration import Configuration


class UndeliveredMessage(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
      required_map (dict): The key is attribute name
                           and the value is whether it is 'required' or 'optional'.
    """
    openapi_types = {
        'delivery_id': 'str',
        'event_id': 'str',
        'subscription_identifier': 'ResourceId',
        'notification_id': 'str',
        'delivery_channel': 'str',
        'message_details': 'str',
        'delivery_attempts': 'list[DeliveryAttempt]'
    }

    attribute_map = {
        'delivery_id': 'deliveryId',
        'event_id': 'eventId',
        'subscription_identifier': 'subscriptionIdentifier',
        'notification_id': 'notificationId',
        'delivery_channel': 'deliveryChannel',
        'message_details': 'messageDetails',
        'delivery_attempts': 'deliveryAttempts'
    }

    required_map = {
        'delivery_id': 'required',
        'event_id': 'required',
        'subscription_identifier': 'required',
        'notification_id': 'required',
        'delivery_channel': 'required',
        'message_details': 'required',
        'delivery_attempts': 'required'
    }

    def __init__(self, delivery_id=None, event_id=None, subscription_identifier=None, notification_id=None, delivery_channel=None, message_details=None, delivery_attempts=None, local_vars_configuration=None):  # noqa: E501
        """UndeliveredMessage - a model defined in OpenAPI"
        
        :param delivery_id:  The identifier of the delivery message (required)
        :type delivery_id: str
        :param event_id:  The identifier of the event generated by Notifications Service (required)
        :type event_id: str
        :param subscription_identifier:  (required)
        :type subscription_identifier: lusid_notifications.ResourceId
        :param notification_id:  The identifier of the notification (required)
        :type notification_id: str
        :param delivery_channel:  The delivery channel of the message (required)
        :type delivery_channel: str
        :param message_details:  The Details of the delivery message as JSON string (required)
        :type message_details: str
        :param delivery_attempts:  A list of all the delivery attempts made for this message (required)
        :type delivery_attempts: list[lusid_notifications.DeliveryAttempt]

        """  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._delivery_id = None
        self._event_id = None
        self._subscription_identifier = None
        self._notification_id = None
        self._delivery_channel = None
        self._message_details = None
        self._delivery_attempts = None
        self.discriminator = None

        self.delivery_id = delivery_id
        self.event_id = event_id
        self.subscription_identifier = subscription_identifier
        self.notification_id = notification_id
        self.delivery_channel = delivery_channel
        self.message_details = message_details
        self.delivery_attempts = delivery_attempts

    @property
    def delivery_id(self):
        """Gets the delivery_id of this UndeliveredMessage.  # noqa: E501

        The identifier of the delivery message  # noqa: E501

        :return: The delivery_id of this UndeliveredMessage.  # noqa: E501
        :rtype: str
        """
        return self._delivery_id

    @delivery_id.setter
    def delivery_id(self, delivery_id):
        """Sets the delivery_id of this UndeliveredMessage.

        The identifier of the delivery message  # noqa: E501

        :param delivery_id: The delivery_id of this UndeliveredMessage.  # noqa: E501
        :type delivery_id: str
        """
        if self.local_vars_configuration.client_side_validation and delivery_id is None:  # noqa: E501
            raise ValueError("Invalid value for `delivery_id`, must not be `None`")  # noqa: E501

        self._delivery_id = delivery_id

    @property
    def event_id(self):
        """Gets the event_id of this UndeliveredMessage.  # noqa: E501

        The identifier of the event generated by Notifications Service  # noqa: E501

        :return: The event_id of this UndeliveredMessage.  # noqa: E501
        :rtype: str
        """
        return self._event_id

    @event_id.setter
    def event_id(self, event_id):
        """Sets the event_id of this UndeliveredMessage.

        The identifier of the event generated by Notifications Service  # noqa: E501

        :param event_id: The event_id of this UndeliveredMessage.  # noqa: E501
        :type event_id: str
        """
        if self.local_vars_configuration.client_side_validation and event_id is None:  # noqa: E501
            raise ValueError("Invalid value for `event_id`, must not be `None`")  # noqa: E501

        self._event_id = event_id

    @property
    def subscription_identifier(self):
        """Gets the subscription_identifier of this UndeliveredMessage.  # noqa: E501


        :return: The subscription_identifier of this UndeliveredMessage.  # noqa: E501
        :rtype: lusid_notifications.ResourceId
        """
        return self._subscription_identifier

    @subscription_identifier.setter
    def subscription_identifier(self, subscription_identifier):
        """Sets the subscription_identifier of this UndeliveredMessage.


        :param subscription_identifier: The subscription_identifier of this UndeliveredMessage.  # noqa: E501
        :type subscription_identifier: lusid_notifications.ResourceId
        """
        if self.local_vars_configuration.client_side_validation and subscription_identifier is None:  # noqa: E501
            raise ValueError("Invalid value for `subscription_identifier`, must not be `None`")  # noqa: E501

        self._subscription_identifier = subscription_identifier

    @property
    def notification_id(self):
        """Gets the notification_id of this UndeliveredMessage.  # noqa: E501

        The identifier of the notification  # noqa: E501

        :return: The notification_id of this UndeliveredMessage.  # noqa: E501
        :rtype: str
        """
        return self._notification_id

    @notification_id.setter
    def notification_id(self, notification_id):
        """Sets the notification_id of this UndeliveredMessage.

        The identifier of the notification  # noqa: E501

        :param notification_id: The notification_id of this UndeliveredMessage.  # noqa: E501
        :type notification_id: str
        """
        if self.local_vars_configuration.client_side_validation and notification_id is None:  # noqa: E501
            raise ValueError("Invalid value for `notification_id`, must not be `None`")  # noqa: E501

        self._notification_id = notification_id

    @property
    def delivery_channel(self):
        """Gets the delivery_channel of this UndeliveredMessage.  # noqa: E501

        The delivery channel of the message  # noqa: E501

        :return: The delivery_channel of this UndeliveredMessage.  # noqa: E501
        :rtype: str
        """
        return self._delivery_channel

    @delivery_channel.setter
    def delivery_channel(self, delivery_channel):
        """Sets the delivery_channel of this UndeliveredMessage.

        The delivery channel of the message  # noqa: E501

        :param delivery_channel: The delivery_channel of this UndeliveredMessage.  # noqa: E501
        :type delivery_channel: str
        """
        if self.local_vars_configuration.client_side_validation and delivery_channel is None:  # noqa: E501
            raise ValueError("Invalid value for `delivery_channel`, must not be `None`")  # noqa: E501

        self._delivery_channel = delivery_channel

    @property
    def message_details(self):
        """Gets the message_details of this UndeliveredMessage.  # noqa: E501

        The Details of the delivery message as JSON string  # noqa: E501

        :return: The message_details of this UndeliveredMessage.  # noqa: E501
        :rtype: str
        """
        return self._message_details

    @message_details.setter
    def message_details(self, message_details):
        """Sets the message_details of this UndeliveredMessage.

        The Details of the delivery message as JSON string  # noqa: E501

        :param message_details: The message_details of this UndeliveredMessage.  # noqa: E501
        :type message_details: str
        """
        if self.local_vars_configuration.client_side_validation and message_details is None:  # noqa: E501
            raise ValueError("Invalid value for `message_details`, must not be `None`")  # noqa: E501

        self._message_details = message_details

    @property
    def delivery_attempts(self):
        """Gets the delivery_attempts of this UndeliveredMessage.  # noqa: E501

        A list of all the delivery attempts made for this message  # noqa: E501

        :return: The delivery_attempts of this UndeliveredMessage.  # noqa: E501
        :rtype: list[lusid_notifications.DeliveryAttempt]
        """
        return self._delivery_attempts

    @delivery_attempts.setter
    def delivery_attempts(self, delivery_attempts):
        """Sets the delivery_attempts of this UndeliveredMessage.

        A list of all the delivery attempts made for this message  # noqa: E501

        :param delivery_attempts: The delivery_attempts of this UndeliveredMessage.  # noqa: E501
        :type delivery_attempts: list[lusid_notifications.DeliveryAttempt]
        """
        if self.local_vars_configuration.client_side_validation and delivery_attempts is None:  # noqa: E501
            raise ValueError("Invalid value for `delivery_attempts`, must not be `None`")  # noqa: E501

        self._delivery_attempts = delivery_attempts

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UndeliveredMessage):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UndeliveredMessage):
            return True

        return self.to_dict() != other.to_dict()
