# -*- coding: utf-8 -*-
################################################################################
#
#  Rattail -- Retail Software Framework
#  Copyright © 2010-2016 Lance Edgar
#
#  This file is part of Rattail.
#
#  Rattail is free software: you can redistribute it and/or modify it under the
#  terms of the GNU Affero General Public License as published by the Free
#  Software Foundation, either version 3 of the License, or (at your option)
#  any later version.
#
#  Rattail is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for
#  more details.
#
#  You should have received a copy of the GNU Affero General Public License
#  along with Rattail.  If not, see <http://www.gnu.org/licenses/>.
#
################################################################################
"""
Fabric Library

This subpackage contains various tasks and associated functions for use with
Fabric deployment and maintenance.
"""

from __future__ import unicode_literals, absolute_import

from .core import put, upload_template, make_deploy, mkdir, rsync
from .core import make_system_user, add_mail_alias, set_timezone, agent_sudo
from .core import get_debian_version, get_ubuntu_version

from .python import workon, cdvirtualenv
