"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExtensibleBase = exports.Extension = exports.Parameter = exports.Action = exports.EventBridgeDestination = exports.SnsDestination = exports.SqsDestination = exports.LambdaDestination = exports.SourceType = exports.ActionPoint = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_appconfig_1 = require("aws-cdk-lib/aws-appconfig");
const iam = require("aws-cdk-lib/aws-iam");
const hash_1 = require("./private/hash");
/**
 * Defines Extension action points.
 *
 * @see https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions-about.html#working-with-appconfig-extensions-how-it-works-step-2
 */
var ActionPoint;
(function (ActionPoint) {
    ActionPoint["PRE_CREATE_HOSTED_CONFIGURATION_VERSION"] = "PRE_CREATE_HOSTED_CONFIGURATION_VERSION";
    ActionPoint["PRE_START_DEPLOYMENT"] = "PRE_START_DEPLOYMENT";
    ActionPoint["ON_DEPLOYMENT_START"] = "ON_DEPLOYMENT_START";
    ActionPoint["ON_DEPLOYMENT_STEP"] = "ON_DEPLOYMENT_STEP";
    ActionPoint["ON_DEPLOYMENT_BAKING"] = "ON_DEPLOYMENT_BAKING";
    ActionPoint["ON_DEPLOYMENT_COMPLETE"] = "ON_DEPLOYMENT_COMPLETE";
    ActionPoint["ON_DEPLOYMENT_ROLLED_BACK"] = "ON_DEPLOYMENT_ROLLED_BACK";
})(ActionPoint || (exports.ActionPoint = ActionPoint = {}));
/**
 * Defines the source type for event destinations.
 */
var SourceType;
(function (SourceType) {
    SourceType["LAMBDA"] = "lambda";
    SourceType["SQS"] = "sqs";
    SourceType["SNS"] = "sns";
    SourceType["EVENTS"] = "events";
})(SourceType || (exports.SourceType = SourceType = {}));
/**
 * Use an AWS Lambda function as an event destination.
 */
class LambdaDestination {
    constructor(func) {
        this.extensionUri = func.functionArn;
        this.type = SourceType.LAMBDA;
        const policy = new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: [this.extensionUri],
            actions: [
                'lambda:InvokeFunction',
                'lambda:InvokeAsync',
            ],
        });
        this.policyDocument = new iam.PolicyDocument({
            statements: [policy],
        });
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "@aws-cdk/aws-appconfig-alpha.LambdaDestination", version: "2.106.0-alpha.0" };
/**
 * Use an Amazon SQS queue as an event destination.
 */
class SqsDestination {
    constructor(queue) {
        this.extensionUri = queue.queueArn;
        this.type = SourceType.SQS;
        const policy = new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: [this.extensionUri],
            actions: ['sqs:SendMessage'],
        });
        this.policyDocument = new iam.PolicyDocument({
            statements: [policy],
        });
    }
}
exports.SqsDestination = SqsDestination;
_b = JSII_RTTI_SYMBOL_1;
SqsDestination[_b] = { fqn: "@aws-cdk/aws-appconfig-alpha.SqsDestination", version: "2.106.0-alpha.0" };
/**
 * Use an Amazon SNS topic as an event destination.
 */
class SnsDestination {
    constructor(topic) {
        this.extensionUri = topic.topicArn;
        this.type = SourceType.SNS;
        const policy = new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: [this.extensionUri],
            actions: ['sns:Publish'],
        });
        this.policyDocument = new iam.PolicyDocument({
            statements: [policy],
        });
    }
}
exports.SnsDestination = SnsDestination;
_c = JSII_RTTI_SYMBOL_1;
SnsDestination[_c] = { fqn: "@aws-cdk/aws-appconfig-alpha.SnsDestination", version: "2.106.0-alpha.0" };
/**
 * Use an Amazon EventBridge event bus as an event destination.
 */
class EventBridgeDestination {
    constructor(bus) {
        this.extensionUri = bus.eventBusArn;
        this.type = SourceType.EVENTS;
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
_d = JSII_RTTI_SYMBOL_1;
EventBridgeDestination[_d] = { fqn: "@aws-cdk/aws-appconfig-alpha.EventBridgeDestination", version: "2.106.0-alpha.0" };
/**
 * Defines an action for an extension.
 */
class Action {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Action);
            }
            throw error;
        }
        this.actionPoints = props.actionPoints;
        this.eventDestination = props.eventDestination;
        this.name = props.name;
        this.executionRole = props.executionRole;
        this.description = props.description;
        this.invokeWithoutExecutionRole = props.invokeWithoutExecutionRole || false;
    }
}
exports.Action = Action;
_e = JSII_RTTI_SYMBOL_1;
Action[_e] = { fqn: "@aws-cdk/aws-appconfig-alpha.Action", version: "2.106.0-alpha.0" };
/**
 * Defines a parameter for an extension.
 */
class Parameter {
    /**
     * A required parameter for an extension.
     *
     * @param name The name of the parameter
     * @param value The value of the parameter
     * @param description A description for the parameter
     */
    static required(name, value, description) {
        return new Parameter(name, true, value, description);
    }
    /**
     * An optional parameter for an extension.
     *
     * @param name The name of the parameter
     * @param value The value of the parameter
     * @param description A description for the parameter
     */
    static notRequired(name, value, description) {
        return new Parameter(name, false, value, description);
    }
    constructor(name, isRequired, value, description) {
        this.name = name;
        this.isRequired = isRequired;
        this.value = value;
        this.description = description;
    }
}
exports.Parameter = Parameter;
_f = JSII_RTTI_SYMBOL_1;
Parameter[_f] = { fqn: "@aws-cdk/aws-appconfig-alpha.Parameter", version: "2.106.0-alpha.0" };
/**
 * An AWS AppConfig extension.
 *
 * @resource AWS::AppConfig::Extension
 * @see https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html
 */
class Extension extends aws_cdk_lib_1.Resource {
    /**
     * Imports an extension into the CDK using its Amazon Resource Name (ARN).
     *
     * @param scope The parent construct
     * @param id The name of the extension construct
     * @param extensionArn The Amazon Resource Name (ARN) of the extension
     */
    static fromExtensionArn(scope, id, extensionArn) {
        const parsedArn = aws_cdk_lib_1.Stack.of(scope).splitArn(extensionArn, aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME);
        if (!parsedArn.resourceName) {
            throw new Error(`Missing required /$/{extensionId}//$/{extensionVersionNumber} from configuration profile ARN: ${parsedArn.resourceName}`);
        }
        const resourceName = parsedArn.resourceName.split('/');
        if (resourceName.length != 2 || !resourceName[0] || !resourceName[1]) {
            throw new Error('Missing required parameters for extension ARN: format should be /$/{extensionId}//$/{extensionVersionNumber}');
        }
        const extensionId = resourceName[0];
        const extensionVersionNumber = resourceName[1];
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.extensionId = extensionId;
                this.extensionVersionNumber = parseInt(extensionVersionNumber);
                this.extensionArn = extensionArn;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: extensionArn,
        });
    }
    /**
     * Imports an extension into the CDK using its attributes.
     *
     * @param scope The parent construct
     * @param id The name of the extension construct
     * @param attrs The attributes of the extension
     */
    static fromExtensionAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromExtensionAttributes);
            }
            throw error;
        }
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const extensionArn = attrs.extensionArn || stack.formatArn({
            service: 'appconfig',
            resource: 'extension',
            resourceName: `${attrs.extensionId}/${attrs.extensionVersionNumber}`,
        });
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.extensionId = attrs.extensionId;
                this.extensionVersionNumber = attrs.extensionVersionNumber;
                this.extensionArn = extensionArn;
                this.name = attrs.name;
                this.actions = attrs.actions;
                this.description = attrs.description;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: extensionArn,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.name,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Extension);
            }
            throw error;
        }
        this.actions = props.actions;
        this.name = props.name || aws_cdk_lib_1.Names.uniqueResourceName(this, {
            maxLength: 64,
            separator: '-',
        });
        this.description = props.description;
        this.latestVersionNumber = props.latestVersionNumber;
        this.parameters = props.parameters;
        const resource = new aws_appconfig_1.CfnExtension(this, 'Resource', {
            actions: this.actions.reduce((acc, cur) => {
                const extensionUri = cur.eventDestination.extensionUri;
                const sourceType = cur.eventDestination.type;
                this.executionRole = cur.executionRole;
                cur.actionPoints.forEach((actionPoint) => {
                    acc[actionPoint] = [
                        {
                            Name: cur.name || aws_cdk_lib_1.Names.uniqueResourceName(this, {
                                maxLength: 64,
                                separator: '-',
                            }),
                            Uri: extensionUri,
                            ...(sourceType === SourceType.EVENTS || cur.invokeWithoutExecutionRole
                                ? {}
                                : { RoleArn: this.executionRole?.roleArn || this.getExecutionRole(cur.eventDestination).roleArn }),
                            ...(cur.description ? { Description: cur.description } : {}),
                        },
                    ];
                });
                return acc;
            }, {}),
            name: this.name,
            description: this.description,
            latestVersionNumber: this.latestVersionNumber,
            parameters: this.parameters?.reduce((acc, cur) => {
                acc[cur.name] = {
                    required: cur.isRequired,
                    description: cur.description,
                };
                return acc;
            }, {}),
        });
        this._cfnExtension = resource;
        this.extensionId = this._cfnExtension.attrId;
        this.extensionVersionNumber = this._cfnExtension.attrVersionNumber;
        this.extensionArn = this.getResourceArnAttribute(this._cfnExtension.attrArn, {
            service: 'appconfig',
            resource: 'extension',
            resourceName: `${this.extensionId}/${this.extensionVersionNumber}`,
        });
    }
    getExecutionRole(eventDestination) {
        this.executionRole = new iam.Role(this, `Role${(0, hash_1.getHash)(eventDestination.extensionUri)}`, {
            roleName: aws_cdk_lib_1.PhysicalName.GENERATE_IF_NEEDED,
            assumedBy: new iam.ServicePrincipal('appconfig.amazonaws.com'),
            inlinePolicies: {
                ['AllowAppConfigInvokeExtensionEventSourcePolicy']: eventDestination.policyDocument,
            },
        });
        return this.executionRole;
    }
}
exports.Extension = Extension;
_g = JSII_RTTI_SYMBOL_1;
Extension[_g] = { fqn: "@aws-cdk/aws-appconfig-alpha.Extension", version: "2.106.0-alpha.0" };
/**
 * This class is meant to be used by AWS AppConfig resources (application,
 * configuration profile, environment) directly. There is currently no use
 * for this class outside of the AWS AppConfig construct implementation. It is
 * intended to be used with the resources since there is currently no way to
 * inherit from two classes (at least within JSII constraints).
 */
class ExtensibleBase {
    constructor(scope, resourceArn, resourceName) {
        this.resourceArn = resourceArn;
        this.resourceName = resourceName;
        this.scope = scope;
    }
    on(actionPoint, eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ActionPoint(actionPoint);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.on);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, actionPoint, options);
    }
    preCreateHostedConfigurationVersion(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.preCreateHostedConfigurationVersion);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.PRE_CREATE_HOSTED_CONFIGURATION_VERSION, options);
    }
    preStartDeployment(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.preStartDeployment);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.PRE_START_DEPLOYMENT, options);
    }
    onDeploymentStart(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onDeploymentStart);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.ON_DEPLOYMENT_START, options);
    }
    onDeploymentStep(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onDeploymentStep);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.ON_DEPLOYMENT_STEP, options);
    }
    onDeploymentBaking(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onDeploymentBaking);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.ON_DEPLOYMENT_BAKING, options);
    }
    onDeploymentComplete(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onDeploymentComplete);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.ON_DEPLOYMENT_COMPLETE, options);
    }
    onDeploymentRolledBack(eventDestination, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IEventDestination(eventDestination);
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_ExtensionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onDeploymentRolledBack);
            }
            throw error;
        }
        this.getExtensionForActionPoint(eventDestination, ActionPoint.ON_DEPLOYMENT_ROLLED_BACK, options);
    }
    addExtension(extension) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appconfig_alpha_IExtension(extension);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addExtension);
            }
            throw error;
        }
        this.addExtensionAssociation(extension, {
            parameters: extension.parameters,
        });
    }
    getExtensionForActionPoint(eventDestination, actionPoint, options) {
        const extension = new Extension(this.scope, `Extension${this.getExtensionHash(eventDestination, actionPoint, options)}`, {
            actions: [
                new Action({
                    eventDestination,
                    actionPoints: [
                        actionPoint,
                    ],
                }),
            ],
            ...(options?.description ? { description: options.description } : {}),
            ...(options?.latestVersionNumber ? { latestVersionNumber: options.latestVersionNumber } : {}),
            ...(options?.name ? { name: options.name } : {}),
            ...(options?.parameters ? { parameters: options.parameters } : {}),
        });
        this.addExtensionAssociation(extension, options);
    }
    addExtensionAssociation(extension, options) {
        new aws_appconfig_1.CfnExtensionAssociation(this.scope, `AssociationResource${this.getExtensionAssociationHash(extension)}`, {
            extensionIdentifier: extension.extensionId,
            resourceIdentifier: this.resourceArn,
            extensionVersionNumber: extension.extensionVersionNumber,
            parameters: options?.parameters?.reduce((acc, cur) => {
                if (cur.value) {
                    acc[cur.name] = cur.value;
                }
                return acc;
            }, {}),
        });
    }
    getExtensionHash(eventDestination, actionPoint, options) {
        const combinedString = (0, hash_1.stringifyObjects)(eventDestination, actionPoint, options);
        return (0, hash_1.getHash)(combinedString);
    }
    getExtensionAssociationHash(extension) {
        const resourceIdentifier = this.resourceName ? this.resourceName : this.resourceArn;
        const combinedString = (0, hash_1.stringifyObjects)(resourceIdentifier, extension.name, extension.extensionVersionNumber);
        return (0, hash_1.getHash)(combinedString);
    }
}
exports.ExtensibleBase = ExtensibleBase;
_h = JSII_RTTI_SYMBOL_1;
ExtensibleBase[_h] = { fqn: "@aws-cdk/aws-appconfig-alpha.ExtensibleBase", version: "2.106.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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