"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const secretsmanager_generated_1 = require("./secretsmanager.generated");
/**
 * A rotation schedule.
 */
class RotationSchedule extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new secretsmanager_generated_1.CfnRotationSchedule(this, 'Resource', {
            secretId: props.secret.secretArn,
            rotationLambdaArn: props.rotationLambda.functionArn,
            rotationRules: {
                automaticallyAfterDays: props.automaticallyAfter && props.automaticallyAfter.toDays() || 30,
            },
        });
    }
}
exports.RotationSchedule = RotationSchedule;
//# sourceMappingURL=data:application/json;base64,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