from typing import Any, List, Literal, TypedDict

from .FHIR_Annotation import FHIR_Annotation
from .FHIR_canonical import FHIR_canonical
from .FHIR_CarePlan_Activity import FHIR_CarePlan_Activity
from .FHIR_code import FHIR_code
from .FHIR_CodeableConcept import FHIR_CodeableConcept
from .FHIR_dateTime import FHIR_dateTime
from .FHIR_Element import FHIR_Element
from .FHIR_id import FHIR_id
from .FHIR_Identifier import FHIR_Identifier
from .FHIR_Meta import FHIR_Meta
from .FHIR_Narrative import FHIR_Narrative
from .FHIR_Period import FHIR_Period
from .FHIR_Reference import FHIR_Reference
from .FHIR_string import FHIR_string
from .FHIR_uri import FHIR_uri

# Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.
FHIR_CarePlan = TypedDict(
    "FHIR_CarePlan",
    {
        # This is a CarePlan resource
        "resourceType": Literal["CarePlan"],
        # The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.
        "id": FHIR_id,
        # The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.
        "meta": FHIR_Meta,
        # A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.
        "implicitRules": FHIR_uri,
        # Extensions for implicitRules
        "_implicitRules": FHIR_Element,
        # The base language in which the resource is written.
        "language": FHIR_code,
        # Extensions for language
        "_language": FHIR_Element,
        # A human-readable narrative that contains a summary of the resource and can be used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it "clinically safe" for a human to just read the narrative. Resource definitions may define what content should be represented in the narrative to ensure clinical safety.
        "text": FHIR_Narrative,
        # These resources do not have an independent existence apart from the resource that contains them - they cannot be identified independently, and nor can they have their own independent transaction scope.
        "contained": List[Any],
        # May be used to represent additional information that is not part of the basic definition of the resource. To make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
        "extension": List[Any],
        # May be used to represent additional information that is not part of the basic definition of the resource and that modifies the understanding of the element that contains it and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
        "modifierExtension": List[Any],
        # Business identifiers assigned to this care plan by the performer or other systems which remain constant as the resource is updated and propagates from server to server.
        "identifier": List[FHIR_Identifier],
        # The URL pointing to a FHIR-defined protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan.
        "instantiatesCanonical": List[FHIR_canonical],
        # The URL pointing to an externally maintained protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan.
        "instantiatesUri": List[FHIR_uri],
        # Extensions for instantiatesUri
        "_instantiatesUri": List[FHIR_Element],
        # A care plan that is fulfilled in whole or in part by this care plan.
        "basedOn": List[FHIR_Reference],
        # Completed or terminated care plan whose function is taken by this new care plan.
        "replaces": List[FHIR_Reference],
        # A larger care plan of which this particular care plan is a component or step.
        "partOf": List[FHIR_Reference],
        # Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.
        "status": FHIR_code,
        # Extensions for status
        "_status": FHIR_Element,
        # Indicates the level of authority/intentionality associated with the care plan and where the care plan fits into the workflow chain.
        "intent": FHIR_code,
        # Extensions for intent
        "_intent": FHIR_Element,
        # Identifies what "kind" of plan this is to support differentiation between multiple co-existing plans; e.g. "Home health", "psychiatric", "asthma", "disease management", "wellness plan", etc.
        "category": List[FHIR_CodeableConcept],
        # Human-friendly name for the care plan.
        "title": FHIR_string,
        # Extensions for title
        "_title": FHIR_Element,
        # A description of the scope and nature of the plan.
        "description": FHIR_string,
        # Extensions for description
        "_description": FHIR_Element,
        # Identifies the patient or group whose intended care is described by the plan.
        "subject": FHIR_Reference,
        # The Encounter during which this CarePlan was created or to which the creation of this record is tightly associated.
        "encounter": FHIR_Reference,
        # Indicates when the plan did (or is intended to) come into effect and end.
        "period": FHIR_Period,
        # Represents when this particular CarePlan record was created in the system, which is often a system-generated date.
        "created": FHIR_dateTime,
        # Extensions for created
        "_created": FHIR_Element,
        # When populated, the author is responsible for the care plan.  The care plan is attributed to the author.
        "author": FHIR_Reference,
        # Identifies the individual(s) or organization who provided the contents of the care plan.
        "contributor": List[FHIR_Reference],
        # Identifies all people and organizations who are expected to be involved in the care envisioned by this plan.
        "careTeam": List[FHIR_Reference],
        # Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan.
        "addresses": List[FHIR_Reference],
        # Identifies portions of the patient's record that specifically influenced the formation of the plan.  These might include comorbidities, recent procedures, limitations, recent assessments, etc.
        "supportingInfo": List[FHIR_Reference],
        # Describes the intended objective(s) of carrying out the care plan.
        "goal": List[FHIR_Reference],
        # Identifies a planned action to occur as part of the plan.  For example, a medication to be used, lab tests to perform, self-monitoring, education, etc.
        "activity": List[FHIR_CarePlan_Activity],
        # General notes about the care plan not covered elsewhere.
        "note": List[FHIR_Annotation],
    },
    total=False,
)
