from typing import Any, List, Literal, TypedDict

from .FHIR_code import FHIR_code
from .FHIR_CodeableConcept import FHIR_CodeableConcept
from .FHIR_DocumentReference_Content import FHIR_DocumentReference_Content
from .FHIR_DocumentReference_Context import FHIR_DocumentReference_Context
from .FHIR_DocumentReference_RelatesTo import FHIR_DocumentReference_RelatesTo
from .FHIR_Element import FHIR_Element
from .FHIR_id import FHIR_id
from .FHIR_Identifier import FHIR_Identifier
from .FHIR_instant import FHIR_instant
from .FHIR_Meta import FHIR_Meta
from .FHIR_Narrative import FHIR_Narrative
from .FHIR_Reference import FHIR_Reference
from .FHIR_string import FHIR_string
from .FHIR_uri import FHIR_uri

# A reference to a document of any kind for any purpose. Provides metadata about the document so that the document can be discovered and managed. The scope of a document is any seralized object with a mime-type, so includes formal patient centric documents (CDA), cliical notes, scanned paper, and non-patient specific documents like policy text.
FHIR_DocumentReference = TypedDict(
    "FHIR_DocumentReference",
    {
        # This is a DocumentReference resource
        "resourceType": Literal["DocumentReference"],
        # The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.
        "id": FHIR_id,
        # The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.
        "meta": FHIR_Meta,
        # A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.
        "implicitRules": FHIR_uri,
        # Extensions for implicitRules
        "_implicitRules": FHIR_Element,
        # The base language in which the resource is written.
        "language": FHIR_code,
        # Extensions for language
        "_language": FHIR_Element,
        # A human-readable narrative that contains a summary of the resource and can be used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it "clinically safe" for a human to just read the narrative. Resource definitions may define what content should be represented in the narrative to ensure clinical safety.
        "text": FHIR_Narrative,
        # These resources do not have an independent existence apart from the resource that contains them - they cannot be identified independently, and nor can they have their own independent transaction scope.
        "contained": List[Any],
        # May be used to represent additional information that is not part of the basic definition of the resource. To make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
        "extension": List[Any],
        # May be used to represent additional information that is not part of the basic definition of the resource and that modifies the understanding of the element that contains it and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
        "modifierExtension": List[Any],
        # Document identifier as assigned by the source of the document. This identifier is specific to this version of the document. This unique identifier may be used elsewhere to identify this version of the document.
        "masterIdentifier": FHIR_Identifier,
        # Other identifiers associated with the document, including version independent identifiers.
        "identifier": List[FHIR_Identifier],
        # The status of this document reference.
        "status": Literal["current", "superseded", "entered-in-error"],
        # Extensions for status
        "_status": FHIR_Element,
        # The status of the underlying document.
        "docStatus": FHIR_code,
        # Extensions for docStatus
        "_docStatus": FHIR_Element,
        # Specifies the particular kind of document referenced  (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.
        "type": FHIR_CodeableConcept,
        # A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type.
        "category": List[FHIR_CodeableConcept],
        # Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).
        "subject": FHIR_Reference,
        # When the document reference was created.
        "date": FHIR_instant,
        # Extensions for date
        "_date": FHIR_Element,
        # Identifies who is responsible for adding the information to the document.
        "author": List[FHIR_Reference],
        # Which person or organization authenticates that this document is valid.
        "authenticator": FHIR_Reference,
        # Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.
        "custodian": FHIR_Reference,
        # Relationships that this document has with other document references that already exist.
        "relatesTo": List[FHIR_DocumentReference_RelatesTo],
        # Human-readable description of the source document.
        "description": FHIR_string,
        # Extensions for description
        "_description": FHIR_Element,
        # A set of Security-Tag codes specifying the level of privacy/security of the Document. Note that DocumentReference.meta.security contains the security labels of the "reference" to the document, while DocumentReference.securityLabel contains a snapshot of the security labels on the document the reference refers to.
        "securityLabel": List[FHIR_CodeableConcept],
        # The document and format referenced. There may be multiple content element repetitions, each with a different format.
        "content": List[FHIR_DocumentReference_Content],
        # The clinical context in which the document was prepared.
        "context": FHIR_DocumentReference_Context,
    },
    total=False,
)
