from typing import Any, List, Literal, TypedDict

from .FHIR_CodeableConcept import FHIR_CodeableConcept
from .FHIR_Period import FHIR_Period
from .FHIR_Reference import FHIR_Reference
from .FHIR_string import FHIR_string

# A reference to a document of any kind for any purpose. Provides metadata about the document so that the document can be discovered and managed. The scope of a document is any seralized object with a mime-type, so includes formal patient centric documents (CDA), cliical notes, scanned paper, and non-patient specific documents like policy text.
FHIR_DocumentReference_Context = TypedDict(
    "FHIR_DocumentReference_Context",
    {
        # Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
        "id": FHIR_string,
        # May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
        "extension": List[Any],
        # May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
        "modifierExtension": List[Any],
        # Describes the clinical encounter or type of care that the document content is associated with.
        "encounter": List[FHIR_Reference],
        # This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the type Code, such as a "History and Physical Report" in which the procedure being documented is necessarily a "History and Physical" act.
        "event": List[FHIR_CodeableConcept],
        # The time period over which the service that is described by the document was provided.
        "period": FHIR_Period,
        # The kind of facility where the patient was seen.
        "facilityType": FHIR_CodeableConcept,
        # This property may convey specifics about the practice setting where the content was created, often reflecting the clinical specialty.
        "practiceSetting": FHIR_CodeableConcept,
        # The Patient Information as known when the document was published. May be a reference to a version specific, or contained.
        "sourcePatientInfo": FHIR_Reference,
        # Related identifiers or resources associated with the DocumentReference.
        "related": List[FHIR_Reference],
    },
    total=False,
)
