from typing import Any, List, Literal, TypedDict

from .FHIR_code import FHIR_code
from .FHIR_Element import FHIR_Element
from .FHIR_id import FHIR_id
from .FHIR_Identifier import FHIR_Identifier
from .FHIR_integer import FHIR_integer
from .FHIR_Meta import FHIR_Meta
from .FHIR_MolecularSequence_Quality import FHIR_MolecularSequence_Quality
from .FHIR_MolecularSequence_ReferenceSeq import FHIR_MolecularSequence_ReferenceSeq
from .FHIR_MolecularSequence_Repository import FHIR_MolecularSequence_Repository
from .FHIR_MolecularSequence_StructureVariant import (
    FHIR_MolecularSequence_StructureVariant,
)
from .FHIR_MolecularSequence_Variant import FHIR_MolecularSequence_Variant
from .FHIR_Narrative import FHIR_Narrative
from .FHIR_Quantity import FHIR_Quantity
from .FHIR_Reference import FHIR_Reference
from .FHIR_string import FHIR_string
from .FHIR_uri import FHIR_uri

# Raw data describing a biological sequence.
FHIR_MolecularSequence = TypedDict(
    "FHIR_MolecularSequence",
    {
        # This is a MolecularSequence resource
        "resourceType": Literal["MolecularSequence"],
        # The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.
        "id": FHIR_id,
        # The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.
        "meta": FHIR_Meta,
        # A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.
        "implicitRules": FHIR_uri,
        # Extensions for implicitRules
        "_implicitRules": FHIR_Element,
        # The base language in which the resource is written.
        "language": FHIR_code,
        # Extensions for language
        "_language": FHIR_Element,
        # A human-readable narrative that contains a summary of the resource and can be used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it "clinically safe" for a human to just read the narrative. Resource definitions may define what content should be represented in the narrative to ensure clinical safety.
        "text": FHIR_Narrative,
        # These resources do not have an independent existence apart from the resource that contains them - they cannot be identified independently, and nor can they have their own independent transaction scope.
        "contained": List[Any],
        # May be used to represent additional information that is not part of the basic definition of the resource. To make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
        "extension": List[Any],
        # May be used to represent additional information that is not part of the basic definition of the resource and that modifies the understanding of the element that contains it and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
        "modifierExtension": List[Any],
        # A unique identifier for this particular sequence instance. This is a FHIR-defined id.
        "identifier": List[FHIR_Identifier],
        # Amino Acid Sequence/ DNA Sequence / RNA Sequence.
        "type": Literal["aa", "dna", "rna"],
        # Extensions for type
        "_type": FHIR_Element,
        # Whether the sequence is numbered starting at 0 (0-based numbering or coordinates, inclusive start, exclusive end) or starting at 1 (1-based numbering, inclusive start and inclusive end).
        "coordinateSystem": FHIR_integer,
        # Extensions for coordinateSystem
        "_coordinateSystem": FHIR_Element,
        # The patient whose sequencing results are described by this resource.
        "patient": FHIR_Reference,
        # Specimen used for sequencing.
        "specimen": FHIR_Reference,
        # The method for sequencing, for example, chip information.
        "device": FHIR_Reference,
        # The organization or lab that should be responsible for this result.
        "performer": FHIR_Reference,
        # The number of copies of the sequence of interest. (RNASeq).
        "quantity": FHIR_Quantity,
        # A sequence that is used as a reference to describe variants that are present in a sequence analyzed.
        "referenceSeq": FHIR_MolecularSequence_ReferenceSeq,
        # The definition of variant here originates from Sequence ontology ([variant_of](http://www.sequenceontology.org/browser/current_svn/term/variant_of)). This element can represent amino acid or nucleic sequence change(including insertion,deletion,SNP,etc.)  It can represent some complex mutation or segment variation with the assist of CIGAR string.
        "variant": List[FHIR_MolecularSequence_Variant],
        # Sequence that was observed. It is the result marked by referenceSeq along with variant records on referenceSeq. This shall start from referenceSeq.windowStart and end by referenceSeq.windowEnd.
        "observedSeq": FHIR_string,
        # Extensions for observedSeq
        "_observedSeq": FHIR_Element,
        # An experimental feature attribute that defines the quality of the feature in a quantitative way, such as a phred quality score ([SO:0001686](http://www.sequenceontology.org/browser/current_svn/term/SO:0001686)).
        "quality": List[FHIR_MolecularSequence_Quality],
        # Coverage (read depth or depth) is the average number of reads representing a given nucleotide in the reconstructed sequence.
        "readCoverage": FHIR_integer,
        # Extensions for readCoverage
        "_readCoverage": FHIR_Element,
        # Configurations of the external repository. The repository shall store target's observedSeq or records related with target's observedSeq.
        "repository": List[FHIR_MolecularSequence_Repository],
        # Pointer to next atomic sequence which at most contains one variant.
        "pointer": List[FHIR_Reference],
        # Information about chromosome structure variation.
        "structureVariant": List[FHIR_MolecularSequence_StructureVariant],
    },
    total=False,
)
