from typing import Any, List, Literal, TypedDict

from .FHIR_CodeableConcept import FHIR_CodeableConcept
from .FHIR_Duration import FHIR_Duration
from .FHIR_Element import FHIR_Element
from .FHIR_Period import FHIR_Period
from .FHIR_Quantity import FHIR_Quantity
from .FHIR_Reference import FHIR_Reference
from .FHIR_string import FHIR_string

# A sample to be used for analysis.
FHIR_Specimen_Collection = TypedDict(
    "FHIR_Specimen_Collection",
    {
        # Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
        "id": FHIR_string,
        # May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
        "extension": List[Any],
        # May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
        "modifierExtension": List[Any],
        # Person who collected the specimen.
        "collector": FHIR_Reference,
        # Time when specimen was collected from subject - the physiologically relevant time.
        "collectedDateTime": str,
        # Extensions for collectedDateTime
        "_collectedDateTime": FHIR_Element,
        # Time when specimen was collected from subject - the physiologically relevant time.
        "collectedPeriod": FHIR_Period,
        # The span of time over which the collection of a specimen occurred.
        "duration": FHIR_Duration,
        # The quantity of specimen collected; for instance the volume of a blood sample, or the physical measurement of an anatomic pathology sample.
        "quantity": FHIR_Quantity,
        # A coded value specifying the technique that is used to perform the procedure.
        "method": FHIR_CodeableConcept,
        # Anatomical location from which the specimen was collected (if subject is a patient). This is the target site.  This element is not used for environmental specimens.
        "bodySite": FHIR_CodeableConcept,
        # Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.
        "fastingStatusCodeableConcept": FHIR_CodeableConcept,
        # Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.
        "fastingStatusDuration": FHIR_Duration,
    },
    total=False,
)
