from typing import Any, List, Literal, TypedDict

from .FHIR_boolean import FHIR_boolean
from .FHIR_Element import FHIR_Element
from .FHIR_markdown import FHIR_markdown
from .FHIR_string import FHIR_string
from .FHIR_TerminologyCapabilities_Parameter import (
    FHIR_TerminologyCapabilities_Parameter,
)

# A TerminologyCapabilities resource documents a set of capabilities (behaviors) of a FHIR Terminology Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.
FHIR_TerminologyCapabilities_Expansion = TypedDict(
    "FHIR_TerminologyCapabilities_Expansion",
    {
        # Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
        "id": FHIR_string,
        # May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
        "extension": List[Any],
        # May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
        "modifierExtension": List[Any],
        # Whether the server can return nested value sets.
        "hierarchical": FHIR_boolean,
        # Extensions for hierarchical
        "_hierarchical": FHIR_Element,
        # Whether the server supports paging on expansion.
        "paging": FHIR_boolean,
        # Extensions for paging
        "_paging": FHIR_Element,
        # Allow request for incomplete expansions?
        "incomplete": FHIR_boolean,
        # Extensions for incomplete
        "_incomplete": FHIR_Element,
        # Supported expansion parameter.
        "parameter": List[FHIR_TerminologyCapabilities_Parameter],
        # Documentation about text searching works.
        "textFilter": FHIR_markdown,
        # Extensions for textFilter
        "_textFilter": FHIR_Element,
    },
    total=False,
)
