from fhir_types import FHIR_Patient

p: FHIR_Patient = {
    "resourceType": "Patient",
    "id": "8b3f3893-eb15-4c23-b66e-3111a20a4681",
    "text": {
        "status": "generated",
        "div": '<div xmlns="http://www.w3.org/1999/xhtml">Generated by <a href="https://github.com/synthetichealth/synthea">Synthea</a>.Version identifier: master-branch-latest\n .   Person seed: -5067120256043919880  Population seed: 1594677869505</div>',
    },
    "extension": [
        {
            "url": "http://hl7.org/fhir/StructureDefinition/patient-mothersMaidenName",
            "valueString": "Leanora120 Von197",
        },
        {
            "url": "http://hl7.org/fhir/StructureDefinition/patient-birthPlace",
            "valueAddress": {
                "city": "Springfield",
                "state": "Massachusetts",
                "country": "US",
            },
        },
        {
            "url": "http://synthetichealth.github.io/synthea/disability-adjusted-life-years",
            "valueDecimal": 0.15897906162529565,
        },
        {
            "url": "http://synthetichealth.github.io/synthea/quality-adjusted-life-years",
            "valueDecimal": 27.841020938374704,
        },
    ],
    "identifier": [
        {
            "system": "https://github.com/synthetichealth/synthea",
            "value": "8b3f3893-eb15-4c23-b66e-3111a20a4681",
        },
        {
            "type": {
                "coding": [
                    {
                        "system": "http://terminology.hl7.org/CodeSystem/v2-0203",
                        "code": "MR",
                        "display": "Medical Record Number",
                    }
                ],
                "text": "Medical Record Number",
            },
            "system": "http://hospital.smarthealthit.org",
            "value": "8b3f3893-eb15-4c23-b66e-3111a20a4681",
        },
        {
            "type": {
                "coding": [
                    {
                        "system": "http://terminology.hl7.org/CodeSystem/v2-0203",
                        "code": "SS",
                        "display": "Social Security Number",
                    }
                ],
                "text": "Social Security Number",
            },
            "system": "http://hl7.org/fhir/sid/us-ssn",
            "value": "999-45-8654",
        },
        {
            "type": {
                "coding": [
                    {
                        "system": "http://terminology.hl7.org/CodeSystem/v2-0203",
                        "code": "DL",
                        "display": "Driver's License",
                    }
                ],
                "text": "Driver's License",
            },
            "system": "urn:oid:2.16.840.1.113883.4.3.25",
            "value": "S99947153",
        },
        {
            "type": {
                "coding": [
                    {
                        "system": "http://terminology.hl7.org/CodeSystem/v2-0203",
                        "code": "PPN",
                        "display": "Passport Number",
                    }
                ],
                "text": "Passport Number",
            },
            "system": "http://standardhealthrecord.org/fhir/StructureDefinition/passportNumber",
            "value": "X86782194X",
        },
    ],
    "name": [
        {
            "use": "official",
            "family": "Corkery305",
            "given": ["Cory323"],
            "prefix": ["Mr."],
        }
    ],
    "telecom": [{"system": "phone", "value": "555-716-4128", "use": "home"}],
    "deceasedBoolean": False,
    "gender": "male",
    "birthDate": "1991-04-28",
    "address": [
        {
            "extension": [
                {
                    "url": "http://hl7.org/fhir/StructureDefinition/geolocation",
                    "extension": [
                        {"url": "latitude", "valueDecimal": 42.713412111132484},
                        {"url": "longitude", "valueDecimal": -71.18695940499926},
                    ],
                }
            ],
            "line": ["228 Will Village Unit 16"],
            "city": "Lawrence",
            "state": "Massachusetts",
            "country": "US",
        }
    ],
    "maritalStatus": {
        "coding": [
            {
                "system": "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
                "code": "M",
                "display": "M",
            }
        ],
        "text": "M",
    },
    "multipleBirthBoolean": False,
    "communication": [
        {
            "language": {
                "coding": [
                    {"system": "urn:ietf:bcp:47", "code": "en-US", "display": "English"}
                ],
                "text": "English",
            }
        }
    ],
}
