"""This package implements necessary algorithms and objects for circuit template
instantiation and cost minimization."""
from __future__ import annotations

from bqskit.ir.opt.cost.function import CostFunction
from bqskit.ir.opt.cost.functions import HilbertSchmidtCost
from bqskit.ir.opt.cost.functions import HilbertSchmidtCostGenerator
from bqskit.ir.opt.cost.functions import HilbertSchmidtResiduals
from bqskit.ir.opt.cost.functions import HilbertSchmidtResidualsGenerator
from bqskit.ir.opt.cost.generator import CostFunctionGenerator
from bqskit.ir.opt.instantiater import Instantiater
from bqskit.ir.opt.instantiaters import Minimization
from bqskit.ir.opt.instantiaters import QFactor
from bqskit.ir.opt.minimizer import Minimizer
from bqskit.ir.opt.minimizers import LBFGSMinimizer
from bqskit.ir.opt.multistartgen import MultiStartGenerator
from bqskit.ir.opt.multistartgens import RandomStartGenerator

__all__ = [
    'Instantiater',
    'QFactor',
    'Minimization',
    'Minimizer',
    'LBFGSMinimizer',
    'CostFunction',
    'CostFunctionGenerator',
    'HilbertSchmidtCost',
    'HilbertSchmidtCostGenerator',
    'HilbertSchmidtResiduals',
    'HilbertSchmidtResidualsGenerator',
    'MultiStartGenerator',
    'RandomStartGenerator',
]
