# AUTOGENERATED - modify shared_anyscale_util in root directory to make changes
import os


TEST_MODE = os.environ.get("TEST_MODE") == "1"

ANYSCALE_ENDPOINTS = {
    "development": "https://console.anyscale-dev.dev",
    "staging": "https://console.anyscale-staging.com",
    "production": "https://console.anyscale.com",
    "predeploy": "https://console.predeploy.anyscale.dev",
    "test": "",
}

ANYSCALE_EXTERNAL_API_ENDPOINTS = {
    "development": "https://anyscale-dev.dev/ext",
    "staging": "https://api.anyscale-staging.com",
    "production": "https://api.anyscale.com",
    "predeploy": "https://api.predeploy.anyscale.dev",
    "test": "",
}


if (
    "ANYSCALE_HOST" in os.environ
    and os.environ.get("ANYSCALE_HOST") not in ANYSCALE_ENDPOINTS.values()
):
    anyscale_env_default = "test"
else:
    anyscale_env_default = "production"

ANYSCALE_ENV = os.environ.get("DEPLOY_ENVIRONMENT", anyscale_env_default)
ANYSCALE_HOST = os.environ.get("ANYSCALE_HOST", ANYSCALE_ENDPOINTS[ANYSCALE_ENV])
ANYSCALE_API_HOST = ANYSCALE_EXTERNAL_API_ENDPOINTS[ANYSCALE_ENV]
