# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetProjectIdsResult',
    'AwaitableGetProjectIdsResult',
    'get_project_ids',
    'get_project_ids_output',
]

@pulumi.output_type
class GetProjectIdsResult:
    """
    A collection of values returned by getProjectIds.
    """
    def __init__(__self__, id=None, project=None, project_full_path=None, project_graphql_id=None, project_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if project_full_path and not isinstance(project_full_path, str):
            raise TypeError("Expected argument 'project_full_path' to be a str")
        pulumi.set(__self__, "project_full_path", project_full_path)
        if project_graphql_id and not isinstance(project_graphql_id, str):
            raise TypeError("Expected argument 'project_graphql_id' to be a str")
        pulumi.set(__self__, "project_graphql_id", project_graphql_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID or URL-encoded path of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="projectFullPath")
    def project_full_path(self) -> str:
        """
        The full path of the project.
        """
        return pulumi.get(self, "project_full_path")

    @property
    @pulumi.getter(name="projectGraphqlId")
    def project_graphql_id(self) -> str:
        """
        The GraphQL ID of the project.
        """
        return pulumi.get(self, "project_graphql_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")


class AwaitableGetProjectIdsResult(GetProjectIdsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectIdsResult(
            id=self.id,
            project=self.project,
            project_full_path=self.project_full_path,
            project_graphql_id=self.project_graphql_id,
            project_id=self.project_id)


def get_project_ids(project: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectIdsResult:
    """
    The `get_project_ids` data source identification information for a given project, allowing a user to translate a full path or ID into the GraphQL ID of the project.

    **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#queryproject)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    new_project = gitlab.Project("new_project")
    # use project IDs to get additional information, such as the GraphQL ID
    # for other resources
    foo = gitlab.get_project_ids(project="gitlab_project.new_project.id")
    pulumi.export("graphQLId", foo.project_graphql_id)
    ```


    :param str project: The ID or URL-encoded path of the project.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getProjectIds:getProjectIds', __args__, opts=opts, typ=GetProjectIdsResult).value

    return AwaitableGetProjectIdsResult(
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        project_full_path=pulumi.get(__ret__, 'project_full_path'),
        project_graphql_id=pulumi.get(__ret__, 'project_graphql_id'),
        project_id=pulumi.get(__ret__, 'project_id'))


@_utilities.lift_output_func(get_project_ids)
def get_project_ids_output(project: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectIdsResult]:
    """
    The `get_project_ids` data source identification information for a given project, allowing a user to translate a full path or ID into the GraphQL ID of the project.

    **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#queryproject)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    new_project = gitlab.Project("new_project")
    # use project IDs to get additional information, such as the GraphQL ID
    # for other resources
    foo = gitlab.get_project_ids(project="gitlab_project.new_project.id")
    pulumi.export("graphQLId", foo.project_graphql_id)
    ```


    :param str project: The ID or URL-encoded path of the project.
    """
    ...
