# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['IntegrationSlackArgs', 'IntegrationSlack']

@pulumi.input_type
class IntegrationSlackArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 webhook: pulumi.Input[str],
                 branches_to_be_notified: Optional[pulumi.Input[str]] = None,
                 confidential_issue_channel: Optional[pulumi.Input[str]] = None,
                 confidential_issues_events: Optional[pulumi.Input[bool]] = None,
                 confidential_note_channel: Optional[pulumi.Input[str]] = None,
                 confidential_note_events: Optional[pulumi.Input[bool]] = None,
                 issue_channel: Optional[pulumi.Input[str]] = None,
                 issues_events: Optional[pulumi.Input[bool]] = None,
                 merge_request_channel: Optional[pulumi.Input[str]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 note_channel: Optional[pulumi.Input[str]] = None,
                 note_events: Optional[pulumi.Input[bool]] = None,
                 notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None,
                 notify_only_default_branch: Optional[pulumi.Input[bool]] = None,
                 pipeline_channel: Optional[pulumi.Input[str]] = None,
                 pipeline_events: Optional[pulumi.Input[bool]] = None,
                 push_channel: Optional[pulumi.Input[str]] = None,
                 push_events: Optional[pulumi.Input[bool]] = None,
                 tag_push_channel: Optional[pulumi.Input[str]] = None,
                 tag_push_events: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 wiki_page_channel: Optional[pulumi.Input[str]] = None,
                 wiki_page_events: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a IntegrationSlack resource.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[str] webhook: Webhook URL (Example, https://hooks.slack.com/services/...). This value cannot be imported.
        :param pulumi.Input[str] branches_to_be_notified: Branches to send notifications for. Valid options are "all", "default", "protected", and "default*and*protected".
        :param pulumi.Input[str] confidential_issue_channel: The name of the channel to receive confidential issue events notifications.
        :param pulumi.Input[bool] confidential_issues_events: Enable notifications for confidential issues events.
        :param pulumi.Input[str] confidential_note_channel: The name of the channel to receive confidential note events notifications.
        :param pulumi.Input[bool] confidential_note_events: Enable notifications for confidential note events.
        :param pulumi.Input[str] issue_channel: The name of the channel to receive issue events notifications.
        :param pulumi.Input[bool] issues_events: Enable notifications for issues events.
        :param pulumi.Input[str] merge_request_channel: The name of the channel to receive merge request events notifications.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge requests events.
        :param pulumi.Input[str] note_channel: The name of the channel to receive note events notifications.
        :param pulumi.Input[bool] note_events: Enable notifications for note events.
        :param pulumi.Input[bool] notify_only_broken_pipelines: Send notifications for broken pipelines.
        :param pulumi.Input[bool] notify_only_default_branch: This parameter has been replaced with `branches_to_be_notified`.
        :param pulumi.Input[str] pipeline_channel: The name of the channel to receive pipeline events notifications.
        :param pulumi.Input[bool] pipeline_events: Enable notifications for pipeline events.
        :param pulumi.Input[str] push_channel: The name of the channel to receive push events notifications.
        :param pulumi.Input[bool] push_events: Enable notifications for push events.
        :param pulumi.Input[str] tag_push_channel: The name of the channel to receive tag push events notifications.
        :param pulumi.Input[bool] tag_push_events: Enable notifications for tag push events.
        :param pulumi.Input[str] username: Username to use.
        :param pulumi.Input[str] wiki_page_channel: The name of the channel to receive wiki page events notifications.
        :param pulumi.Input[bool] wiki_page_events: Enable notifications for wiki page events.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "webhook", webhook)
        if branches_to_be_notified is not None:
            pulumi.set(__self__, "branches_to_be_notified", branches_to_be_notified)
        if confidential_issue_channel is not None:
            pulumi.set(__self__, "confidential_issue_channel", confidential_issue_channel)
        if confidential_issues_events is not None:
            pulumi.set(__self__, "confidential_issues_events", confidential_issues_events)
        if confidential_note_channel is not None:
            pulumi.set(__self__, "confidential_note_channel", confidential_note_channel)
        if confidential_note_events is not None:
            pulumi.set(__self__, "confidential_note_events", confidential_note_events)
        if issue_channel is not None:
            pulumi.set(__self__, "issue_channel", issue_channel)
        if issues_events is not None:
            pulumi.set(__self__, "issues_events", issues_events)
        if merge_request_channel is not None:
            pulumi.set(__self__, "merge_request_channel", merge_request_channel)
        if merge_requests_events is not None:
            pulumi.set(__self__, "merge_requests_events", merge_requests_events)
        if note_channel is not None:
            pulumi.set(__self__, "note_channel", note_channel)
        if note_events is not None:
            pulumi.set(__self__, "note_events", note_events)
        if notify_only_broken_pipelines is not None:
            pulumi.set(__self__, "notify_only_broken_pipelines", notify_only_broken_pipelines)
        if notify_only_default_branch is not None:
            warnings.warn("""use 'branches_to_be_notified' argument instead""", DeprecationWarning)
            pulumi.log.warn("""notify_only_default_branch is deprecated: use 'branches_to_be_notified' argument instead""")
        if notify_only_default_branch is not None:
            pulumi.set(__self__, "notify_only_default_branch", notify_only_default_branch)
        if pipeline_channel is not None:
            pulumi.set(__self__, "pipeline_channel", pipeline_channel)
        if pipeline_events is not None:
            pulumi.set(__self__, "pipeline_events", pipeline_events)
        if push_channel is not None:
            pulumi.set(__self__, "push_channel", push_channel)
        if push_events is not None:
            pulumi.set(__self__, "push_events", push_events)
        if tag_push_channel is not None:
            pulumi.set(__self__, "tag_push_channel", tag_push_channel)
        if tag_push_events is not None:
            pulumi.set(__self__, "tag_push_events", tag_push_events)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if wiki_page_channel is not None:
            pulumi.set(__self__, "wiki_page_channel", wiki_page_channel)
        if wiki_page_events is not None:
            pulumi.set(__self__, "wiki_page_events", wiki_page_events)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        ID of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def webhook(self) -> pulumi.Input[str]:
        """
        Webhook URL (Example, https://hooks.slack.com/services/...). This value cannot be imported.
        """
        return pulumi.get(self, "webhook")

    @webhook.setter
    def webhook(self, value: pulumi.Input[str]):
        pulumi.set(self, "webhook", value)

    @property
    @pulumi.getter(name="branchesToBeNotified")
    def branches_to_be_notified(self) -> Optional[pulumi.Input[str]]:
        """
        Branches to send notifications for. Valid options are "all", "default", "protected", and "default*and*protected".
        """
        return pulumi.get(self, "branches_to_be_notified")

    @branches_to_be_notified.setter
    def branches_to_be_notified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branches_to_be_notified", value)

    @property
    @pulumi.getter(name="confidentialIssueChannel")
    def confidential_issue_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive confidential issue events notifications.
        """
        return pulumi.get(self, "confidential_issue_channel")

    @confidential_issue_channel.setter
    def confidential_issue_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "confidential_issue_channel", value)

    @property
    @pulumi.getter(name="confidentialIssuesEvents")
    def confidential_issues_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for confidential issues events.
        """
        return pulumi.get(self, "confidential_issues_events")

    @confidential_issues_events.setter
    def confidential_issues_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confidential_issues_events", value)

    @property
    @pulumi.getter(name="confidentialNoteChannel")
    def confidential_note_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive confidential note events notifications.
        """
        return pulumi.get(self, "confidential_note_channel")

    @confidential_note_channel.setter
    def confidential_note_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "confidential_note_channel", value)

    @property
    @pulumi.getter(name="confidentialNoteEvents")
    def confidential_note_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for confidential note events.
        """
        return pulumi.get(self, "confidential_note_events")

    @confidential_note_events.setter
    def confidential_note_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confidential_note_events", value)

    @property
    @pulumi.getter(name="issueChannel")
    def issue_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive issue events notifications.
        """
        return pulumi.get(self, "issue_channel")

    @issue_channel.setter
    def issue_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issue_channel", value)

    @property
    @pulumi.getter(name="issuesEvents")
    def issues_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for issues events.
        """
        return pulumi.get(self, "issues_events")

    @issues_events.setter
    def issues_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "issues_events", value)

    @property
    @pulumi.getter(name="mergeRequestChannel")
    def merge_request_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive merge request events notifications.
        """
        return pulumi.get(self, "merge_request_channel")

    @merge_request_channel.setter
    def merge_request_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_request_channel", value)

    @property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for merge requests events.
        """
        return pulumi.get(self, "merge_requests_events")

    @merge_requests_events.setter
    def merge_requests_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_requests_events", value)

    @property
    @pulumi.getter(name="noteChannel")
    def note_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive note events notifications.
        """
        return pulumi.get(self, "note_channel")

    @note_channel.setter
    def note_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "note_channel", value)

    @property
    @pulumi.getter(name="noteEvents")
    def note_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for note events.
        """
        return pulumi.get(self, "note_events")

    @note_events.setter
    def note_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "note_events", value)

    @property
    @pulumi.getter(name="notifyOnlyBrokenPipelines")
    def notify_only_broken_pipelines(self) -> Optional[pulumi.Input[bool]]:
        """
        Send notifications for broken pipelines.
        """
        return pulumi.get(self, "notify_only_broken_pipelines")

    @notify_only_broken_pipelines.setter
    def notify_only_broken_pipelines(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_only_broken_pipelines", value)

    @property
    @pulumi.getter(name="notifyOnlyDefaultBranch")
    @_utilities.deprecated("""use 'branches_to_be_notified' argument instead""")
    def notify_only_default_branch(self) -> Optional[pulumi.Input[bool]]:
        """
        This parameter has been replaced with `branches_to_be_notified`.
        """
        return pulumi.get(self, "notify_only_default_branch")

    @notify_only_default_branch.setter
    def notify_only_default_branch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_only_default_branch", value)

    @property
    @pulumi.getter(name="pipelineChannel")
    def pipeline_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive pipeline events notifications.
        """
        return pulumi.get(self, "pipeline_channel")

    @pipeline_channel.setter
    def pipeline_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_channel", value)

    @property
    @pulumi.getter(name="pipelineEvents")
    def pipeline_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for pipeline events.
        """
        return pulumi.get(self, "pipeline_events")

    @pipeline_events.setter
    def pipeline_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pipeline_events", value)

    @property
    @pulumi.getter(name="pushChannel")
    def push_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive push events notifications.
        """
        return pulumi.get(self, "push_channel")

    @push_channel.setter
    def push_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "push_channel", value)

    @property
    @pulumi.getter(name="pushEvents")
    def push_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for push events.
        """
        return pulumi.get(self, "push_events")

    @push_events.setter
    def push_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "push_events", value)

    @property
    @pulumi.getter(name="tagPushChannel")
    def tag_push_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive tag push events notifications.
        """
        return pulumi.get(self, "tag_push_channel")

    @tag_push_channel.setter
    def tag_push_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_push_channel", value)

    @property
    @pulumi.getter(name="tagPushEvents")
    def tag_push_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for tag push events.
        """
        return pulumi.get(self, "tag_push_events")

    @tag_push_events.setter
    def tag_push_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tag_push_events", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username to use.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="wikiPageChannel")
    def wiki_page_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive wiki page events notifications.
        """
        return pulumi.get(self, "wiki_page_channel")

    @wiki_page_channel.setter
    def wiki_page_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wiki_page_channel", value)

    @property
    @pulumi.getter(name="wikiPageEvents")
    def wiki_page_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for wiki page events.
        """
        return pulumi.get(self, "wiki_page_events")

    @wiki_page_events.setter
    def wiki_page_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wiki_page_events", value)


@pulumi.input_type
class _IntegrationSlackState:
    def __init__(__self__, *,
                 branches_to_be_notified: Optional[pulumi.Input[str]] = None,
                 confidential_issue_channel: Optional[pulumi.Input[str]] = None,
                 confidential_issues_events: Optional[pulumi.Input[bool]] = None,
                 confidential_note_channel: Optional[pulumi.Input[str]] = None,
                 confidential_note_events: Optional[pulumi.Input[bool]] = None,
                 issue_channel: Optional[pulumi.Input[str]] = None,
                 issues_events: Optional[pulumi.Input[bool]] = None,
                 job_events: Optional[pulumi.Input[bool]] = None,
                 merge_request_channel: Optional[pulumi.Input[str]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 note_channel: Optional[pulumi.Input[str]] = None,
                 note_events: Optional[pulumi.Input[bool]] = None,
                 notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None,
                 notify_only_default_branch: Optional[pulumi.Input[bool]] = None,
                 pipeline_channel: Optional[pulumi.Input[str]] = None,
                 pipeline_events: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 push_channel: Optional[pulumi.Input[str]] = None,
                 push_events: Optional[pulumi.Input[bool]] = None,
                 tag_push_channel: Optional[pulumi.Input[str]] = None,
                 tag_push_events: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 webhook: Optional[pulumi.Input[str]] = None,
                 wiki_page_channel: Optional[pulumi.Input[str]] = None,
                 wiki_page_events: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering IntegrationSlack resources.
        :param pulumi.Input[str] branches_to_be_notified: Branches to send notifications for. Valid options are "all", "default", "protected", and "default*and*protected".
        :param pulumi.Input[str] confidential_issue_channel: The name of the channel to receive confidential issue events notifications.
        :param pulumi.Input[bool] confidential_issues_events: Enable notifications for confidential issues events.
        :param pulumi.Input[str] confidential_note_channel: The name of the channel to receive confidential note events notifications.
        :param pulumi.Input[bool] confidential_note_events: Enable notifications for confidential note events.
        :param pulumi.Input[str] issue_channel: The name of the channel to receive issue events notifications.
        :param pulumi.Input[bool] issues_events: Enable notifications for issues events.
        :param pulumi.Input[bool] job_events: Enable notifications for job events. **ATTENTION**: This attribute is currently not being submitted to the GitLab API, due to https://github.com/xanzy/go-gitlab/issues/1354.
        :param pulumi.Input[str] merge_request_channel: The name of the channel to receive merge request events notifications.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge requests events.
        :param pulumi.Input[str] note_channel: The name of the channel to receive note events notifications.
        :param pulumi.Input[bool] note_events: Enable notifications for note events.
        :param pulumi.Input[bool] notify_only_broken_pipelines: Send notifications for broken pipelines.
        :param pulumi.Input[bool] notify_only_default_branch: This parameter has been replaced with `branches_to_be_notified`.
        :param pulumi.Input[str] pipeline_channel: The name of the channel to receive pipeline events notifications.
        :param pulumi.Input[bool] pipeline_events: Enable notifications for pipeline events.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[str] push_channel: The name of the channel to receive push events notifications.
        :param pulumi.Input[bool] push_events: Enable notifications for push events.
        :param pulumi.Input[str] tag_push_channel: The name of the channel to receive tag push events notifications.
        :param pulumi.Input[bool] tag_push_events: Enable notifications for tag push events.
        :param pulumi.Input[str] username: Username to use.
        :param pulumi.Input[str] webhook: Webhook URL (Example, https://hooks.slack.com/services/...). This value cannot be imported.
        :param pulumi.Input[str] wiki_page_channel: The name of the channel to receive wiki page events notifications.
        :param pulumi.Input[bool] wiki_page_events: Enable notifications for wiki page events.
        """
        if branches_to_be_notified is not None:
            pulumi.set(__self__, "branches_to_be_notified", branches_to_be_notified)
        if confidential_issue_channel is not None:
            pulumi.set(__self__, "confidential_issue_channel", confidential_issue_channel)
        if confidential_issues_events is not None:
            pulumi.set(__self__, "confidential_issues_events", confidential_issues_events)
        if confidential_note_channel is not None:
            pulumi.set(__self__, "confidential_note_channel", confidential_note_channel)
        if confidential_note_events is not None:
            pulumi.set(__self__, "confidential_note_events", confidential_note_events)
        if issue_channel is not None:
            pulumi.set(__self__, "issue_channel", issue_channel)
        if issues_events is not None:
            pulumi.set(__self__, "issues_events", issues_events)
        if job_events is not None:
            pulumi.set(__self__, "job_events", job_events)
        if merge_request_channel is not None:
            pulumi.set(__self__, "merge_request_channel", merge_request_channel)
        if merge_requests_events is not None:
            pulumi.set(__self__, "merge_requests_events", merge_requests_events)
        if note_channel is not None:
            pulumi.set(__self__, "note_channel", note_channel)
        if note_events is not None:
            pulumi.set(__self__, "note_events", note_events)
        if notify_only_broken_pipelines is not None:
            pulumi.set(__self__, "notify_only_broken_pipelines", notify_only_broken_pipelines)
        if notify_only_default_branch is not None:
            warnings.warn("""use 'branches_to_be_notified' argument instead""", DeprecationWarning)
            pulumi.log.warn("""notify_only_default_branch is deprecated: use 'branches_to_be_notified' argument instead""")
        if notify_only_default_branch is not None:
            pulumi.set(__self__, "notify_only_default_branch", notify_only_default_branch)
        if pipeline_channel is not None:
            pulumi.set(__self__, "pipeline_channel", pipeline_channel)
        if pipeline_events is not None:
            pulumi.set(__self__, "pipeline_events", pipeline_events)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if push_channel is not None:
            pulumi.set(__self__, "push_channel", push_channel)
        if push_events is not None:
            pulumi.set(__self__, "push_events", push_events)
        if tag_push_channel is not None:
            pulumi.set(__self__, "tag_push_channel", tag_push_channel)
        if tag_push_events is not None:
            pulumi.set(__self__, "tag_push_events", tag_push_events)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)
        if wiki_page_channel is not None:
            pulumi.set(__self__, "wiki_page_channel", wiki_page_channel)
        if wiki_page_events is not None:
            pulumi.set(__self__, "wiki_page_events", wiki_page_events)

    @property
    @pulumi.getter(name="branchesToBeNotified")
    def branches_to_be_notified(self) -> Optional[pulumi.Input[str]]:
        """
        Branches to send notifications for. Valid options are "all", "default", "protected", and "default*and*protected".
        """
        return pulumi.get(self, "branches_to_be_notified")

    @branches_to_be_notified.setter
    def branches_to_be_notified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branches_to_be_notified", value)

    @property
    @pulumi.getter(name="confidentialIssueChannel")
    def confidential_issue_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive confidential issue events notifications.
        """
        return pulumi.get(self, "confidential_issue_channel")

    @confidential_issue_channel.setter
    def confidential_issue_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "confidential_issue_channel", value)

    @property
    @pulumi.getter(name="confidentialIssuesEvents")
    def confidential_issues_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for confidential issues events.
        """
        return pulumi.get(self, "confidential_issues_events")

    @confidential_issues_events.setter
    def confidential_issues_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confidential_issues_events", value)

    @property
    @pulumi.getter(name="confidentialNoteChannel")
    def confidential_note_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive confidential note events notifications.
        """
        return pulumi.get(self, "confidential_note_channel")

    @confidential_note_channel.setter
    def confidential_note_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "confidential_note_channel", value)

    @property
    @pulumi.getter(name="confidentialNoteEvents")
    def confidential_note_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for confidential note events.
        """
        return pulumi.get(self, "confidential_note_events")

    @confidential_note_events.setter
    def confidential_note_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confidential_note_events", value)

    @property
    @pulumi.getter(name="issueChannel")
    def issue_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive issue events notifications.
        """
        return pulumi.get(self, "issue_channel")

    @issue_channel.setter
    def issue_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issue_channel", value)

    @property
    @pulumi.getter(name="issuesEvents")
    def issues_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for issues events.
        """
        return pulumi.get(self, "issues_events")

    @issues_events.setter
    def issues_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "issues_events", value)

    @property
    @pulumi.getter(name="jobEvents")
    def job_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for job events. **ATTENTION**: This attribute is currently not being submitted to the GitLab API, due to https://github.com/xanzy/go-gitlab/issues/1354.
        """
        return pulumi.get(self, "job_events")

    @job_events.setter
    def job_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "job_events", value)

    @property
    @pulumi.getter(name="mergeRequestChannel")
    def merge_request_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive merge request events notifications.
        """
        return pulumi.get(self, "merge_request_channel")

    @merge_request_channel.setter
    def merge_request_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_request_channel", value)

    @property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for merge requests events.
        """
        return pulumi.get(self, "merge_requests_events")

    @merge_requests_events.setter
    def merge_requests_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_requests_events", value)

    @property
    @pulumi.getter(name="noteChannel")
    def note_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive note events notifications.
        """
        return pulumi.get(self, "note_channel")

    @note_channel.setter
    def note_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "note_channel", value)

    @property
    @pulumi.getter(name="noteEvents")
    def note_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for note events.
        """
        return pulumi.get(self, "note_events")

    @note_events.setter
    def note_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "note_events", value)

    @property
    @pulumi.getter(name="notifyOnlyBrokenPipelines")
    def notify_only_broken_pipelines(self) -> Optional[pulumi.Input[bool]]:
        """
        Send notifications for broken pipelines.
        """
        return pulumi.get(self, "notify_only_broken_pipelines")

    @notify_only_broken_pipelines.setter
    def notify_only_broken_pipelines(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_only_broken_pipelines", value)

    @property
    @pulumi.getter(name="notifyOnlyDefaultBranch")
    @_utilities.deprecated("""use 'branches_to_be_notified' argument instead""")
    def notify_only_default_branch(self) -> Optional[pulumi.Input[bool]]:
        """
        This parameter has been replaced with `branches_to_be_notified`.
        """
        return pulumi.get(self, "notify_only_default_branch")

    @notify_only_default_branch.setter
    def notify_only_default_branch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_only_default_branch", value)

    @property
    @pulumi.getter(name="pipelineChannel")
    def pipeline_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive pipeline events notifications.
        """
        return pulumi.get(self, "pipeline_channel")

    @pipeline_channel.setter
    def pipeline_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_channel", value)

    @property
    @pulumi.getter(name="pipelineEvents")
    def pipeline_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for pipeline events.
        """
        return pulumi.get(self, "pipeline_events")

    @pipeline_events.setter
    def pipeline_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pipeline_events", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pushChannel")
    def push_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive push events notifications.
        """
        return pulumi.get(self, "push_channel")

    @push_channel.setter
    def push_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "push_channel", value)

    @property
    @pulumi.getter(name="pushEvents")
    def push_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for push events.
        """
        return pulumi.get(self, "push_events")

    @push_events.setter
    def push_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "push_events", value)

    @property
    @pulumi.getter(name="tagPushChannel")
    def tag_push_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive tag push events notifications.
        """
        return pulumi.get(self, "tag_push_channel")

    @tag_push_channel.setter
    def tag_push_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_push_channel", value)

    @property
    @pulumi.getter(name="tagPushEvents")
    def tag_push_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for tag push events.
        """
        return pulumi.get(self, "tag_push_events")

    @tag_push_events.setter
    def tag_push_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tag_push_events", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username to use.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def webhook(self) -> Optional[pulumi.Input[str]]:
        """
        Webhook URL (Example, https://hooks.slack.com/services/...). This value cannot be imported.
        """
        return pulumi.get(self, "webhook")

    @webhook.setter
    def webhook(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook", value)

    @property
    @pulumi.getter(name="wikiPageChannel")
    def wiki_page_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the channel to receive wiki page events notifications.
        """
        return pulumi.get(self, "wiki_page_channel")

    @wiki_page_channel.setter
    def wiki_page_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wiki_page_channel", value)

    @property
    @pulumi.getter(name="wikiPageEvents")
    def wiki_page_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for wiki page events.
        """
        return pulumi.get(self, "wiki_page_events")

    @wiki_page_events.setter
    def wiki_page_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wiki_page_events", value)


class IntegrationSlack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branches_to_be_notified: Optional[pulumi.Input[str]] = None,
                 confidential_issue_channel: Optional[pulumi.Input[str]] = None,
                 confidential_issues_events: Optional[pulumi.Input[bool]] = None,
                 confidential_note_channel: Optional[pulumi.Input[str]] = None,
                 confidential_note_events: Optional[pulumi.Input[bool]] = None,
                 issue_channel: Optional[pulumi.Input[str]] = None,
                 issues_events: Optional[pulumi.Input[bool]] = None,
                 merge_request_channel: Optional[pulumi.Input[str]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 note_channel: Optional[pulumi.Input[str]] = None,
                 note_events: Optional[pulumi.Input[bool]] = None,
                 notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None,
                 notify_only_default_branch: Optional[pulumi.Input[bool]] = None,
                 pipeline_channel: Optional[pulumi.Input[str]] = None,
                 pipeline_events: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 push_channel: Optional[pulumi.Input[str]] = None,
                 push_events: Optional[pulumi.Input[bool]] = None,
                 tag_push_channel: Optional[pulumi.Input[str]] = None,
                 tag_push_events: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 webhook: Optional[pulumi.Input[str]] = None,
                 wiki_page_channel: Optional[pulumi.Input[str]] = None,
                 wiki_page_events: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        The `IntegrationSlack` resource allows to manage the lifecycle of a project integration with Slack.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#slack-notifications)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        awesome_project = gitlab.Project("awesome_project",
            name="awesome_project",
            description="My awesome project.",
            visibility_level="public")
        slack = gitlab.IntegrationSlack("slack",
            project=awesome_project.id,
            webhook="https://webhook.com",
            username="myuser",
            push_events=True,
            push_channel="push_chan")
        ```

        ## Import

        You can import a gitlab_integration_slack.slack state using the project ID, e.g.

        ```sh
        $ pulumi import gitlab:index/integrationSlack:IntegrationSlack slack 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branches_to_be_notified: Branches to send notifications for. Valid options are "all", "default", "protected", and "default*and*protected".
        :param pulumi.Input[str] confidential_issue_channel: The name of the channel to receive confidential issue events notifications.
        :param pulumi.Input[bool] confidential_issues_events: Enable notifications for confidential issues events.
        :param pulumi.Input[str] confidential_note_channel: The name of the channel to receive confidential note events notifications.
        :param pulumi.Input[bool] confidential_note_events: Enable notifications for confidential note events.
        :param pulumi.Input[str] issue_channel: The name of the channel to receive issue events notifications.
        :param pulumi.Input[bool] issues_events: Enable notifications for issues events.
        :param pulumi.Input[str] merge_request_channel: The name of the channel to receive merge request events notifications.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge requests events.
        :param pulumi.Input[str] note_channel: The name of the channel to receive note events notifications.
        :param pulumi.Input[bool] note_events: Enable notifications for note events.
        :param pulumi.Input[bool] notify_only_broken_pipelines: Send notifications for broken pipelines.
        :param pulumi.Input[bool] notify_only_default_branch: This parameter has been replaced with `branches_to_be_notified`.
        :param pulumi.Input[str] pipeline_channel: The name of the channel to receive pipeline events notifications.
        :param pulumi.Input[bool] pipeline_events: Enable notifications for pipeline events.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[str] push_channel: The name of the channel to receive push events notifications.
        :param pulumi.Input[bool] push_events: Enable notifications for push events.
        :param pulumi.Input[str] tag_push_channel: The name of the channel to receive tag push events notifications.
        :param pulumi.Input[bool] tag_push_events: Enable notifications for tag push events.
        :param pulumi.Input[str] username: Username to use.
        :param pulumi.Input[str] webhook: Webhook URL (Example, https://hooks.slack.com/services/...). This value cannot be imported.
        :param pulumi.Input[str] wiki_page_channel: The name of the channel to receive wiki page events notifications.
        :param pulumi.Input[bool] wiki_page_events: Enable notifications for wiki page events.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationSlackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `IntegrationSlack` resource allows to manage the lifecycle of a project integration with Slack.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#slack-notifications)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        awesome_project = gitlab.Project("awesome_project",
            name="awesome_project",
            description="My awesome project.",
            visibility_level="public")
        slack = gitlab.IntegrationSlack("slack",
            project=awesome_project.id,
            webhook="https://webhook.com",
            username="myuser",
            push_events=True,
            push_channel="push_chan")
        ```

        ## Import

        You can import a gitlab_integration_slack.slack state using the project ID, e.g.

        ```sh
        $ pulumi import gitlab:index/integrationSlack:IntegrationSlack slack 1
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationSlackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationSlackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branches_to_be_notified: Optional[pulumi.Input[str]] = None,
                 confidential_issue_channel: Optional[pulumi.Input[str]] = None,
                 confidential_issues_events: Optional[pulumi.Input[bool]] = None,
                 confidential_note_channel: Optional[pulumi.Input[str]] = None,
                 confidential_note_events: Optional[pulumi.Input[bool]] = None,
                 issue_channel: Optional[pulumi.Input[str]] = None,
                 issues_events: Optional[pulumi.Input[bool]] = None,
                 merge_request_channel: Optional[pulumi.Input[str]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 note_channel: Optional[pulumi.Input[str]] = None,
                 note_events: Optional[pulumi.Input[bool]] = None,
                 notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None,
                 notify_only_default_branch: Optional[pulumi.Input[bool]] = None,
                 pipeline_channel: Optional[pulumi.Input[str]] = None,
                 pipeline_events: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 push_channel: Optional[pulumi.Input[str]] = None,
                 push_events: Optional[pulumi.Input[bool]] = None,
                 tag_push_channel: Optional[pulumi.Input[str]] = None,
                 tag_push_events: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 webhook: Optional[pulumi.Input[str]] = None,
                 wiki_page_channel: Optional[pulumi.Input[str]] = None,
                 wiki_page_events: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationSlackArgs.__new__(IntegrationSlackArgs)

            __props__.__dict__["branches_to_be_notified"] = branches_to_be_notified
            __props__.__dict__["confidential_issue_channel"] = confidential_issue_channel
            __props__.__dict__["confidential_issues_events"] = confidential_issues_events
            __props__.__dict__["confidential_note_channel"] = confidential_note_channel
            __props__.__dict__["confidential_note_events"] = confidential_note_events
            __props__.__dict__["issue_channel"] = issue_channel
            __props__.__dict__["issues_events"] = issues_events
            __props__.__dict__["merge_request_channel"] = merge_request_channel
            __props__.__dict__["merge_requests_events"] = merge_requests_events
            __props__.__dict__["note_channel"] = note_channel
            __props__.__dict__["note_events"] = note_events
            __props__.__dict__["notify_only_broken_pipelines"] = notify_only_broken_pipelines
            __props__.__dict__["notify_only_default_branch"] = notify_only_default_branch
            __props__.__dict__["pipeline_channel"] = pipeline_channel
            __props__.__dict__["pipeline_events"] = pipeline_events
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["push_channel"] = push_channel
            __props__.__dict__["push_events"] = push_events
            __props__.__dict__["tag_push_channel"] = tag_push_channel
            __props__.__dict__["tag_push_events"] = tag_push_events
            __props__.__dict__["username"] = username
            if webhook is None and not opts.urn:
                raise TypeError("Missing required property 'webhook'")
            __props__.__dict__["webhook"] = webhook
            __props__.__dict__["wiki_page_channel"] = wiki_page_channel
            __props__.__dict__["wiki_page_events"] = wiki_page_events
            __props__.__dict__["job_events"] = None
        super(IntegrationSlack, __self__).__init__(
            'gitlab:index/integrationSlack:IntegrationSlack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branches_to_be_notified: Optional[pulumi.Input[str]] = None,
            confidential_issue_channel: Optional[pulumi.Input[str]] = None,
            confidential_issues_events: Optional[pulumi.Input[bool]] = None,
            confidential_note_channel: Optional[pulumi.Input[str]] = None,
            confidential_note_events: Optional[pulumi.Input[bool]] = None,
            issue_channel: Optional[pulumi.Input[str]] = None,
            issues_events: Optional[pulumi.Input[bool]] = None,
            job_events: Optional[pulumi.Input[bool]] = None,
            merge_request_channel: Optional[pulumi.Input[str]] = None,
            merge_requests_events: Optional[pulumi.Input[bool]] = None,
            note_channel: Optional[pulumi.Input[str]] = None,
            note_events: Optional[pulumi.Input[bool]] = None,
            notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None,
            notify_only_default_branch: Optional[pulumi.Input[bool]] = None,
            pipeline_channel: Optional[pulumi.Input[str]] = None,
            pipeline_events: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            push_channel: Optional[pulumi.Input[str]] = None,
            push_events: Optional[pulumi.Input[bool]] = None,
            tag_push_channel: Optional[pulumi.Input[str]] = None,
            tag_push_events: Optional[pulumi.Input[bool]] = None,
            username: Optional[pulumi.Input[str]] = None,
            webhook: Optional[pulumi.Input[str]] = None,
            wiki_page_channel: Optional[pulumi.Input[str]] = None,
            wiki_page_events: Optional[pulumi.Input[bool]] = None) -> 'IntegrationSlack':
        """
        Get an existing IntegrationSlack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branches_to_be_notified: Branches to send notifications for. Valid options are "all", "default", "protected", and "default*and*protected".
        :param pulumi.Input[str] confidential_issue_channel: The name of the channel to receive confidential issue events notifications.
        :param pulumi.Input[bool] confidential_issues_events: Enable notifications for confidential issues events.
        :param pulumi.Input[str] confidential_note_channel: The name of the channel to receive confidential note events notifications.
        :param pulumi.Input[bool] confidential_note_events: Enable notifications for confidential note events.
        :param pulumi.Input[str] issue_channel: The name of the channel to receive issue events notifications.
        :param pulumi.Input[bool] issues_events: Enable notifications for issues events.
        :param pulumi.Input[bool] job_events: Enable notifications for job events. **ATTENTION**: This attribute is currently not being submitted to the GitLab API, due to https://github.com/xanzy/go-gitlab/issues/1354.
        :param pulumi.Input[str] merge_request_channel: The name of the channel to receive merge request events notifications.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge requests events.
        :param pulumi.Input[str] note_channel: The name of the channel to receive note events notifications.
        :param pulumi.Input[bool] note_events: Enable notifications for note events.
        :param pulumi.Input[bool] notify_only_broken_pipelines: Send notifications for broken pipelines.
        :param pulumi.Input[bool] notify_only_default_branch: This parameter has been replaced with `branches_to_be_notified`.
        :param pulumi.Input[str] pipeline_channel: The name of the channel to receive pipeline events notifications.
        :param pulumi.Input[bool] pipeline_events: Enable notifications for pipeline events.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[str] push_channel: The name of the channel to receive push events notifications.
        :param pulumi.Input[bool] push_events: Enable notifications for push events.
        :param pulumi.Input[str] tag_push_channel: The name of the channel to receive tag push events notifications.
        :param pulumi.Input[bool] tag_push_events: Enable notifications for tag push events.
        :param pulumi.Input[str] username: Username to use.
        :param pulumi.Input[str] webhook: Webhook URL (Example, https://hooks.slack.com/services/...). This value cannot be imported.
        :param pulumi.Input[str] wiki_page_channel: The name of the channel to receive wiki page events notifications.
        :param pulumi.Input[bool] wiki_page_events: Enable notifications for wiki page events.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationSlackState.__new__(_IntegrationSlackState)

        __props__.__dict__["branches_to_be_notified"] = branches_to_be_notified
        __props__.__dict__["confidential_issue_channel"] = confidential_issue_channel
        __props__.__dict__["confidential_issues_events"] = confidential_issues_events
        __props__.__dict__["confidential_note_channel"] = confidential_note_channel
        __props__.__dict__["confidential_note_events"] = confidential_note_events
        __props__.__dict__["issue_channel"] = issue_channel
        __props__.__dict__["issues_events"] = issues_events
        __props__.__dict__["job_events"] = job_events
        __props__.__dict__["merge_request_channel"] = merge_request_channel
        __props__.__dict__["merge_requests_events"] = merge_requests_events
        __props__.__dict__["note_channel"] = note_channel
        __props__.__dict__["note_events"] = note_events
        __props__.__dict__["notify_only_broken_pipelines"] = notify_only_broken_pipelines
        __props__.__dict__["notify_only_default_branch"] = notify_only_default_branch
        __props__.__dict__["pipeline_channel"] = pipeline_channel
        __props__.__dict__["pipeline_events"] = pipeline_events
        __props__.__dict__["project"] = project
        __props__.__dict__["push_channel"] = push_channel
        __props__.__dict__["push_events"] = push_events
        __props__.__dict__["tag_push_channel"] = tag_push_channel
        __props__.__dict__["tag_push_events"] = tag_push_events
        __props__.__dict__["username"] = username
        __props__.__dict__["webhook"] = webhook
        __props__.__dict__["wiki_page_channel"] = wiki_page_channel
        __props__.__dict__["wiki_page_events"] = wiki_page_events
        return IntegrationSlack(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="branchesToBeNotified")
    def branches_to_be_notified(self) -> pulumi.Output[str]:
        """
        Branches to send notifications for. Valid options are "all", "default", "protected", and "default*and*protected".
        """
        return pulumi.get(self, "branches_to_be_notified")

    @property
    @pulumi.getter(name="confidentialIssueChannel")
    def confidential_issue_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive confidential issue events notifications.
        """
        return pulumi.get(self, "confidential_issue_channel")

    @property
    @pulumi.getter(name="confidentialIssuesEvents")
    def confidential_issues_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for confidential issues events.
        """
        return pulumi.get(self, "confidential_issues_events")

    @property
    @pulumi.getter(name="confidentialNoteChannel")
    def confidential_note_channel(self) -> pulumi.Output[str]:
        """
        The name of the channel to receive confidential note events notifications.
        """
        return pulumi.get(self, "confidential_note_channel")

    @property
    @pulumi.getter(name="confidentialNoteEvents")
    def confidential_note_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for confidential note events.
        """
        return pulumi.get(self, "confidential_note_events")

    @property
    @pulumi.getter(name="issueChannel")
    def issue_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive issue events notifications.
        """
        return pulumi.get(self, "issue_channel")

    @property
    @pulumi.getter(name="issuesEvents")
    def issues_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for issues events.
        """
        return pulumi.get(self, "issues_events")

    @property
    @pulumi.getter(name="jobEvents")
    def job_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for job events. **ATTENTION**: This attribute is currently not being submitted to the GitLab API, due to https://github.com/xanzy/go-gitlab/issues/1354.
        """
        return pulumi.get(self, "job_events")

    @property
    @pulumi.getter(name="mergeRequestChannel")
    def merge_request_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive merge request events notifications.
        """
        return pulumi.get(self, "merge_request_channel")

    @property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for merge requests events.
        """
        return pulumi.get(self, "merge_requests_events")

    @property
    @pulumi.getter(name="noteChannel")
    def note_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive note events notifications.
        """
        return pulumi.get(self, "note_channel")

    @property
    @pulumi.getter(name="noteEvents")
    def note_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for note events.
        """
        return pulumi.get(self, "note_events")

    @property
    @pulumi.getter(name="notifyOnlyBrokenPipelines")
    def notify_only_broken_pipelines(self) -> pulumi.Output[bool]:
        """
        Send notifications for broken pipelines.
        """
        return pulumi.get(self, "notify_only_broken_pipelines")

    @property
    @pulumi.getter(name="notifyOnlyDefaultBranch")
    @_utilities.deprecated("""use 'branches_to_be_notified' argument instead""")
    def notify_only_default_branch(self) -> pulumi.Output[bool]:
        """
        This parameter has been replaced with `branches_to_be_notified`.
        """
        return pulumi.get(self, "notify_only_default_branch")

    @property
    @pulumi.getter(name="pipelineChannel")
    def pipeline_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive pipeline events notifications.
        """
        return pulumi.get(self, "pipeline_channel")

    @property
    @pulumi.getter(name="pipelineEvents")
    def pipeline_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for pipeline events.
        """
        return pulumi.get(self, "pipeline_events")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        ID of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pushChannel")
    def push_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive push events notifications.
        """
        return pulumi.get(self, "push_channel")

    @property
    @pulumi.getter(name="pushEvents")
    def push_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for push events.
        """
        return pulumi.get(self, "push_events")

    @property
    @pulumi.getter(name="tagPushChannel")
    def tag_push_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive tag push events notifications.
        """
        return pulumi.get(self, "tag_push_channel")

    @property
    @pulumi.getter(name="tagPushEvents")
    def tag_push_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for tag push events.
        """
        return pulumi.get(self, "tag_push_events")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        Username to use.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def webhook(self) -> pulumi.Output[str]:
        """
        Webhook URL (Example, https://hooks.slack.com/services/...). This value cannot be imported.
        """
        return pulumi.get(self, "webhook")

    @property
    @pulumi.getter(name="wikiPageChannel")
    def wiki_page_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive wiki page events notifications.
        """
        return pulumi.get(self, "wiki_page_channel")

    @property
    @pulumi.getter(name="wikiPageEvents")
    def wiki_page_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for wiki page events.
        """
        return pulumi.get(self, "wiki_page_events")

