# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['PipelineScheduleArgs', 'PipelineSchedule']

@pulumi.input_type
class PipelineScheduleArgs:
    def __init__(__self__, *,
                 cron: pulumi.Input[str],
                 description: pulumi.Input[str],
                 project: pulumi.Input[str],
                 ref: pulumi.Input[str],
                 active: Optional[pulumi.Input[bool]] = None,
                 cron_timezone: Optional[pulumi.Input[str]] = None,
                 take_ownership: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a PipelineSchedule resource.
        :param pulumi.Input[str] cron: The cron (e.g. `0 1 * * *`).
        :param pulumi.Input[str] description: The description of the pipeline schedule.
        :param pulumi.Input[str] project: The name or id of the project to add the schedule to.
        :param pulumi.Input[str] ref: The branch/tag name to be triggered. This must be the full branch reference, for example: `refs/heads/main`, not `main`.
        :param pulumi.Input[bool] active: The activation of pipeline schedule. If false is set, the pipeline schedule will deactivated initially.
        :param pulumi.Input[str] cron_timezone: The timezone.
        """
        pulumi.set(__self__, "cron", cron)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "ref", ref)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if cron_timezone is not None:
            pulumi.set(__self__, "cron_timezone", cron_timezone)
        if take_ownership is not None:
            pulumi.set(__self__, "take_ownership", take_ownership)

    @property
    @pulumi.getter
    def cron(self) -> pulumi.Input[str]:
        """
        The cron (e.g. `0 1 * * *`).
        """
        return pulumi.get(self, "cron")

    @cron.setter
    def cron(self, value: pulumi.Input[str]):
        pulumi.set(self, "cron", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the pipeline schedule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The name or id of the project to add the schedule to.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def ref(self) -> pulumi.Input[str]:
        """
        The branch/tag name to be triggered. This must be the full branch reference, for example: `refs/heads/main`, not `main`.
        """
        return pulumi.get(self, "ref")

    @ref.setter
    def ref(self, value: pulumi.Input[str]):
        pulumi.set(self, "ref", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        The activation of pipeline schedule. If false is set, the pipeline schedule will deactivated initially.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="cronTimezone")
    def cron_timezone(self) -> Optional[pulumi.Input[str]]:
        """
        The timezone.
        """
        return pulumi.get(self, "cron_timezone")

    @cron_timezone.setter
    def cron_timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cron_timezone", value)

    @property
    @pulumi.getter(name="takeOwnership")
    def take_ownership(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "take_ownership")

    @take_ownership.setter
    def take_ownership(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "take_ownership", value)


@pulumi.input_type
class _PipelineScheduleState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 cron: Optional[pulumi.Input[str]] = None,
                 cron_timezone: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[int]] = None,
                 pipeline_schedule_id: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 ref: Optional[pulumi.Input[str]] = None,
                 take_ownership: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering PipelineSchedule resources.
        :param pulumi.Input[bool] active: The activation of pipeline schedule. If false is set, the pipeline schedule will deactivated initially.
        :param pulumi.Input[str] cron: The cron (e.g. `0 1 * * *`).
        :param pulumi.Input[str] cron_timezone: The timezone.
        :param pulumi.Input[str] description: The description of the pipeline schedule.
        :param pulumi.Input[int] owner: The ID of the user that owns the pipeline schedule.
        :param pulumi.Input[int] pipeline_schedule_id: The pipeline schedule id.
        :param pulumi.Input[str] project: The name or id of the project to add the schedule to.
        :param pulumi.Input[str] ref: The branch/tag name to be triggered. This must be the full branch reference, for example: `refs/heads/main`, not `main`.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if cron is not None:
            pulumi.set(__self__, "cron", cron)
        if cron_timezone is not None:
            pulumi.set(__self__, "cron_timezone", cron_timezone)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if pipeline_schedule_id is not None:
            pulumi.set(__self__, "pipeline_schedule_id", pipeline_schedule_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if ref is not None:
            pulumi.set(__self__, "ref", ref)
        if take_ownership is not None:
            pulumi.set(__self__, "take_ownership", take_ownership)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        The activation of pipeline schedule. If false is set, the pipeline schedule will deactivated initially.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def cron(self) -> Optional[pulumi.Input[str]]:
        """
        The cron (e.g. `0 1 * * *`).
        """
        return pulumi.get(self, "cron")

    @cron.setter
    def cron(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cron", value)

    @property
    @pulumi.getter(name="cronTimezone")
    def cron_timezone(self) -> Optional[pulumi.Input[str]]:
        """
        The timezone.
        """
        return pulumi.get(self, "cron_timezone")

    @cron_timezone.setter
    def cron_timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cron_timezone", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the pipeline schedule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the user that owns the pipeline schedule.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="pipelineScheduleId")
    def pipeline_schedule_id(self) -> Optional[pulumi.Input[int]]:
        """
        The pipeline schedule id.
        """
        return pulumi.get(self, "pipeline_schedule_id")

    @pipeline_schedule_id.setter
    def pipeline_schedule_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pipeline_schedule_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The name or id of the project to add the schedule to.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def ref(self) -> Optional[pulumi.Input[str]]:
        """
        The branch/tag name to be triggered. This must be the full branch reference, for example: `refs/heads/main`, not `main`.
        """
        return pulumi.get(self, "ref")

    @ref.setter
    def ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ref", value)

    @property
    @pulumi.getter(name="takeOwnership")
    def take_ownership(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "take_ownership")

    @take_ownership.setter
    def take_ownership(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "take_ownership", value)


class PipelineSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 cron: Optional[pulumi.Input[str]] = None,
                 cron_timezone: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 ref: Optional[pulumi.Input[str]] = None,
                 take_ownership: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        The `PipelineSchedule` resource allows to manage the lifecycle of a scheduled pipeline.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/pipeline_schedules.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.PipelineSchedule("example",
            project="12345",
            description="Used to schedule builds",
            ref="refs/heads/main",
            cron="0 1 * * *")
        ```

        ## Import

        GitLab pipeline schedules can be imported using an id made up of `{project_id}:{pipeline_schedule_id}`, e.g.

        ```sh
        $ pulumi import gitlab:index/pipelineSchedule:PipelineSchedule test 1:3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: The activation of pipeline schedule. If false is set, the pipeline schedule will deactivated initially.
        :param pulumi.Input[str] cron: The cron (e.g. `0 1 * * *`).
        :param pulumi.Input[str] cron_timezone: The timezone.
        :param pulumi.Input[str] description: The description of the pipeline schedule.
        :param pulumi.Input[str] project: The name or id of the project to add the schedule to.
        :param pulumi.Input[str] ref: The branch/tag name to be triggered. This must be the full branch reference, for example: `refs/heads/main`, not `main`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `PipelineSchedule` resource allows to manage the lifecycle of a scheduled pipeline.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/pipeline_schedules.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.PipelineSchedule("example",
            project="12345",
            description="Used to schedule builds",
            ref="refs/heads/main",
            cron="0 1 * * *")
        ```

        ## Import

        GitLab pipeline schedules can be imported using an id made up of `{project_id}:{pipeline_schedule_id}`, e.g.

        ```sh
        $ pulumi import gitlab:index/pipelineSchedule:PipelineSchedule test 1:3
        ```

        :param str resource_name: The name of the resource.
        :param PipelineScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 cron: Optional[pulumi.Input[str]] = None,
                 cron_timezone: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 ref: Optional[pulumi.Input[str]] = None,
                 take_ownership: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineScheduleArgs.__new__(PipelineScheduleArgs)

            __props__.__dict__["active"] = active
            if cron is None and not opts.urn:
                raise TypeError("Missing required property 'cron'")
            __props__.__dict__["cron"] = cron
            __props__.__dict__["cron_timezone"] = cron_timezone
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if ref is None and not opts.urn:
                raise TypeError("Missing required property 'ref'")
            __props__.__dict__["ref"] = ref
            __props__.__dict__["take_ownership"] = take_ownership
            __props__.__dict__["owner"] = None
            __props__.__dict__["pipeline_schedule_id"] = None
        super(PipelineSchedule, __self__).__init__(
            'gitlab:index/pipelineSchedule:PipelineSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[bool]] = None,
            cron: Optional[pulumi.Input[str]] = None,
            cron_timezone: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            owner: Optional[pulumi.Input[int]] = None,
            pipeline_schedule_id: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            ref: Optional[pulumi.Input[str]] = None,
            take_ownership: Optional[pulumi.Input[bool]] = None) -> 'PipelineSchedule':
        """
        Get an existing PipelineSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: The activation of pipeline schedule. If false is set, the pipeline schedule will deactivated initially.
        :param pulumi.Input[str] cron: The cron (e.g. `0 1 * * *`).
        :param pulumi.Input[str] cron_timezone: The timezone.
        :param pulumi.Input[str] description: The description of the pipeline schedule.
        :param pulumi.Input[int] owner: The ID of the user that owns the pipeline schedule.
        :param pulumi.Input[int] pipeline_schedule_id: The pipeline schedule id.
        :param pulumi.Input[str] project: The name or id of the project to add the schedule to.
        :param pulumi.Input[str] ref: The branch/tag name to be triggered. This must be the full branch reference, for example: `refs/heads/main`, not `main`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineScheduleState.__new__(_PipelineScheduleState)

        __props__.__dict__["active"] = active
        __props__.__dict__["cron"] = cron
        __props__.__dict__["cron_timezone"] = cron_timezone
        __props__.__dict__["description"] = description
        __props__.__dict__["owner"] = owner
        __props__.__dict__["pipeline_schedule_id"] = pipeline_schedule_id
        __props__.__dict__["project"] = project
        __props__.__dict__["ref"] = ref
        __props__.__dict__["take_ownership"] = take_ownership
        return PipelineSchedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[bool]:
        """
        The activation of pipeline schedule. If false is set, the pipeline schedule will deactivated initially.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def cron(self) -> pulumi.Output[str]:
        """
        The cron (e.g. `0 1 * * *`).
        """
        return pulumi.get(self, "cron")

    @property
    @pulumi.getter(name="cronTimezone")
    def cron_timezone(self) -> pulumi.Output[str]:
        """
        The timezone.
        """
        return pulumi.get(self, "cron_timezone")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the pipeline schedule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[int]:
        """
        The ID of the user that owns the pipeline schedule.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="pipelineScheduleId")
    def pipeline_schedule_id(self) -> pulumi.Output[int]:
        """
        The pipeline schedule id.
        """
        return pulumi.get(self, "pipeline_schedule_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The name or id of the project to add the schedule to.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def ref(self) -> pulumi.Output[str]:
        """
        The branch/tag name to be triggered. This must be the full branch reference, for example: `refs/heads/main`, not `main`.
        """
        return pulumi.get(self, "ref")

    @property
    @pulumi.getter(name="takeOwnership")
    def take_ownership(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "take_ownership")

