# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProjectJobTokenScopesArgs', 'ProjectJobTokenScopes']

@pulumi.input_type
class ProjectJobTokenScopesArgs:
    def __init__(__self__, *,
                 project: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[int]] = None,
                 target_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 target_project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        The set of arguments for constructing a ProjectJobTokenScopes resource.
        :param pulumi.Input[str] project: The ID or full path of the project.
        :param pulumi.Input[int] project_id: The ID of the project.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] target_group_ids: A set of group IDs that are in the CI/CD job token inbound allowlist.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] target_project_ids: A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_id is not None:
            warnings.warn("""`project_id` has been deprecated. Use `project` instead.""", DeprecationWarning)
            pulumi.log.warn("""project_id is deprecated: `project_id` has been deprecated. Use `project` instead.""")
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if target_group_ids is not None:
            pulumi.set(__self__, "target_group_ids", target_group_ids)
        if target_project_ids is not None:
            pulumi.set(__self__, "target_project_ids", target_project_ids)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID or full path of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="projectId")
    @_utilities.deprecated("""`project_id` has been deprecated. Use `project` instead.""")
    def project_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="targetGroupIds")
    def target_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A set of group IDs that are in the CI/CD job token inbound allowlist.
        """
        return pulumi.get(self, "target_group_ids")

    @target_group_ids.setter
    def target_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "target_group_ids", value)

    @property
    @pulumi.getter(name="targetProjectIds")
    def target_project_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        return pulumi.get(self, "target_project_ids")

    @target_project_ids.setter
    def target_project_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "target_project_ids", value)


@pulumi.input_type
class _ProjectJobTokenScopesState:
    def __init__(__self__, *,
                 project: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[int]] = None,
                 target_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 target_project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Input properties used for looking up and filtering ProjectJobTokenScopes resources.
        :param pulumi.Input[str] project: The ID or full path of the project.
        :param pulumi.Input[int] project_id: The ID of the project.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] target_group_ids: A set of group IDs that are in the CI/CD job token inbound allowlist.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] target_project_ids: A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_id is not None:
            warnings.warn("""`project_id` has been deprecated. Use `project` instead.""", DeprecationWarning)
            pulumi.log.warn("""project_id is deprecated: `project_id` has been deprecated. Use `project` instead.""")
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if target_group_ids is not None:
            pulumi.set(__self__, "target_group_ids", target_group_ids)
        if target_project_ids is not None:
            pulumi.set(__self__, "target_project_ids", target_project_ids)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID or full path of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="projectId")
    @_utilities.deprecated("""`project_id` has been deprecated. Use `project` instead.""")
    def project_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="targetGroupIds")
    def target_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A set of group IDs that are in the CI/CD job token inbound allowlist.
        """
        return pulumi.get(self, "target_group_ids")

    @target_group_ids.setter
    def target_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "target_group_ids", value)

    @property
    @pulumi.getter(name="targetProjectIds")
    def target_project_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        return pulumi.get(self, "target_project_ids")

    @target_project_ids.setter
    def target_project_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "target_project_ids", value)


class ProjectJobTokenScopes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[int]] = None,
                 target_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 target_project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        """
        The `ProjectJobTokenScopes` resource allows to manage the CI/CD Job Token scopes in a project.
        Any project not within the defined set in this attribute will be removed, which allows this resource to be used as an explicit deny.

        > Conflicts with the use of `ProjectJobTokenScope` when used on the same project. Use one or the other to ensure the desired state.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/project_job_token_scopes.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        allowed_single_project = gitlab.ProjectJobTokenScopes("allowed_single_project",
            project="111",
            target_project_ids=[123])
        allowed_multiple_project = gitlab.ProjectJobTokenScopes("allowed_multiple_project",
            project="111",
            target_project_ids=[
                123,
                456,
                789,
            ])
        allowed_multiple_groups = gitlab.ProjectJobTokenScopes("allowed_multiple_groups",
            project_id=111,
            target_project_ids=[],
            target_group_ids=[
                321,
                654,
            ])
        # This will remove all job token scopes, even if added outside of TF.
        explicit_deny = gitlab.ProjectJobTokenScopes("explicit_deny",
            project="111",
            target_project_ids=[])
        ```

        ## Import

        GitLab project job token scopes can be imported using an id made up of just the `project_id`

        ```sh
        $ pulumi import gitlab:index/projectJobTokenScopes:ProjectJobTokenScopes bar 123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID or full path of the project.
        :param pulumi.Input[int] project_id: The ID of the project.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] target_group_ids: A set of group IDs that are in the CI/CD job token inbound allowlist.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] target_project_ids: A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectJobTokenScopesArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectJobTokenScopes` resource allows to manage the CI/CD Job Token scopes in a project.
        Any project not within the defined set in this attribute will be removed, which allows this resource to be used as an explicit deny.

        > Conflicts with the use of `ProjectJobTokenScope` when used on the same project. Use one or the other to ensure the desired state.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/project_job_token_scopes.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        allowed_single_project = gitlab.ProjectJobTokenScopes("allowed_single_project",
            project="111",
            target_project_ids=[123])
        allowed_multiple_project = gitlab.ProjectJobTokenScopes("allowed_multiple_project",
            project="111",
            target_project_ids=[
                123,
                456,
                789,
            ])
        allowed_multiple_groups = gitlab.ProjectJobTokenScopes("allowed_multiple_groups",
            project_id=111,
            target_project_ids=[],
            target_group_ids=[
                321,
                654,
            ])
        # This will remove all job token scopes, even if added outside of TF.
        explicit_deny = gitlab.ProjectJobTokenScopes("explicit_deny",
            project="111",
            target_project_ids=[])
        ```

        ## Import

        GitLab project job token scopes can be imported using an id made up of just the `project_id`

        ```sh
        $ pulumi import gitlab:index/projectJobTokenScopes:ProjectJobTokenScopes bar 123
        ```

        :param str resource_name: The name of the resource.
        :param ProjectJobTokenScopesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectJobTokenScopesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[int]] = None,
                 target_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 target_project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectJobTokenScopesArgs.__new__(ProjectJobTokenScopesArgs)

            __props__.__dict__["project"] = project
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["target_group_ids"] = target_group_ids
            __props__.__dict__["target_project_ids"] = target_project_ids
        super(ProjectJobTokenScopes, __self__).__init__(
            'gitlab:index/projectJobTokenScopes:ProjectJobTokenScopes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            project: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[int]] = None,
            target_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            target_project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None) -> 'ProjectJobTokenScopes':
        """
        Get an existing ProjectJobTokenScopes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID or full path of the project.
        :param pulumi.Input[int] project_id: The ID of the project.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] target_group_ids: A set of group IDs that are in the CI/CD job token inbound allowlist.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] target_project_ids: A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectJobTokenScopesState.__new__(_ProjectJobTokenScopesState)

        __props__.__dict__["project"] = project
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["target_group_ids"] = target_group_ids
        __props__.__dict__["target_project_ids"] = target_project_ids
        return ProjectJobTokenScopes(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID or full path of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="projectId")
    @_utilities.deprecated("""`project_id` has been deprecated. Use `project` instead.""")
    def project_id(self) -> pulumi.Output[int]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="targetGroupIds")
    def target_group_ids(self) -> pulumi.Output[Sequence[int]]:
        """
        A set of group IDs that are in the CI/CD job token inbound allowlist.
        """
        return pulumi.get(self, "target_group_ids")

    @property
    @pulumi.getter(name="targetProjectIds")
    def target_project_ids(self) -> pulumi.Output[Sequence[int]]:
        """
        A set of project IDs that are in the CI/CD job token inbound allowlist.
        """
        return pulumi.get(self, "target_project_ids")

