"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoUpdateItem = void 0;
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const utils_1 = require("./private/utils");
/**
 * A StepFunctions task to call DynamoUpdateItem
 */
class DynamoUpdateItem extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'dynamodb',
                        resource: 'table',
                        resourceName: props.table.tableName,
                    }),
                ],
                actions: [`dynamodb:${utils_1.DynamoMethod.UPDATE}Item`],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: utils_1.getDynamoResourceArn(utils_1.DynamoMethod.UPDATE),
            Parameters: sfn.FieldUtils.renderObject({
                Key: utils_1.transformAttributeValueMap(this.props.key),
                TableName: this.props.table.tableName,
                ConditionExpression: this.props.conditionExpression,
                ExpressionAttributeNames: this.props.expressionAttributeNames,
                ExpressionAttributeValues: utils_1.transformAttributeValueMap(this.props.expressionAttributeValues),
                ReturnConsumedCapacity: this.props.returnConsumedCapacity,
                ReturnItemCollectionMetrics: this.props.returnItemCollectionMetrics,
                ReturnValues: this.props.returnValues,
                UpdateExpression: this.props.updateExpression,
            }),
        };
    }
}
exports.DynamoUpdateItem = DynamoUpdateItem;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXBkYXRlLWl0ZW0uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ1cGRhdGUtaXRlbS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSx3Q0FBd0M7QUFDeEMsa0RBQWtEO0FBQ2xELHdDQUFpRDtBQUNqRCwyQ0FBaUc7QUF5RmpHOztHQUVHO0FBQ0gsTUFBYSxnQkFBaUIsU0FBUSxHQUFHLENBQUMsYUFBYTtJQUlyRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFtQixLQUE0QjtRQUNyRixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQURpQyxVQUFLLEdBQUwsS0FBSyxDQUF1QjtRQUdyRixJQUFJLENBQUMsWUFBWSxHQUFHO1lBQ2xCLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztnQkFDdEIsU0FBUyxFQUFFO29CQUNULFlBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDO3dCQUN2QixPQUFPLEVBQUUsVUFBVTt3QkFDbkIsUUFBUSxFQUFFLE9BQU87d0JBQ2pCLFlBQVksRUFBRSxLQUFLLENBQUMsS0FBSyxDQUFDLFNBQVM7cUJBQ3BDLENBQUM7aUJBQ0g7Z0JBQ0QsT0FBTyxFQUFFLENBQUMsWUFBWSxvQkFBWSxDQUFDLE1BQU0sTUFBTSxDQUFDO2FBQ2pELENBQUM7U0FDSCxDQUFDO0lBQ0osQ0FBQztJQUVEOztPQUVHO0lBQ08sV0FBVztRQUNuQixPQUFPO1lBQ0wsUUFBUSxFQUFFLDRCQUFvQixDQUFDLG9CQUFZLENBQUMsTUFBTSxDQUFDO1lBQ25ELFVBQVUsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztnQkFDdEMsR0FBRyxFQUFFLGtDQUEwQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDO2dCQUMvQyxTQUFTLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsU0FBUztnQkFDckMsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxtQkFBbUI7Z0JBQ25ELHdCQUF3QixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsd0JBQXdCO2dCQUM3RCx5QkFBeUIsRUFBRSxrQ0FBMEIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLHlCQUF5QixDQUFDO2dCQUMzRixzQkFBc0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLHNCQUFzQjtnQkFDekQsMkJBQTJCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQywyQkFBMkI7Z0JBQ25FLFlBQVksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVk7Z0JBQ3JDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCO2FBQzlDLENBQUM7U0FDSCxDQUFDO0lBQ0osQ0FBQztDQUNGO0FBeENELDRDQXdDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGRkYiBmcm9tICdAYXdzLWNkay9hd3MtZHluYW1vZGInO1xuaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMgc2ZuIGZyb20gJ0Bhd3MtY2RrL2F3cy1zdGVwZnVuY3Rpb25zJztcbmltcG9ydCB7IENvbnN0cnVjdCwgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IER5bmFtb01ldGhvZCwgZ2V0RHluYW1vUmVzb3VyY2VBcm4sIHRyYW5zZm9ybUF0dHJpYnV0ZVZhbHVlTWFwIH0gZnJvbSAnLi9wcml2YXRlL3V0aWxzJztcbmltcG9ydCB7IER5bmFtb0F0dHJpYnV0ZVZhbHVlLCBEeW5hbW9Db25zdW1lZENhcGFjaXR5LCBEeW5hbW9JdGVtQ29sbGVjdGlvbk1ldHJpY3MsIER5bmFtb1JldHVyblZhbHVlcyB9IGZyb20gJy4vc2hhcmVkLXR5cGVzJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBEeW5hbW9VcGRhdGVJdGVtIFRhc2tcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBEeW5hbW9VcGRhdGVJdGVtUHJvcHMgZXh0ZW5kcyBzZm4uVGFza1N0YXRlQmFzZVByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSB0YWJsZSBjb250YWluaW5nIHRoZSByZXF1ZXN0ZWQgaXRlbS5cbiAgICovXG4gIHJlYWRvbmx5IHRhYmxlOiBkZGIuSVRhYmxlO1xuXG4gIC8qKlxuICAgKiBQcmltYXJ5IGtleSBvZiB0aGUgaXRlbSB0byByZXRyaWV2ZS5cbiAgICpcbiAgICogRm9yIHRoZSBwcmltYXJ5IGtleSwgeW91IG11c3QgcHJvdmlkZSBhbGwgb2YgdGhlIGF0dHJpYnV0ZXMuXG4gICAqIEZvciBleGFtcGxlLCB3aXRoIGEgc2ltcGxlIHByaW1hcnkga2V5LCB5b3Ugb25seSBuZWVkIHRvIHByb3ZpZGUgYSB2YWx1ZSBmb3IgdGhlIHBhcnRpdGlvbiBrZXkuXG4gICAqIEZvciBhIGNvbXBvc2l0ZSBwcmltYXJ5IGtleSwgeW91IG11c3QgcHJvdmlkZSB2YWx1ZXMgZm9yIGJvdGggdGhlIHBhcnRpdGlvbiBrZXkgYW5kIHRoZSBzb3J0IGtleS5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYW1hem9uZHluYW1vZGIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0SXRlbS5odG1sI0REQi1HZXRJdGVtLXJlcXVlc3QtS2V5XG4gICAqL1xuICByZWFkb25seSBrZXk6IHsgW2tleTogc3RyaW5nXTogRHluYW1vQXR0cmlidXRlVmFsdWUgfTtcblxuICAvKipcbiAgICogQSBjb25kaXRpb24gdGhhdCBtdXN0IGJlIHNhdGlzZmllZCBpbiBvcmRlciBmb3IgYSBjb25kaXRpb25hbCBEZWxldGVJdGVtIHRvIHN1Y2NlZWQuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FtYXpvbmR5bmFtb2RiL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZUl0ZW0uaHRtbCNEREItVXBkYXRlSXRlbS1yZXF1ZXN0LUNvbmRpdGlvbkV4cHJlc3Npb25cbiAgICpcbiAgICogQGRlZmF1bHQgLSBObyBjb25kaXRpb24gZXhwcmVzc2lvblxuICAgKi9cbiAgcmVhZG9ubHkgY29uZGl0aW9uRXhwcmVzc2lvbj86IHN0cmluZztcblxuICAvKipcbiAgICogT25lIG9yIG1vcmUgc3Vic3RpdHV0aW9uIHRva2VucyBmb3IgYXR0cmlidXRlIG5hbWVzIGluIGFuIGV4cHJlc3Npb25cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYW1hem9uZHluYW1vZGIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlSXRlbS5odG1sI0REQi1VcGRhdGVJdGVtLXJlcXVlc3QtRXhwcmVzc2lvbkF0dHJpYnV0ZU5hbWVzXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gZXhwcmVzc2lvbiBhdHRyaWJ1dGUgbmFtZXNcbiAgICovXG4gIHJlYWRvbmx5IGV4cHJlc3Npb25BdHRyaWJ1dGVOYW1lcz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG5cbiAgLyoqXG4gICAqIE9uZSBvciBtb3JlIHZhbHVlcyB0aGF0IGNhbiBiZSBzdWJzdGl0dXRlZCBpbiBhbiBleHByZXNzaW9uLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hbWF6b25keW5hbW9kYi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVJdGVtLmh0bWwjRERCLVVwZGF0ZUl0ZW0tcmVxdWVzdC1FeHByZXNzaW9uQXR0cmlidXRlVmFsdWVzXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gZXhwcmVzc2lvbiBhdHRyaWJ1dGUgdmFsdWVzXG4gICAqL1xuICByZWFkb25seSBleHByZXNzaW9uQXR0cmlidXRlVmFsdWVzPzogeyBba2V5OiBzdHJpbmddOiBEeW5hbW9BdHRyaWJ1dGVWYWx1ZSB9O1xuXG4gIC8qKlxuICAgKiBEZXRlcm1pbmVzIHRoZSBsZXZlbCBvZiBkZXRhaWwgYWJvdXQgcHJvdmlzaW9uZWQgdGhyb3VnaHB1dCBjb25zdW1wdGlvbiB0aGF0IGlzIHJldHVybmVkIGluIHRoZSByZXNwb25zZVxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hbWF6b25keW5hbW9kYi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVJdGVtLmh0bWwjRERCLVVwZGF0ZUl0ZW0tcmVxdWVzdC1SZXR1cm5Db25zdW1lZENhcGFjaXR5XG4gICAqXG4gICAqIEBkZWZhdWx0IER5bmFtb0NvbnN1bWVkQ2FwYWNpdHkuTk9ORVxuICAgKi9cbiAgcmVhZG9ubHkgcmV0dXJuQ29uc3VtZWRDYXBhY2l0eT86IER5bmFtb0NvbnN1bWVkQ2FwYWNpdHk7XG5cbiAgLyoqXG4gICAqIERldGVybWluZXMgd2hldGhlciBpdGVtIGNvbGxlY3Rpb24gbWV0cmljcyBhcmUgcmV0dXJuZWQuXG4gICAqIElmIHNldCB0byBTSVpFLCB0aGUgcmVzcG9uc2UgaW5jbHVkZXMgc3RhdGlzdGljcyBhYm91dCBpdGVtIGNvbGxlY3Rpb25zLCBpZiBhbnksXG4gICAqIHRoYXQgd2VyZSBtb2RpZmllZCBkdXJpbmcgdGhlIG9wZXJhdGlvbiBhcmUgcmV0dXJuZWQgaW4gdGhlIHJlc3BvbnNlLlxuICAgKiBJZiBzZXQgdG8gTk9ORSAodGhlIGRlZmF1bHQpLCBubyBzdGF0aXN0aWNzIGFyZSByZXR1cm5lZC5cbiAgICpcbiAgICogQGRlZmF1bHQgRHluYW1vSXRlbUNvbGxlY3Rpb25NZXRyaWNzLk5PTkVcbiAgICovXG4gIHJlYWRvbmx5IHJldHVybkl0ZW1Db2xsZWN0aW9uTWV0cmljcz86IER5bmFtb0l0ZW1Db2xsZWN0aW9uTWV0cmljcztcblxuICAvKipcbiAgICogVXNlIFJldHVyblZhbHVlcyBpZiB5b3Ugd2FudCB0byBnZXQgdGhlIGl0ZW0gYXR0cmlidXRlcyBhcyB0aGV5IGFwcGVhcmVkIGJlZm9yZSB0aGV5IHdlcmUgZGVsZXRlZC5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYW1hem9uZHluYW1vZGIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlSXRlbS5odG1sI0REQi1VcGRhdGVJdGVtLXJlcXVlc3QtUmV0dXJuVmFsdWVzXG4gICAqXG4gICAqIEBkZWZhdWx0IER5bmFtb1JldHVyblZhbHVlcy5OT05FXG4gICAqL1xuICByZWFkb25seSByZXR1cm5WYWx1ZXM/OiBEeW5hbW9SZXR1cm5WYWx1ZXM7XG5cbiAgLyoqXG4gICAqIEFuIGV4cHJlc3Npb24gdGhhdCBkZWZpbmVzIG9uZSBvciBtb3JlIGF0dHJpYnV0ZXMgdG8gYmUgdXBkYXRlZCxcbiAgICogdGhlIGFjdGlvbiB0byBiZSBwZXJmb3JtZWQgb24gdGhlbSwgYW5kIG5ldyB2YWx1ZXMgZm9yIHRoZW0uXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FtYXpvbmR5bmFtb2RiL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZUl0ZW0uaHRtbCNEREItVXBkYXRlSXRlbS1yZXF1ZXN0LVVwZGF0ZUV4cHJlc3Npb25cbiAgICpcbiAgICogQGRlZmF1bHQgLSBObyB1cGRhdGUgZXhwcmVzc2lvblxuICAgKi9cbiAgcmVhZG9ubHkgdXBkYXRlRXhwcmVzc2lvbj86IHN0cmluZztcbn1cblxuLyoqXG4gKiBBIFN0ZXBGdW5jdGlvbnMgdGFzayB0byBjYWxsIER5bmFtb1VwZGF0ZUl0ZW1cbiAqL1xuZXhwb3J0IGNsYXNzIER5bmFtb1VwZGF0ZUl0ZW0gZXh0ZW5kcyBzZm4uVGFza1N0YXRlQmFzZSB7XG4gIHByb3RlY3RlZCByZWFkb25seSB0YXNrTWV0cmljcz86IHNmbi5UYXNrTWV0cmljc0NvbmZpZztcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IHRhc2tQb2xpY2llcz86IGlhbS5Qb2xpY3lTdGF0ZW1lbnRbXTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBEeW5hbW9VcGRhdGVJdGVtUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcblxuICAgIHRoaXMudGFza1BvbGljaWVzID0gW1xuICAgICAgbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICByZXNvdXJjZXM6IFtcbiAgICAgICAgICBTdGFjay5vZih0aGlzKS5mb3JtYXRBcm4oe1xuICAgICAgICAgICAgc2VydmljZTogJ2R5bmFtb2RiJyxcbiAgICAgICAgICAgIHJlc291cmNlOiAndGFibGUnLFxuICAgICAgICAgICAgcmVzb3VyY2VOYW1lOiBwcm9wcy50YWJsZS50YWJsZU5hbWUsXG4gICAgICAgICAgfSksXG4gICAgICAgIF0sXG4gICAgICAgIGFjdGlvbnM6IFtgZHluYW1vZGI6JHtEeW5hbW9NZXRob2QuVVBEQVRFfUl0ZW1gXSxcbiAgICAgIH0pLFxuICAgIF07XG4gIH1cblxuICAvKipcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwcm90ZWN0ZWQgX3JlbmRlclRhc2soKTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgUmVzb3VyY2U6IGdldER5bmFtb1Jlc291cmNlQXJuKER5bmFtb01ldGhvZC5VUERBVEUpLFxuICAgICAgUGFyYW1ldGVyczogc2ZuLkZpZWxkVXRpbHMucmVuZGVyT2JqZWN0KHtcbiAgICAgICAgS2V5OiB0cmFuc2Zvcm1BdHRyaWJ1dGVWYWx1ZU1hcCh0aGlzLnByb3BzLmtleSksXG4gICAgICAgIFRhYmxlTmFtZTogdGhpcy5wcm9wcy50YWJsZS50YWJsZU5hbWUsXG4gICAgICAgIENvbmRpdGlvbkV4cHJlc3Npb246IHRoaXMucHJvcHMuY29uZGl0aW9uRXhwcmVzc2lvbixcbiAgICAgICAgRXhwcmVzc2lvbkF0dHJpYnV0ZU5hbWVzOiB0aGlzLnByb3BzLmV4cHJlc3Npb25BdHRyaWJ1dGVOYW1lcyxcbiAgICAgICAgRXhwcmVzc2lvbkF0dHJpYnV0ZVZhbHVlczogdHJhbnNmb3JtQXR0cmlidXRlVmFsdWVNYXAodGhpcy5wcm9wcy5leHByZXNzaW9uQXR0cmlidXRlVmFsdWVzKSxcbiAgICAgICAgUmV0dXJuQ29uc3VtZWRDYXBhY2l0eTogdGhpcy5wcm9wcy5yZXR1cm5Db25zdW1lZENhcGFjaXR5LFxuICAgICAgICBSZXR1cm5JdGVtQ29sbGVjdGlvbk1ldHJpY3M6IHRoaXMucHJvcHMucmV0dXJuSXRlbUNvbGxlY3Rpb25NZXRyaWNzLFxuICAgICAgICBSZXR1cm5WYWx1ZXM6IHRoaXMucHJvcHMucmV0dXJuVmFsdWVzLFxuICAgICAgICBVcGRhdGVFeHByZXNzaW9uOiB0aGlzLnByb3BzLnVwZGF0ZUV4cHJlc3Npb24sXG4gICAgICB9KSxcbiAgICB9O1xuICB9XG59XG4iXX0=