"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsInvokeActivity = void 0;
const sfn = require("@aws-cdk/aws-stepfunctions");
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 */
class StepFunctionsInvokeActivity extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.taskMetrics = {
            metricDimensions: { ActivityArn: this.props.activity.activityArn },
            metricPrefixSingular: 'Activity',
            metricPrefixPlural: 'Activities',
        };
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: this.props.activity.activityArn,
        };
    }
}
exports.StepFunctionsInvokeActivity = StepFunctionsInvokeActivity;
//# sourceMappingURL=data:application/json;base64,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