"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const eval_nodejs10_x_handler_1 = require("../lib/eval-nodejs10.x-handler");
test('with numbers', async () => {
    // GIVEN
    const event = {
        expression: '$.a + $.b',
        expressionAttributeValues: {
            '$.a': 4,
            '$.b': 5,
        },
    };
    // THEN
    const evaluated = await eval_nodejs10_x_handler_1.handler(event);
    expect(evaluated).toBe(9);
});
test('with strings', async () => {
    // GIVEN
    const event = {
        expression: '`${$.a} ${$.b}`',
        expressionAttributeValues: {
            '$.a': 'Hello',
            '$.b': 'world!',
        },
    };
    // THEN
    const evaluated = await eval_nodejs10_x_handler_1.handler(event);
    expect(evaluated).toBe('Hello world!');
});
test('with lists', async () => {
    // GIVEN
    const event = {
        expression: '$.a.map(x => x * 2)',
        expressionAttributeValues: {
            '$.a': [1, 2, 3],
        },
    };
    // THEN
    const evaluated = await eval_nodejs10_x_handler_1.handler(event);
    expect(evaluated).toEqual([2, 4, 6]);
});
test('with duplicated entries', async () => {
    // GIVEN
    const event = {
        expression: '$.a + $.a',
        expressionAttributeValues: {
            '$.a': 1,
        },
    };
    // THEN
    const evaluated = await eval_nodejs10_x_handler_1.handler(event);
    expect(evaluated).toBe(2);
});
//# sourceMappingURL=data:application/json;base64,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