"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import job_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Serving(google.protobuf.message.Message):
    """
    A Serving (Group) is a collection of Model(s).
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    MODELS_FIELD_NUMBER: builtins.int
    DEPLOYMENT_ENDPOINT_FIELD_NUMBER: builtins.int
    MODEL_ENDPOINTS_FIELD_NUMBER: builtins.int
    RESOURCE_FIELD_NUMBER: builtins.int
    CPU_SCALE_CONFIG_FIELD_NUMBER: builtins.int
    id: typing.Text
    """ID for the Serving Group"""

    name: typing.Text
    """name of the Serving Group"""

    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """list of models"""
        pass
    @property
    def deployment_endpoint(self) -> global___Endpoint:
        """Endpoint for the Serving Group"""
        pass
    @property
    def model_endpoints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Endpoint]:
        """Endpoints for the models. Copy of models[*].endpoint."""
        pass
    @property
    def resource(self) -> job_pb2.Resource: ...
    @property
    def cpu_scale_config(self) -> global___ScaleConfig: ...
    def __init__(self,
        *,
        id: typing.Text = ...,
        name: typing.Text = ...,
        models: typing.Optional[typing.Iterable[global___Model]] = ...,
        deployment_endpoint: typing.Optional[global___Endpoint] = ...,
        model_endpoints: typing.Optional[typing.Iterable[global___Endpoint]] = ...,
        resource: typing.Optional[job_pb2.Resource] = ...,
        cpu_scale_config: typing.Optional[global___ScaleConfig] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cpu_scale_config",b"cpu_scale_config","deployment_endpoint",b"deployment_endpoint","resource",b"resource"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cpu_scale_config",b"cpu_scale_config","deployment_endpoint",b"deployment_endpoint","id",b"id","model_endpoints",b"model_endpoints","models",b"models","name",b"name","resource",b"resource"]) -> None: ...
global___Serving = Serving

class Endpoint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    ACCESS_KEY_FIELD_NUMBER: builtins.int
    id: typing.Text
    """Model or Serving (Group) ID"""

    url: typing.Text
    """URL to access the model or serving group"""

    access_key: typing.Text
    """access_key is used to authenticate requests to the endpoint.
    It is used in the following ways:
    curl -H "NBX-KEY:  $access_key" https://api.nimblebox.ai/ |  $url
    """

    def __init__(self,
        *,
        id: typing.Text = ...,
        url: typing.Text = ...,
        access_key: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["access_key",b"access_key","id",b"id","url",b"url"]) -> None: ...
global___Endpoint = Endpoint

class ServingStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _Status:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ServingStatus._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: ServingStatus._Status.ValueType  # 0
        """Unknown status"""

        STATUS_PENDING: ServingStatus._Status.ValueType  # 1
        """Deployment is pending"""

        STATUS_SUCCESS: ServingStatus._Status.ValueType  # 2
        """Deployment is successful"""

        STATUS_FAILED: ServingStatus._Status.ValueType  # 3
        """Deployment is failed"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        pass

    STATUS_UNSPECIFIED: ServingStatus.Status.ValueType  # 0
    """Unknown status"""

    STATUS_PENDING: ServingStatus.Status.ValueType  # 1
    """Deployment is pending"""

    STATUS_SUCCESS: ServingStatus.Status.ValueType  # 2
    """Deployment is successful"""

    STATUS_FAILED: ServingStatus.Status.ValueType  # 3
    """Deployment is failed"""


    UPLOAD_STATUS_FIELD_NUMBER: builtins.int
    DEPLOY_STATUS_FIELD_NUMBER: builtins.int
    upload_status: global___ServingStatus.Status.ValueType
    deploy_status: global___ServingStatus.Status.ValueType
    def __init__(self,
        *,
        upload_status: global___ServingStatus.Status.ValueType = ...,
        deploy_status: global___ServingStatus.Status.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deploy_status",b"deploy_status","upload_status",b"upload_status"]) -> None: ...
global___ServingStatus = ServingStatus

class ScaleConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    MIN_REPLICAS_FIELD_NUMBER: builtins.int
    MAX_REPLICAS_FIELD_NUMBER: builtins.int
    THRESHOLD_FIELD_NUMBER: builtins.int
    min_replicas: builtins.int
    max_replicas: builtins.int
    threshold: builtins.float
    def __init__(self,
        *,
        min_replicas: builtins.int = ...,
        max_replicas: builtins.int = ...,
        threshold: builtins.float = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["max_replicas",b"max_replicas","min_replicas",b"min_replicas","threshold",b"threshold"]) -> None: ...
global___ScaleConfig = ScaleConfig

class ServingRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AUTH_INFO_FIELD_NUMBER: builtins.int
    SERVING_FIELD_NUMBER: builtins.int
    @property
    def auth_info(self) -> job_pb2.NBXAuthInfo: ...
    @property
    def serving(self) -> global___Serving: ...
    def __init__(self,
        *,
        auth_info: typing.Optional[job_pb2.NBXAuthInfo] = ...,
        serving: typing.Optional[global___Serving] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_info",b"auth_info","serving",b"serving"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_info",b"auth_info","serving",b"serving"]) -> None: ...
global___ServingRequest = ServingRequest

class UpdateServingRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AUTH_INFO_FIELD_NUMBER: builtins.int
    SERVING_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def auth_info(self) -> job_pb2.NBXAuthInfo: ...
    @property
    def serving(self) -> global___Serving: ...
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask: ...
    def __init__(self,
        *,
        auth_info: typing.Optional[job_pb2.NBXAuthInfo] = ...,
        serving: typing.Optional[global___Serving] = ...,
        update_mask: typing.Optional[google.protobuf.field_mask_pb2.FieldMask] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_info",b"auth_info","serving",b"serving","update_mask",b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_info",b"auth_info","serving",b"serving","update_mask",b"update_mask"]) -> None: ...
global___UpdateServingRequest = UpdateServingRequest

class ServingListRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AUTH_INFO_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    @property
    def auth_info(self) -> job_pb2.NBXAuthInfo: ...
    limit: builtins.int
    offset: builtins.int
    def __init__(self,
        *,
        auth_info: typing.Optional[job_pb2.NBXAuthInfo] = ...,
        limit: builtins.int = ...,
        offset: builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_info",b"auth_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_info",b"auth_info","limit",b"limit","offset",b"offset"]) -> None: ...
global___ServingListRequest = ServingListRequest

class ServingListResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SERVINGS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_FIELD_NUMBER: builtins.int
    @property
    def servings(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Serving]: ...
    next_page: builtins.int
    def __init__(self,
        *,
        servings: typing.Optional[typing.Iterable[global___Serving]] = ...,
        next_page: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page",b"next_page","servings",b"servings"]) -> None: ...
global___ServingListResponse = ServingListResponse

class Model(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _ServingType:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _ServingTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Model._ServingType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SERVING_TYPE_UNSPECIFIED: Model._ServingType.ValueType  # 0
        """Unknown deployment type"""

        SERVING_TYPE_NBOX_OP: Model._ServingType.ValueType  # 1
        """Serving via nbox Operators"""

    class ServingType(_ServingType, metaclass=_ServingTypeEnumTypeWrapper):
        """Deployment type"""
        pass

    SERVING_TYPE_UNSPECIFIED: Model.ServingType.ValueType  # 0
    """Unknown deployment type"""

    SERVING_TYPE_NBOX_OP: Model.ServingType.ValueType  # 1
    """Serving via nbox Operators"""


    class _PinStatus:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _PinStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Model._PinStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PIN_STATUS_UNSPECIFIED: Model._PinStatus.ValueType  # 0
        """Unknown pin status"""

        PIN_STATUS_PINNED: Model._PinStatus.ValueType  # 1
        """Model is pinned"""

        PIN_STATUS_UNPINNED: Model._PinStatus.ValueType  # 2
        """Model is unpinned"""

    class PinStatus(_PinStatus, metaclass=_PinStatusEnumTypeWrapper):
        pass

    PIN_STATUS_UNSPECIFIED: Model.PinStatus.ValueType  # 0
    """Unknown pin status"""

    PIN_STATUS_PINNED: Model.PinStatus.ValueType  # 1
    """Model is pinned"""

    PIN_STATUS_UNPINNED: Model.PinStatus.ValueType  # 2
    """Model is unpinned"""


    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SERVING_GROUP_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    RESOURCE_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    ENDPOINT_FIELD_NUMBER: builtins.int
    PIN_STATUS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    id: typing.Text
    """ID for the model"""

    name: typing.Text
    """name of the model"""

    serving_group_id: typing.Text
    """ID of the serving group the model belongs to"""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """time created"""
        pass
    type: global___Model.ServingType.ValueType
    @property
    def resource(self) -> job_pb2.Resource:
        """model resource"""
        pass
    @property
    def code(self) -> job_pb2.Job.Code: ...
    @property
    def endpoint(self) -> global___Endpoint: ...
    pin_status: global___Model.PinStatus.ValueType
    @property
    def status(self) -> global___ServingStatus: ...
    def __init__(self,
        *,
        id: typing.Text = ...,
        name: typing.Text = ...,
        serving_group_id: typing.Text = ...,
        created_at: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        type: global___Model.ServingType.ValueType = ...,
        resource: typing.Optional[job_pb2.Resource] = ...,
        code: typing.Optional[job_pb2.Job.Code] = ...,
        endpoint: typing.Optional[global___Endpoint] = ...,
        pin_status: global___Model.PinStatus.ValueType = ...,
        status: typing.Optional[global___ServingStatus] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["code",b"code","created_at",b"created_at","endpoint",b"endpoint","resource",b"resource","status",b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["code",b"code","created_at",b"created_at","endpoint",b"endpoint","id",b"id","name",b"name","pin_status",b"pin_status","resource",b"resource","serving_group_id",b"serving_group_id","status",b"status","type",b"type"]) -> None: ...
global___Model = Model

class ModelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AUTH_INFO_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    @property
    def auth_info(self) -> job_pb2.NBXAuthInfo: ...
    @property
    def model(self) -> global___Model: ...
    def __init__(self,
        *,
        auth_info: typing.Optional[job_pb2.NBXAuthInfo] = ...,
        model: typing.Optional[global___Model] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_info",b"auth_info","model",b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_info",b"auth_info","model",b"model"]) -> None: ...
global___ModelRequest = ModelRequest

class ModelListRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AUTH_INFO_FIELD_NUMBER: builtins.int
    SERVING_ID_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    @property
    def auth_info(self) -> job_pb2.NBXAuthInfo: ...
    serving_id: typing.Text
    limit: builtins.int
    offset: builtins.int
    def __init__(self,
        *,
        auth_info: typing.Optional[job_pb2.NBXAuthInfo] = ...,
        serving_id: typing.Text = ...,
        limit: builtins.int = ...,
        offset: builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth_info",b"auth_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth_info",b"auth_info","limit",b"limit","offset",b"offset","serving_id",b"serving_id"]) -> None: ...
global___ModelListRequest = ModelListRequest

class ModelListResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]: ...
    next_page: builtins.int
    def __init__(self,
        *,
        models: typing.Optional[typing.Iterable[global___Model]] = ...,
        next_page: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models",b"models","next_page",b"next_page"]) -> None: ...
global___ModelListResponse = ModelListResponse

class ModelLog(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    LOGS_FIELD_NUMBER: builtins.int
    id: typing.Text
    """ID for the model"""

    @property
    def logs(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """logs of the model"""
        pass
    def __init__(self,
        *,
        id: typing.Text = ...,
        logs: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id",b"id","logs",b"logs"]) -> None: ...
global___ModelLog = ModelLog
