#
# Copyright 2020 Kian Cross
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

from setuptools import setup

import pixy.metadata

with open("README.md", "r") as f:
    long_description = f.read()

setup(
    name="pixy",
    author="Kian Cross",
    author_email="kian@kiancross.co.uk",
    url="https://github.com/kiancross/pixy/",
    version=pixy.metadata.version,
    licence="Apache-2.0",
    packages=["pixy"],
    description="Add colour and style to terminal text",
    long_description=long_description,
    long_description_content_type="text/markdown",
    python_requires="~=3.5",

    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Topic :: Software Development :: Libraries :: Python Modules"
    ]
)
