# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/12_callback_core.ipynb (unless otherwise specified).

__all__ = ['Callback', 'Event', 'Setup', 'BeforeTrain', 'BuildBuffer', 'FilterBuffer', 'AfterBuildBuffer',
           'BeforeBatch', 'SampleBatch', 'BeforeFilterBatch', 'FilterBatch', 'AfterSample', 'BeforeComputeReward',
           'ComputeReward', 'AfterComputeReward', 'RewardModification', 'AfterRewardModification', 'GetModelOutputs',
           'AfterGetModelOutputs', 'ComputeLoss', 'ZeroGrad', 'BeforeStep', 'Step', 'AfterBatch', 'AfterTrain',
           'Events', 'SettrDict', 'BatchState']

# Cell

from ..imports import *
from ..core import *
from ..torch_imports import *
from ..torch_core import *

# Cell

class Callback():
    def __init__(self, name='base_callback', order=10):
        self.order=order
        self.name = name
        self.event_timelog = defaultdict(list)

    def __call__(self, event_name):

        start = time.time()
        event = getattr(self, event_name, None)
        if event is not None:
            output = event()
        else:
            output = None

        end = time.time() - start
        self.event_timelog[event_name].append(end)
        return output

    def __repr__(self):
        return self.name

    def _filter_batch(self, valids):
        valids = np.array(valids)
        env = self.environment
        batch_state = env.batch_state

        samples = batch_state.samples
        sources = np.array(batch_state.sources)

        if valids.mean()<1.:
            filtered_samples = [samples[i] for i in range(len(samples)) if valids[i]]
            filtered_sources = [sources[i] for i in range(len(sources)) if valids[i]]
            filtered_latent_data = {}

            for source,latents in batch_state.latent_data.items():
                valid_subset = valids[sources==source]
                latent_filtered = latents[valid_subset]
                filtered_latent_data[source] = latent_filtered

            batch_state.samples = filtered_samples
            batch_state.sources = filtered_sources
            batch_state.latent_data = filtered_latent_data

    def plot_dict(self, data_dict, cols=4, smooth=True):
        num_metrics = len(data_dict.keys())

        rows = int(np.ceil(num_metrics/cols))
        fig, axes = plt.subplots(rows, cols, figsize=(4*cols, 4*rows))

        metrics = list(data_dict.keys())

        for i, ax in enumerate(axes.flat):
            if i <len(metrics):
                ax.plot(np.stack(data_dict[metrics[i]]),)
                ax.set_title(metrics[i])
            else:
                ax.axis('off')

    def plot_time(self, cols=4, smooth=True):
        self.plot_dict(self.event_timelog, cols=cols, smooth=smooth)

    def save(self, filename):
        torch.save(self, filename)

# Cell

class Event():
    '''
    Event

    Base class for events
    '''
    def __init__(self):
        self.event_name = None

# Cell

class Setup(Event):
    '''
    Setup

    Setup is called after an `Environment` is created. The setup
    step is used to do things like set attributes or add logging terms
    '''
    def __init__(self):
        self.event_name = 'setup'

# Cell

class BeforeTrain(Event):
    '''
    BeforeTrain

    This event is called by `Environment.fit` before the first batch is run
    '''
    def __init__(self):
        self.event_name = 'before_train'

# Cell

class BuildBuffer(Event):
    '''
    BuildBuffer

    The build buffer event is used to add samples to the Buffer
    '''
    def __init__(self):
        self.event_name = 'build_buffer'

# Cell

class FilterBuffer(Event):
    '''
    FilterBuffer

    The filter buffer event is used to screen items added to the
    buffer during `build_buffer` and remove ones that do not
    match the filter criteria
    '''
    def __init__(self):
        self.event_name = 'filter_buffer'

# Cell

class AfterBuildBuffer(Event):
    '''
    AfterBuildBuffer

    This event is called after the buffer has been filtered and
    before the next batch starts. This event can be used to
    evaluate metrics and statistics related to the buffer creation
    '''
    def __init__(self):
        self.event_name = 'after_build_buffer'

# Cell

class BeforeBatch(Event):
    '''
    BeforeBatch

    This event is called before the next batch is sampled
    '''
    def __init__(self):
        self.event_name = 'before_batch'

# Cell

class SampleBatch(Event):
    '''
    SampleBatch

    This event produces a series of samples that are added
    to the next batch
    '''
    def __init__(self):
        self.event_name = 'sample_batch'

# Cell

class BeforeFilterBatch(Event):
    '''
    BeforeFilterBatch

    This event is called before the current batch is filtered
    '''
    def __init__(self):
        self.event_name = 'before_filter_batch'

# Cell

class FilterBatch(Event):
    '''
    FilterBatch

    This event is used to screen items in the current batch
    and remove items that do not match the filter criteria
    '''
    def __init__(self):
        self.event_name = 'filter_batch'

# Cell

class AfterSample(Event):
    '''
    AfterSample

    This event is called after a batch is sampled and filtered.
    This event can be used to log stats about the last batch
    '''
    def __init__(self):
        self.event_name = 'after_sample'

# Cell

class BeforeComputeReward(Event):
    '''
    BeforeComputeReward

    This event is called prior to computing rewards
    on the current batch. This event can be used to generate
    any inputs required for computing rewards
    '''
    def __init__(self):
        self.event_name = 'before_compute_reward'

# Cell

class ComputeReward(Event):
    '''
    ComputeReward

    This event is used to compute rewards for
    the current batch

    All rewards should be added to `self.environmemnt.batch_state.rewards`
    '''
    def __init__(self):
        self.event_name = 'compute_reward'

# Cell

class AfterComputeReward(Event):
    '''
    AfterComputeReward

    This event is called after all rewards
    have been computed. This event can be used
    to log stats and metrics related to the
    rewards for the current batch
    '''
    def __init__(self):
        self.event_name = 'after_compute_reward'

# Cell

class RewardModification(Event):
    '''
    RewardModification

    This event is used to modify rewards before they
    are used to compute the model's loss. Reward modifications
    encompass changes to rewards in the context of the current
    training cycle. These are things like "give a score bonus
    to new samples that havent't been seen before" or "penalize
    the score of samples that have occurred in the last 5 batches".

    These types of modifications are kept separate from the core
    reward for logging purposes. Samples are logged with their
    respective rewards. These logged scores are referenced later
    when samples are drawn from the log. This means we need the
    logged score to be independent from "batch context" type scores

    All reward modifications should be
    applied to `self.environmemnt.batch_state.rewards`
    '''
    def __init__(self):
        self.event_name = 'reward_modification'

# Cell

class AfterRewardModification(Event):
    '''
    AfterRewardModification

    This event is called after all reward modifications
    have been computed. This event can be used
    to log stats and metrics related to the
    reward modifications for the current batch
    '''
    def __init__(self):
        self.event_name = 'after_reward_modification'

# Cell

class GetModelOutputs(Event):
    '''
    GetModelOutputs

    This event is used to generate any model-derived outputs
    relevant to loss computation
    '''
    def __init__(self):
        self.event_name = 'get_model_outputs'

# Cell

class AfterGetModelOutputs(Event):
    '''
    AfterGetModelOutputs

    This event is called after `get_model_outputs`.
    This event can be used for any processing
    required prior to loss computation
    '''
    def __init__(self):
        self.event_name = 'after_get_model_outputs'

# Cell

class ComputeLoss(Event):
    '''
    ComputeLoss

    This event is used to compute loss values

    All loss values should be added to
    `self.environment.batch_state.loss`
    '''
    def __init__(self):
        self.event_name = 'compute_loss'

# Cell

class ZeroGrad(Event):
    '''
    ZeroGrad

    This event is used to zero gradients
    in any optimizers relevant to the fit cycle

    `loss.backward()` is called after zero grad
    '''
    def __init__(self):
        self.event_name = 'zero_grad'

# Cell

class BeforeStep(Event):
    '''
    BeforeStep

    This event is used for any processed
    needed after `loss.backward()` but
    before `opt.step()`, ie gradient clipping
    '''
    def __init__(self):
        self.event_name = 'before_step'

# Cell

class Step(Event):
    '''
    Step

    This event is used to step all optimizers
    '''
    def __init__(self):
        self.event_name = 'step'

# Cell

class AfterBatch(Event):
    '''
    AfterBatch

    This event is called after `step`. This
    event can be used to compute batch stats
    and clean up values before the next batch
    '''
    def __init__(self):
        self.event_name = 'after_batch'

# Cell

class AfterTrain(Event):
    '''
    AfterTrain

    This event is called after all
    batch steps have been completed
    '''
    def __init__(self):
        self.event_name = 'after_train'

# Cell

class Events():
    def __init__(self):
        self.setup = Setup()
        self.before_train = BeforeTrain()
        self.build_buffer = BuildBuffer()
        self.filter_buffer = FilterBuffer()
        self.after_build_buffer = AfterBuildBuffer()
        self.before_batch = BeforeBatch()
        self.sample_batch = SampleBatch()
        self.before_filter_batch = BeforeFilterBatch()
        self.filter_batch = FilterBatch()
        self.after_sample = AfterSample()
        self.before_compute_reward = BeforeComputeReward()
        self.compute_reward = ComputeReward()
        self.after_compute_reward = AfterComputeReward()
        self.reward_modification = RewardModification()
        self.get_model_outputs = GetModelOutputs()
        self.after_get_model_outputs = AfterGetModelOutputs()
        self.compute_loss = ComputeLoss()
        self.zero_grad = ZeroGrad()
        self.before_step = BeforeStep()
        self.step = Step()
        self.after_batch = AfterBatch()
        self.after_train = AfterTrain()

        self.event_names = [
            'setup',
            'before_train',
            'build_buffer',
            'filter_buffer',
            'after_build_buffer',
            'before_batch',
            'sample_batch',
            'before_filter_batch',
            'filter_batch',
            'after_sample',
            'before_compute_reward',
            'compute_reward',
            'after_compute_reward',
            'reward_modification',
            'get_model_outputs',
            'after_get_model_outputs',
            'compute_loss',
            'zero_grad',
            'before_step',
            'step',
            'after_batch',
            'after_train'
        ]

    def __call__(self, event_name):

        event = getattr(self, event_name, None)
        if event is not None:
            print(event.__doc__)

# Cell

class SettrDict(dict):
    def __init__(self):
        super().__init__()

    def __setitem__(self, key, item):
        super().__setitem__(key, item)
        super().__setattr__(key, item)

    def __setattr__(self, key, item):
        super().__setitem__(key, item)
        super().__setattr__(key, item)

    def update_from_dict(self, update_dict):
        for k,v in update_dict.items():
            self[k] = v

# Cell

class BatchState(SettrDict):
    def __init__(self):
        super().__init__()

        self.samples = []
        self.sources = []
        self.rewards = to_device(torch.tensor(0.))
        self.loss = to_device(torch.tensor(0., requires_grad=True))
        self.latent_data = {}