# Generated by Django 4.1.7 on 2023-03-02 20:40

import django.core.validators
from django.db import migrations, models
import django.utils.timezone
import okta_client.managers


class Migration(migrations.Migration):

    dependencies = [
        ('okta_client', '0001_initial'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='oktauser',
            options={'verbose_name': 'okta user', 'verbose_name_plural': 'okta users'},
        ),
        migrations.AlterModelManagers(
            name='oktauser',
            managers=[
                ('objects', okta_client.managers.OktaUserManager()),
            ],
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='city',
            field=models.CharField(blank=True, help_text="city or locality component of user's address (locality)", max_length=100, verbose_name='city'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='costCenter',
            field=models.CharField(blank=True, help_text='name of a cost center assigned to user', max_length=100, verbose_name='cost center'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='countryCode',
            field=models.CharField(blank=True, help_text="country name component of user's address (country)", max_length=2, verbose_name='country code'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='date_joined',
            field=models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='department',
            field=models.CharField(blank=True, help_text="name of user's department", max_length=100, verbose_name='department'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='displayName',
            field=models.CharField(blank=True, help_text='name of the user, suitable for display to end users', max_length=250, verbose_name='display name'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='division',
            field=models.CharField(blank=True, help_text="name of user's division", max_length=100, verbose_name='division'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='email',
            field=models.EmailField(help_text='primary email address of user', max_length=254, validators=[django.core.validators.RegexValidator(message='5 <= value length <= 100', regex='^.{5,100}$')], verbose_name='email'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='employeeNumber',
            field=models.CharField(blank=True, help_text='organization or company assigned unique identifier for the user', max_length=100, verbose_name='employee number'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='firstName',
            field=models.CharField(help_text='given name of the user (givenName)', max_length=50, verbose_name='first name'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='honorificPrefix',
            field=models.CharField(blank=True, help_text='honorific prefix(es) of the user, or title in most Western languages', max_length=50, verbose_name='honorific prefix'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='honorificSuffix',
            field=models.CharField(blank=True, help_text='honorific suffix(es) of the user', max_length=50, verbose_name='honorific suffix'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='lastName',
            field=models.CharField(help_text='family name of the user (familyName)', max_length=50, verbose_name='last name'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='locale',
            field=models.CharField(blank=True, help_text="user's default location for purposes of localizing items such as currency, date time format, numerical representations, etc.", max_length=5, verbose_name='locale'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='login',
            field=models.CharField(help_text='unique identifier for the user (username)', max_length=100, primary_key=True, serialize=False, validators=[django.core.validators.RegexValidator(message='5 <= value length <= 100', regex='^.{5,100}$')], verbose_name='login'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='manager',
            field=models.CharField(blank=True, help_text="displayName of the user's manager", max_length=100, verbose_name='manager'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='managerId',
            field=models.CharField(blank=True, help_text="id of a user's manager", max_length=100, verbose_name='manager ID'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='middleName',
            field=models.CharField(blank=True, help_text='middle name(s) of the user', max_length=50, verbose_name='middle name'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='mobilePhone',
            field=models.CharField(blank=True, help_text='mobile phone number of user', max_length=100, verbose_name='mobile phone'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='nickName',
            field=models.CharField(blank=True, help_text='casual way to address the user in real life', max_length=50, verbose_name='nickname'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='organization',
            field=models.CharField(blank=True, help_text="name of user's organization", max_length=100, verbose_name='organization'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='password',
            field=models.CharField(max_length=128, verbose_name='password'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='postalAddress',
            field=models.CharField(blank=True, help_text="mailing address component of user's address", max_length=100, verbose_name='postal address'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='preferredLanguage',
            field=models.CharField(blank=True, help_text="user's preferred written or spoken languages", max_length=100, verbose_name='preferred language'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='primaryPhone',
            field=models.CharField(blank=True, help_text='primary phone number of user such as home number', max_length=100, verbose_name='primary phone'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='profileUrl',
            field=models.URLField(blank=True, help_text="url of user's online profile (e.g. a web page)", verbose_name='profile URL'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='secondEmail',
            field=models.EmailField(blank=True, help_text='secondary email address of user typically used for account recovery', max_length=254, validators=[django.core.validators.RegexValidator(message='5 <= value length <= 100 (or nothing)', regex='(^.{5,100}$)|(ˆ$)')], verbose_name='second email'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='state',
            field=models.CharField(blank=True, help_text="state or region component of user's address (region)", max_length=100, verbose_name='state'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='streetAddress',
            field=models.CharField(blank=True, help_text="full street address component of user's address", max_length=100, verbose_name='street address'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='timezone',
            field=models.CharField(blank=True, help_text="user's time zone", max_length=100, verbose_name='time zone'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='title',
            field=models.CharField(blank=True, help_text='user\'s title, such as "Vice President', max_length=100, verbose_name='title'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='userType',
            field=models.CharField(blank=True, help_text='used to describe the organization to user relationship such as "Employee" or "Contractor"', max_length=100, verbose_name='user type'),
        ),
        migrations.AlterField(
            model_name='oktauser',
            name='zipCode',
            field=models.CharField(blank=True, help_text="zipcode or postal code component of user's address (postalCode)", max_length=100, verbose_name='ZIP code'),
        ),
    ]
