# Generated by Django 3.2.13 on 2022-06-22 12:19
import django.core.validators
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):

    dependencies = [
        ("kustosz", "0003_create_celery_beat_20220108_0935"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="user",
            name="entry_open_read_timeout",
        ),
        migrations.AddField(
            model_name="user",
            name="entry_mark_as_read_open_time",
            field=models.IntegerField(
                default=2,
                help_text="When opened entry should be marked as read (in seconds)",
            ),
        ),
        migrations.AddField(
            model_name="user",
            name="entry_mark_as_read_ratio",
            field=models.FloatField(
                default=1,
                help_text=(
                    "When entry should be marked as read "
                    "(in percent relative to article length)"
                ),
                validators=[
                    django.core.validators.MinValueValidator(0.0),
                    django.core.validators.MaxValueValidator(1.0),
                ],
            ),
        ),
        migrations.AddField(
            model_name="user",
            name="entry_mark_as_read_strategy",
            field=models.CharField(
                choices=[
                    ("never", "Never"),
                    ("opened", "When opened"),
                    ("open_for_time", "When opened for … seconds"),
                    ("ratio_read", "When …% has been read"),
                ],
                default="ratio_read",
                help_text="Automatically mark entry as read when…",
                max_length=20,
            ),
        ),
    ]
