# coding: utf-8

# Copyright 2024, Pulumi Corporation.  All rights reserved.

"""
    ESC (Environments, Secrets, Config) API

    Pulumi ESC allows you to compose and manage hierarchical collections of configuration and secrets and consume them in various ways.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from pulumi_esc_sdk.models.environment_diagnostic import EnvironmentDiagnostic
from pulumi_esc_sdk.models.evaluated_execution_context import EvaluatedExecutionContext
from pulumi_esc_sdk.models.expr import Expr
from pulumi_esc_sdk.models.value import Value
from typing import Optional, Set
from typing_extensions import Self

class CheckEnvironment(BaseModel):
    """
    CheckEnvironment
    """ # noqa: E501
    exprs: Optional[Dict[str, Expr]] = None
    properties: Optional[Dict[str, Value]] = None
    var_schema: Optional[Any] = Field(default=None, alias="schema")
    execution_context: Optional[EvaluatedExecutionContext] = Field(default=None, alias="executionContext")
    diagnostics: Optional[List[EnvironmentDiagnostic]] = None
    __properties: ClassVar[List[str]] = ["exprs", "properties", "schema", "executionContext", "diagnostics"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CheckEnvironment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in exprs (dict)
        _field_dict = {}
        if self.exprs:
            for _key in self.exprs:
                if self.exprs[_key]:
                    _field_dict[_key] = self.exprs[_key].to_dict()
            _dict['exprs'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in properties (dict)
        _field_dict = {}
        if self.properties:
            for _key in self.properties:
                if self.properties[_key]:
                    _field_dict[_key] = self.properties[_key].to_dict()
            _dict['properties'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of execution_context
        if self.execution_context:
            _dict['executionContext'] = self.execution_context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in diagnostics (list)
        _items = []
        if self.diagnostics:
            for _item in self.diagnostics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['diagnostics'] = _items
        # set to None if var_schema (nullable) is None
        # and model_fields_set contains the field
        if self.var_schema is None and "var_schema" in self.model_fields_set:
            _dict['schema'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CheckEnvironment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "exprs": dict(
                (_k, Expr.from_dict(_v))
                for _k, _v in obj["exprs"].items()
            )
            if obj.get("exprs") is not None
            else None,
            "properties": dict(
                (_k, Value.from_dict(_v))
                for _k, _v in obj["properties"].items()
            )
            if obj.get("properties") is not None
            else None,
            "schema": obj.get("schema"),
            "executionContext": EvaluatedExecutionContext.from_dict(obj["executionContext"]) if obj.get("executionContext") is not None else None,
            "diagnostics": [EnvironmentDiagnostic.from_dict(_item) for _item in obj["diagnostics"]] if obj.get("diagnostics") is not None else None
        })
        return _obj


