# Generated by Django 2.2.28 on 2023-07-20 14:53

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='BabelfishProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('babelfish_user_id', models.CharField(blank=True, max_length=255)),
                ('organisation_id', models.CharField(blank=True, default='811', max_length=255)),
                ('client_id', models.CharField(blank=True, max_length=255)),
                ('client_secret', models.CharField(blank=True, max_length=255)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'auto_author': 'user',
                'container_path': '/babelfish_profiles/',
                'serializer_fields': ['@id', 'client_id', 'client_secret'],
                'depth': 0,
                'anonymous_perms': [],
                'authenticated_perms': ['inherit'],
                'owner_perms': ['view', 'change'],
            },
        ),
    ]
