import { Construct } from 'constructs';
import { ChimeVoiceConnector } from '.';
import { PhoneAssociation } from './customResource';
export declare enum PhoneNumberType {
    LOCAL = "Local",
    TOLLFREE = "TollFree"
}
export declare enum PhoneCountry {
    AU = "AU",
    AT = "AT",
    CA = "CA",
    DK = "DK",
    DE = "DE",
    IE = "IE",
    IT = "IT",
    NZ = "NZ",
    NG = "NG",
    PR = "PR",
    KR = "KR",
    SE = "SE",
    CH = "CH",
    UK = "UK",
    US = "US"
}
export declare enum PhoneProductType {
    SMA = "SipMediaApplicationDialIn",
    VC = "VoiceConnector"
}
/**
 * Props for `PhoneNumber`.
 */
export interface PhoneNumberProps {
    /**
     * Area Code for phone number request (optional)  - Usable only with US Country
     *
     * @default - None
     */
    readonly phoneAreaCode?: number;
    /**
     * City for phone number request (optional) - Usable only with US Country
     *
     * @default - None
     */
    readonly phoneCity?: string;
    /**
     * State for phone number request (optional) - Usable only with US Country
     *
     * @default - None
     */
    readonly phoneState?: string;
    /**
     * Toll Free Prefix for phone number request (optional)
     *
     * @default - None
     */
    readonly phoneNumberTollFreePrefix?: number;
    /**
     * Phone Number Type for phone number request (optional) - Local or TollFree - Required with non-US country
     *
     * @default - None
     */
    readonly phoneNumberType?: PhoneNumberType;
    /**
     * Country for phone number request (optional) - See https://docs.aws.amazon.com/chime/latest/ag/phone-country-reqs.html for more details
     *
     * @default - US
     */
    readonly phoneCountry?: PhoneCountry;
    /**
     * Phone Product Type (required) - SipMediaApplicationDialIn or VoiceConnector
     *
     * @default - None
     */
    readonly phoneProductType: PhoneProductType;
}
export declare class ChimePhoneNumber extends Construct {
    readonly phoneNumber: string;
    constructor(scope: Construct, id: string, props: PhoneNumberProps);
    associateWithVoiceConnector(voiceConnectorId: ChimeVoiceConnector): PhoneAssociation;
    private associateNumber;
}
