"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainGroup = exports.DomainGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dns_generated_1 = require("./dns.generated");
Object.defineProperty(exports, "DomainGroupProperty", { enumerable: true, get: function () { return dns_generated_1.RosDomainGroup; } });
/**
 * A ROS resource type:  `ALIYUN::DNS::DomainGroup`
 */
class DomainGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::DNS::DomainGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDomainGroup = new dns_generated_1.RosDomainGroup(this, id, {
            groupName: props.groupName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDomainGroup;
        this.attrGroupId = rosDomainGroup.attrGroupId;
    }
}
exports.DomainGroup = DomainGroup;
//# sourceMappingURL=data:application/json;base64,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