import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigtableAppProfileConfig extends cdktf.TerraformMetaArguments {
    /**
     * The unique name of the app profile in the form '[_a-zA-Z0-9][-_.a-zA-Z0-9]*'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#app_profile_id BigtableAppProfile#app_profile_id}
     *
     * @stability stable
     */
    readonly appProfileId: string;
    /**
     * Long form description of the use case for this app profile.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#description BigtableAppProfile#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * If true, ignore safety checks when deleting/updating the app profile.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#ignore_warnings BigtableAppProfile#ignore_warnings}
     *
     * @stability stable
     */
    readonly ignoreWarnings?: boolean | cdktf.IResolvable;
    /**
     * The name of the instance to create the app profile within.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#instance BigtableAppProfile#instance}
     *
     * @stability stable
     */
    readonly instance?: string;
    /**
     * If true, read/write requests are routed to the nearest cluster in the instance, and will fail over to the nearest cluster that is available in the event of transient errors or delays.
     *
     * Clusters in a region are considered equidistant. Choosing this option sacrifices read-your-writes
     * consistency to improve availability.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#multi_cluster_routing_use_any BigtableAppProfile#multi_cluster_routing_use_any}
     *
     * @stability stable
     */
    readonly multiClusterRoutingUseAny?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#project BigtableAppProfile#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * single_cluster_routing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#single_cluster_routing BigtableAppProfile#single_cluster_routing}
     *
     * @stability stable
     */
    readonly singleClusterRouting?: BigtableAppProfileSingleClusterRouting;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#timeouts BigtableAppProfile#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BigtableAppProfileTimeouts;
}
/**
 * @stability stable
 */
export interface BigtableAppProfileSingleClusterRouting {
    /**
     * If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.
     *
     * It is unsafe to send these requests to the same table/row/column in multiple clusters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#allow_transactional_writes BigtableAppProfile#allow_transactional_writes}
     *
     * @stability stable
     */
    readonly allowTransactionalWrites?: boolean | cdktf.IResolvable;
    /**
     * The cluster to which read/write requests should be routed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#cluster_id BigtableAppProfile#cluster_id}
     *
     * @stability stable
     */
    readonly clusterId: string;
}
export declare function bigtableAppProfileSingleClusterRoutingToTerraform(struct?: BigtableAppProfileSingleClusterRoutingOutputReference | BigtableAppProfileSingleClusterRouting): any;
/**
 * @stability stable
 */
export declare class BigtableAppProfileSingleClusterRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigtableAppProfileSingleClusterRouting | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigtableAppProfileSingleClusterRouting | undefined);
    private _allowTransactionalWrites?;
    /**
     * @stability stable
     */
    get allowTransactionalWrites(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowTransactionalWrites(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowTransactionalWrites(): void;
    /**
     * @stability stable
     */
    get allowTransactionalWritesInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterId?;
    /**
     * @stability stable
     */
    get clusterId(): string;
    /**
     * @stability stable
     */
    set clusterId(value: string);
    /**
     * @stability stable
     */
    get clusterIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigtableAppProfileTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#create BigtableAppProfile#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#delete BigtableAppProfile#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html#update BigtableAppProfile#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function bigtableAppProfileTimeoutsToTerraform(struct?: BigtableAppProfileTimeoutsOutputReference | BigtableAppProfileTimeouts): any;
/**
 * @stability stable
 */
export declare class BigtableAppProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigtableAppProfileTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigtableAppProfileTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html google_bigtable_app_profile}.
 *
 * @stability stable
 */
export declare class BigtableAppProfile extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigtable_app_profile.html google_bigtable_app_profile} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigtableAppProfileConfig);
    private _appProfileId?;
    /**
     * @stability stable
     */
    get appProfileId(): string;
    /**
     * @stability stable
     */
    set appProfileId(value: string);
    /**
     * @stability stable
     */
    get appProfileIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ignoreWarnings?;
    /**
     * @stability stable
     */
    get ignoreWarnings(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ignoreWarnings(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIgnoreWarnings(): void;
    /**
     * @stability stable
     */
    get ignoreWarningsInput(): boolean | cdktf.IResolvable | undefined;
    private _instance?;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    resetInstance(): void;
    /**
     * @stability stable
     */
    get instanceInput(): string | undefined;
    private _multiClusterRoutingUseAny?;
    /**
     * @stability stable
     */
    get multiClusterRoutingUseAny(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set multiClusterRoutingUseAny(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMultiClusterRoutingUseAny(): void;
    /**
     * @stability stable
     */
    get multiClusterRoutingUseAnyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _singleClusterRouting;
    /**
     * @stability stable
     */
    get singleClusterRouting(): BigtableAppProfileSingleClusterRoutingOutputReference;
    /**
     * @stability stable
     */
    putSingleClusterRouting(value: BigtableAppProfileSingleClusterRouting): void;
    /**
     * @stability stable
     */
    resetSingleClusterRouting(): void;
    /**
     * @stability stable
     */
    get singleClusterRoutingInput(): BigtableAppProfileSingleClusterRouting | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BigtableAppProfileTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BigtableAppProfileTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BigtableAppProfileTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
