import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeReservationConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#description ComputeReservation#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#name ComputeReservation#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#project ComputeReservation#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * When set to true, only VMs that target this reservation by name can consume this reservation.
     *
     * Otherwise, it can be consumed by VMs with
     * affinity for any reservation. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#specific_reservation_required ComputeReservation#specific_reservation_required}
     *
     * @stability stable
     */
    readonly specificReservationRequired?: boolean | cdktf.IResolvable;
    /**
     * The zone where the reservation is made.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#zone ComputeReservation#zone}
     *
     * @stability stable
     */
    readonly zone: string;
    /**
     * specific_reservation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#specific_reservation ComputeReservation#specific_reservation}
     *
     * @stability stable
     */
    readonly specificReservation: ComputeReservationSpecificReservation;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#timeouts ComputeReservation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeReservationTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators {
    /**
     * The number of the guest accelerator cards exposed to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#accelerator_count ComputeReservation#accelerator_count}
     *
     * @stability stable
     */
    readonly acceleratorCount: number;
    /**
     * The full or partial URL of the accelerator type to attach to this instance. For example: 'projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100'.
     *
     * If you are creating an instance template, specify only the accelerator name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#accelerator_type ComputeReservation#accelerator_type}
     *
     * @stability stable
     */
    readonly acceleratorType: string;
}
export declare function computeReservationSpecificReservationInstancePropertiesGuestAcceleratorsToTerraform(struct?: ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators): any;
/**
 * @stability stable
 */
export interface ComputeReservationSpecificReservationInstancePropertiesLocalSsds {
    /**
     * The size of the disk in base-2 GB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#disk_size_gb ComputeReservation#disk_size_gb}
     *
     * @stability stable
     */
    readonly diskSizeGb: number;
    /**
     * The disk interface to use for attaching this disk. Default value: "SCSI" Possible values: ["SCSI", "NVME"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#interface ComputeReservation#interface}
     *
     * @stability stable
     */
    readonly interface?: string;
}
export declare function computeReservationSpecificReservationInstancePropertiesLocalSsdsToTerraform(struct?: ComputeReservationSpecificReservationInstancePropertiesLocalSsds): any;
/**
 * @stability stable
 */
export interface ComputeReservationSpecificReservationInstanceProperties {
    /**
     * The name of the machine type to reserve.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#machine_type ComputeReservation#machine_type}
     *
     * @stability stable
     */
    readonly machineType: string;
    /**
     * The minimum CPU platform for the reservation.
     *
     * For example,
     * '"Intel Skylake"'. See
     * the CPU platform availability reference](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform#availablezones)
     * for information on available CPU platforms.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#min_cpu_platform ComputeReservation#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * guest_accelerators block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#guest_accelerators ComputeReservation#guest_accelerators}
     *
     * @stability stable
     */
    readonly guestAccelerators?: ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[];
    /**
     * local_ssds block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#local_ssds ComputeReservation#local_ssds}
     *
     * @stability stable
     */
    readonly localSsds?: ComputeReservationSpecificReservationInstancePropertiesLocalSsds[];
}
export declare function computeReservationSpecificReservationInstancePropertiesToTerraform(struct?: ComputeReservationSpecificReservationInstancePropertiesOutputReference | ComputeReservationSpecificReservationInstanceProperties): any;
/**
 * @stability stable
 */
export declare class ComputeReservationSpecificReservationInstancePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeReservationSpecificReservationInstanceProperties | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeReservationSpecificReservationInstanceProperties | undefined);
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    set machineType(value: string);
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    /**
     * @stability stable
     */
    set minCpuPlatform(value: string);
    /**
     * @stability stable
     */
    resetMinCpuPlatform(): void;
    /**
     * @stability stable
     */
    get minCpuPlatformInput(): string | undefined;
    private _guestAccelerators?;
    /**
     * @stability stable
     */
    get guestAccelerators(): ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[];
    /**
     * @stability stable
     */
    set guestAccelerators(value: ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[]);
    /**
     * @stability stable
     */
    resetGuestAccelerators(): void;
    /**
     * @stability stable
     */
    get guestAcceleratorsInput(): ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[] | undefined;
    private _localSsds?;
    /**
     * @stability stable
     */
    get localSsds(): ComputeReservationSpecificReservationInstancePropertiesLocalSsds[];
    /**
     * @stability stable
     */
    set localSsds(value: ComputeReservationSpecificReservationInstancePropertiesLocalSsds[]);
    /**
     * @stability stable
     */
    resetLocalSsds(): void;
    /**
     * @stability stable
     */
    get localSsdsInput(): ComputeReservationSpecificReservationInstancePropertiesLocalSsds[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeReservationSpecificReservation {
    /**
     * The number of resources that are allocated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#count ComputeReservation#count}
     *
     * @stability stable
     */
    readonly count: number;
    /**
     * instance_properties block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#instance_properties ComputeReservation#instance_properties}
     *
     * @stability stable
     */
    readonly instanceProperties: ComputeReservationSpecificReservationInstanceProperties;
}
export declare function computeReservationSpecificReservationToTerraform(struct?: ComputeReservationSpecificReservationOutputReference | ComputeReservationSpecificReservation): any;
/**
 * @stability stable
 */
export declare class ComputeReservationSpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeReservationSpecificReservation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeReservationSpecificReservation | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _instanceProperties;
    /**
     * @stability stable
     */
    get instanceProperties(): ComputeReservationSpecificReservationInstancePropertiesOutputReference;
    /**
     * @stability stable
     */
    putInstanceProperties(value: ComputeReservationSpecificReservationInstanceProperties): void;
    /**
     * @stability stable
     */
    get instancePropertiesInput(): ComputeReservationSpecificReservationInstanceProperties | undefined;
}
/**
 * @stability stable
 */
export interface ComputeReservationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#create ComputeReservation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#delete ComputeReservation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#update ComputeReservation#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeReservationTimeoutsToTerraform(struct?: ComputeReservationTimeoutsOutputReference | ComputeReservationTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeReservationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeReservationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeReservationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html google_compute_reservation}.
 *
 * @stability stable
 */
export declare class ComputeReservation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html google_compute_reservation} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeReservationConfig);
    /**
     * @stability stable
     */
    get commitment(): string;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _specificReservationRequired?;
    /**
     * @stability stable
     */
    get specificReservationRequired(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set specificReservationRequired(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSpecificReservationRequired(): void;
    /**
     * @stability stable
     */
    get specificReservationRequiredInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _specificReservation;
    /**
     * @stability stable
     */
    get specificReservation(): ComputeReservationSpecificReservationOutputReference;
    /**
     * @stability stable
     */
    putSpecificReservation(value: ComputeReservationSpecificReservation): void;
    /**
     * @stability stable
     */
    get specificReservationInput(): ComputeReservationSpecificReservation | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeReservationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeReservationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeReservationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
