import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MemcacheInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The full name of the GCE network to connect the instance to.  If not provided, 'default' will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#authorized_network MemcacheInstance#authorized_network}
     *
     * @stability stable
     */
    readonly authorizedNetwork?: string;
    /**
     * A user-visible name for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#display_name MemcacheInstance#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Resource labels to represent user-provided metadata.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#labels MemcacheInstance#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The major version of Memcached software.
     *
     * If not provided, latest supported version will be used.
     * Currently the latest supported major version is MEMCACHE_1_5. The minor version will be automatically
     * determined by our system based on the latest supported minor version. Default value: "MEMCACHE_1_5" Possible values: ["MEMCACHE_1_5"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#memcache_version MemcacheInstance#memcache_version}
     *
     * @stability stable
     */
    readonly memcacheVersion?: string;
    /**
     * The resource name of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#name MemcacheInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Number of nodes in the memcache instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#node_count MemcacheInstance#node_count}
     *
     * @stability stable
     */
    readonly nodeCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#project MemcacheInstance#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region of the Memcache instance. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#region MemcacheInstance#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Zones where memcache nodes should be provisioned.  If not provided, all zones will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#zones MemcacheInstance#zones}
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * memcache_parameters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#memcache_parameters MemcacheInstance#memcache_parameters}
     *
     * @stability stable
     */
    readonly memcacheParameters?: MemcacheInstanceMemcacheParameters;
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#node_config MemcacheInstance#node_config}
     *
     * @stability stable
     */
    readonly nodeConfig: MemcacheInstanceNodeConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#timeouts MemcacheInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MemcacheInstanceTimeouts;
}
/**
 * @stability stable
 */
export declare class MemcacheInstanceMemcacheNodes extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    get nodeId(): string;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    get zone(): string;
}
/**
 * @stability stable
 */
export interface MemcacheInstanceMemcacheParameters {
    /**
     * User-defined set of parameters to use in the memcache process.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#params MemcacheInstance#params}
     *
     * @stability stable
     */
    readonly params?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare function memcacheInstanceMemcacheParametersToTerraform(struct?: MemcacheInstanceMemcacheParametersOutputReference | MemcacheInstanceMemcacheParameters): any;
/**
 * @stability stable
 */
export declare class MemcacheInstanceMemcacheParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MemcacheInstanceMemcacheParameters | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MemcacheInstanceMemcacheParameters | undefined);
    private _params?;
    /**
     * @stability stable
     */
    get params(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set params(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParams(): void;
    /**
     * @stability stable
     */
    get paramsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export interface MemcacheInstanceNodeConfig {
    /**
     * Number of CPUs per node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#cpu_count MemcacheInstance#cpu_count}
     *
     * @stability stable
     */
    readonly cpuCount: number;
    /**
     * Memory size in Mebibytes for each memcache node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#memory_size_mb MemcacheInstance#memory_size_mb}
     *
     * @stability stable
     */
    readonly memorySizeMb: number;
}
export declare function memcacheInstanceNodeConfigToTerraform(struct?: MemcacheInstanceNodeConfigOutputReference | MemcacheInstanceNodeConfig): any;
/**
 * @stability stable
 */
export declare class MemcacheInstanceNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MemcacheInstanceNodeConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MemcacheInstanceNodeConfig | undefined);
    private _cpuCount?;
    /**
     * @stability stable
     */
    get cpuCount(): number;
    /**
     * @stability stable
     */
    set cpuCount(value: number);
    /**
     * @stability stable
     */
    get cpuCountInput(): number | undefined;
    private _memorySizeMb?;
    /**
     * @stability stable
     */
    get memorySizeMb(): number;
    /**
     * @stability stable
     */
    set memorySizeMb(value: number);
    /**
     * @stability stable
     */
    get memorySizeMbInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MemcacheInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#create MemcacheInstance#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#delete MemcacheInstance#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#update MemcacheInstance#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function memcacheInstanceTimeoutsToTerraform(struct?: MemcacheInstanceTimeoutsOutputReference | MemcacheInstanceTimeouts): any;
/**
 * @stability stable
 */
export declare class MemcacheInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MemcacheInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MemcacheInstanceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html google_memcache_instance}.
 *
 * @stability stable
 */
export declare class MemcacheInstance extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html google_memcache_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MemcacheInstanceConfig);
    private _authorizedNetwork?;
    /**
     * @stability stable
     */
    get authorizedNetwork(): string;
    /**
     * @stability stable
     */
    set authorizedNetwork(value: string);
    /**
     * @stability stable
     */
    resetAuthorizedNetwork(): void;
    /**
     * @stability stable
     */
    get authorizedNetworkInput(): string | undefined;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get discoveryEndpoint(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get memcacheFullVersion(): string;
    /**
     * @stability stable
     */
    memcacheNodes(index: string): MemcacheInstanceMemcacheNodes;
    private _memcacheVersion?;
    /**
     * @stability stable
     */
    get memcacheVersion(): string;
    /**
     * @stability stable
     */
    set memcacheVersion(value: string);
    /**
     * @stability stable
     */
    resetMemcacheVersion(): void;
    /**
     * @stability stable
     */
    get memcacheVersionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nodeCount?;
    /**
     * @stability stable
     */
    get nodeCount(): number;
    /**
     * @stability stable
     */
    set nodeCount(value: number);
    /**
     * @stability stable
     */
    get nodeCountInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _memcacheParameters;
    /**
     * @stability stable
     */
    get memcacheParameters(): MemcacheInstanceMemcacheParametersOutputReference;
    /**
     * @stability stable
     */
    putMemcacheParameters(value: MemcacheInstanceMemcacheParameters): void;
    /**
     * @stability stable
     */
    resetMemcacheParameters(): void;
    /**
     * @stability stable
     */
    get memcacheParametersInput(): MemcacheInstanceMemcacheParameters | undefined;
    private _nodeConfig;
    /**
     * @stability stable
     */
    get nodeConfig(): MemcacheInstanceNodeConfigOutputReference;
    /**
     * @stability stable
     */
    putNodeConfig(value: MemcacheInstanceNodeConfig): void;
    /**
     * @stability stable
     */
    get nodeConfigInput(): MemcacheInstanceNodeConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MemcacheInstanceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MemcacheInstanceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MemcacheInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
