# -*- coding: utf-8 -*-

from hp_money import Money
from hp_money.currency import Currency
from hp_money.amount import Amount
import pytest


HKD = Currency('HKD', '344', 100)
JPY = Currency('JPY', '392', 1)

amount1 = Amount(888)
amount2 = Amount('888')
amount3 = Amount('888.00')
amount4 = Amount(999)


def test_currency_stringify():
    """ 测试币种字符串输出 """

    assert str(HKD) == 'HKD', 'Currency stringify test error'
    assert str(HKD) != 'JPY', 'Currency stringify test error'
    assert str(JPY) == 'JPY', 'Currency stringify test error'


def test_currency_equality():
    """ 测试币种相等性 """

    assert HKD == HKD, 'Currency equivalent test error'
    assert HKD == Currency('HKD', '344', 100), 'Currency equality test error'
    assert HKD != Currency('HKD', '355', 100), 'Currency equality test error'
    assert HKD != Currency('HKD', '355', 1), 'Currency equality test error'
    assert HKD != JPY, 'Currency equivalent test error'


def test_amount_stringify():
    """ 测试金额字符串输出 """

    assert str(amount1) == str(amount2) == str(amount3) == '888', \
        'Amount stringify test error'
    assert str(amount3) != '888.00', 'Amount stringify test error'


def test_amount_equality():
    """ 测试金额相等性 """

    assert amount1 == amount2 == amount3 != amount4, \
        'Amount equality test error'
    assert amount1 < amount4, 'Amount equality test error'
    assert amount2 < amount4, 'Amount equality test error'
    assert amount3 < amount4, 'Amount equality test error'
    assert amount3 <= amount4, 'Amount equality test error'
    assert amount4 >= amount3, 'Amount equality test error'


def test_amount_calculation():
    """ 测试金额对象的计算 """

    sum1 = amount1 + amount2
    sum2 = amount2 + amount1
    sum3 = amount1 + '888'

    diff1 = amount2 - amount1
    diff2 = amount1 - amount2
    diff3 = amount1 - amount4
    diff4 = amount4 - amount1
    diff5 = amount4 - '888'

    assert diff1 == diff2 == '0', 'Amount equality test error'
    assert diff3 == -111, 'Amount equality test error'
    assert diff3 == -Amount(111), 'Amount equality test error'
    assert diff4 == Amount('111'), 'Amount equality test error'
    assert diff3 != diff4, 'Amount equality test error'
    assert abs(diff3) == diff4, 'Amount equality test error'
    assert diff5 == diff4 == 111, 'Amount equality test error'

    assert sum1 == Amount('1776'), 'Amount equality test error'
    assert sum1 == '1776', 'Amount equality test error'
    assert sum2 == sum1, 'Amount equality test error'
    assert sum3 == sum1, 'Amount equality test error'


def test_money_equality():

    money1 = Money(
        amount=amount1,
        currency=HKD
    )
    money2 = Money(
        amount=amount3,
        currency=HKD
    )
    money3 = Money(
        amount=amount1,
        currency=JPY
    )
    money4 = Money(
        amount=amount4,
        currency=HKD
    )

    assert money1 == money2, 'Money equality test error'
    assert money1 != money3, 'Money equality test error'
    assert money4 != money1, 'Money equality test error'


def test_money_calculation():

    money1 = Money(
        amount=amount1,
        currency=HKD
    )
    money2 = Money(
        amount=amount4,
        currency=HKD
    )
    money3 = Money(
        amount=amount4,
        currency=JPY
    )

    sum1 = money1 + money2
    diff1 = money1 - money2
    diff2 = money2 - money1

    assert sum1 == Money(currency=HKD, amount=Amount('1887'))
    assert diff1 == -Money(currency=HKD, amount=Amount('111'))
    assert diff2 == Money(currency=HKD, amount=Amount('111'))
    assert abs(diff1) == Money(currency=HKD, amount=Amount('111'))
    assert abs(diff1) == abs(diff2)

    with pytest.raises(TypeError) as exc_info:
        sum2 = money1 + money3

    with pytest.raises(TypeError) as exc_info:
        sum2 = money1 + '2'
