"""
Generated definitions and data structures for abi3info.

This module should not be used directly; it is not a public API.
"""

from typing import Final

from abi3info.models import (
    Data,
    FeatureMacro,
    FullStruct,
    Function,
    Macro,
    OpaqueStruct,
    PartialStruct,
    PyVersion,
    Struct,
    Symbol,
    Typedef,
)

# this file was generated; do not modify it by hand!
_FEATURE_MACROS: Final[dict[str, FeatureMacro]] = {
    "MS_WINDOWS": FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
    "HAVE_FORK": FeatureMacro(name="HAVE_FORK", doc="on platforms with fork()", windows=False),
    "USE_STACKCHECK": FeatureMacro(
        name="USE_STACKCHECK", doc="on platforms with USE_STACKCHECK", windows="maybe"
    ),
    "PY_HAVE_THREAD_NATIVE_ID": FeatureMacro(
        name="PY_HAVE_THREAD_NATIVE_ID", doc="on platforms with native thread IDs", windows=True
    ),
    "Py_REF_DEBUG": FeatureMacro(
        name="Py_REF_DEBUG",
        doc="when Python is compiled in debug mode (with Py_REF_DEBUG)",
        windows="maybe",
    ),
}
_STRUCTS: Final[dict[str, Struct]] = {
    "PyObject": PartialStruct(
        name="PyObject", added=PyVersion(major=3, minor=2), members=["ob_refcnt", "ob_type"]
    ),
    "PyVarObject": PartialStruct(
        name="PyVarObject", added=PyVersion(major=3, minor=2), members=["ob_base", "ob_size"]
    ),
    "PyMethodDef": FullStruct(name="PyMethodDef", added=PyVersion(major=3, minor=2)),
    "PyMemberDef": FullStruct(name="PyMemberDef", added=PyVersion(major=3, minor=2)),
    "PyGetSetDef": FullStruct(name="PyGetSetDef", added=PyVersion(major=3, minor=2)),
    "PyModuleDef_Base": FullStruct(name="PyModuleDef_Base", added=PyVersion(major=3, minor=2)),
    "PyModuleDef": FullStruct(name="PyModuleDef", added=PyVersion(major=3, minor=2)),
    "PyStructSequence_Field": FullStruct(
        name="PyStructSequence_Field", added=PyVersion(major=3, minor=2)
    ),
    "PyStructSequence_Desc": FullStruct(
        name="PyStructSequence_Desc", added=PyVersion(major=3, minor=2)
    ),
    "PyType_Slot": FullStruct(name="PyType_Slot", added=PyVersion(major=3, minor=2)),
    "PyType_Spec": FullStruct(name="PyType_Spec", added=PyVersion(major=3, minor=2)),
    "PyThreadState": OpaqueStruct(name="PyThreadState", added=PyVersion(major=3, minor=2)),
    "PyInterpreterState": OpaqueStruct(
        name="PyInterpreterState", added=PyVersion(major=3, minor=2)
    ),
    "PyFrameObject": OpaqueStruct(name="PyFrameObject", added=PyVersion(major=3, minor=2)),
    "symtable": OpaqueStruct(name="symtable", added=PyVersion(major=3, minor=2)),
    "PyWeakReference": OpaqueStruct(name="PyWeakReference", added=PyVersion(major=3, minor=2)),
    "PyLongObject": OpaqueStruct(name="PyLongObject", added=PyVersion(major=3, minor=2)),
    "PyTypeObject": OpaqueStruct(name="PyTypeObject", added=PyVersion(major=3, minor=2)),
    "Py_buffer": FullStruct(name="Py_buffer", added=PyVersion(major=3, minor=11)),
}
_FUNCTIONS: Final[dict[Symbol, Function]] = {
    Symbol(name="PyType_FromSpec"): Function(
        symbol=Symbol(name="PyType_FromSpec"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_Parse"): Function(
        symbol=Symbol(name="PyArg_Parse"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_ParseTuple"): Function(
        symbol=Symbol(name="PyArg_ParseTuple"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_ParseTupleAndKeywords"): Function(
        symbol=Symbol(name="PyArg_ParseTupleAndKeywords"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_UnpackTuple"): Function(
        symbol=Symbol(name="PyArg_UnpackTuple"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_VaParse"): Function(
        symbol=Symbol(name="PyArg_VaParse"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_VaParseTupleAndKeywords"): Function(
        symbol=Symbol(name="PyArg_VaParseTupleAndKeywords"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyArg_ValidateKeywordArguments"): Function(
        symbol=Symbol(name="PyArg_ValidateKeywordArguments"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBool_FromLong"): Function(
        symbol=Symbol(name="PyBool_FromLong"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_AsString"): Function(
        symbol=Symbol(name="PyByteArray_AsString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_Concat"): Function(
        symbol=Symbol(name="PyByteArray_Concat"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_FromObject"): Function(
        symbol=Symbol(name="PyByteArray_FromObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_FromStringAndSize"): Function(
        symbol=Symbol(name="PyByteArray_FromStringAndSize"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_Resize"): Function(
        symbol=Symbol(name="PyByteArray_Resize"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_Size"): Function(
        symbol=Symbol(name="PyByteArray_Size"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_AsString"): Function(
        symbol=Symbol(name="PyBytes_AsString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_AsStringAndSize"): Function(
        symbol=Symbol(name="PyBytes_AsStringAndSize"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_Concat"): Function(
        symbol=Symbol(name="PyBytes_Concat"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_ConcatAndDel"): Function(
        symbol=Symbol(name="PyBytes_ConcatAndDel"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_DecodeEscape"): Function(
        symbol=Symbol(name="PyBytes_DecodeEscape"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_FromFormat"): Function(
        symbol=Symbol(name="PyBytes_FromFormat"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_FromFormatV"): Function(
        symbol=Symbol(name="PyBytes_FromFormatV"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_FromObject"): Function(
        symbol=Symbol(name="PyBytes_FromObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_FromString"): Function(
        symbol=Symbol(name="PyBytes_FromString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_FromStringAndSize"): Function(
        symbol=Symbol(name="PyBytes_FromStringAndSize"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_Repr"): Function(
        symbol=Symbol(name="PyBytes_Repr"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_Size"): Function(
        symbol=Symbol(name="PyBytes_Size"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCFunction_Call"): Function(
        symbol=Symbol(name="PyCFunction_Call"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCFunction_GetFlags"): Function(
        symbol=Symbol(name="PyCFunction_GetFlags"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCFunction_GetFunction"): Function(
        symbol=Symbol(name="PyCFunction_GetFunction"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCFunction_GetSelf"): Function(
        symbol=Symbol(name="PyCFunction_GetSelf"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCFunction_NewEx"): Function(
        symbol=Symbol(name="PyCFunction_NewEx"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCallIter_New"): Function(
        symbol=Symbol(name="PyCallIter_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCallable_Check"): Function(
        symbol=Symbol(name="PyCallable_Check"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_GetContext"): Function(
        symbol=Symbol(name="PyCapsule_GetContext"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_GetDestructor"): Function(
        symbol=Symbol(name="PyCapsule_GetDestructor"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_GetName"): Function(
        symbol=Symbol(name="PyCapsule_GetName"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_GetPointer"): Function(
        symbol=Symbol(name="PyCapsule_GetPointer"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_Import"): Function(
        symbol=Symbol(name="PyCapsule_Import"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_IsValid"): Function(
        symbol=Symbol(name="PyCapsule_IsValid"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_New"): Function(
        symbol=Symbol(name="PyCapsule_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_SetContext"): Function(
        symbol=Symbol(name="PyCapsule_SetContext"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_SetDestructor"): Function(
        symbol=Symbol(name="PyCapsule_SetDestructor"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_SetName"): Function(
        symbol=Symbol(name="PyCapsule_SetName"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_SetPointer"): Function(
        symbol=Symbol(name="PyCapsule_SetPointer"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_BackslashReplaceErrors"): Function(
        symbol=Symbol(name="PyCodec_BackslashReplaceErrors"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_Decode"): Function(
        symbol=Symbol(name="PyCodec_Decode"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_Decoder"): Function(
        symbol=Symbol(name="PyCodec_Decoder"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_Encode"): Function(
        symbol=Symbol(name="PyCodec_Encode"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_Encoder"): Function(
        symbol=Symbol(name="PyCodec_Encoder"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_IgnoreErrors"): Function(
        symbol=Symbol(name="PyCodec_IgnoreErrors"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_IncrementalDecoder"): Function(
        symbol=Symbol(name="PyCodec_IncrementalDecoder"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_IncrementalEncoder"): Function(
        symbol=Symbol(name="PyCodec_IncrementalEncoder"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_KnownEncoding"): Function(
        symbol=Symbol(name="PyCodec_KnownEncoding"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_LookupError"): Function(
        symbol=Symbol(name="PyCodec_LookupError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_Register"): Function(
        symbol=Symbol(name="PyCodec_Register"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_RegisterError"): Function(
        symbol=Symbol(name="PyCodec_RegisterError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_ReplaceErrors"): Function(
        symbol=Symbol(name="PyCodec_ReplaceErrors"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_StreamReader"): Function(
        symbol=Symbol(name="PyCodec_StreamReader"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_StreamWriter"): Function(
        symbol=Symbol(name="PyCodec_StreamWriter"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_StrictErrors"): Function(
        symbol=Symbol(name="PyCodec_StrictErrors"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_XMLCharRefReplaceErrors"): Function(
        symbol=Symbol(name="PyCodec_XMLCharRefReplaceErrors"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyComplex_FromDoubles"): Function(
        symbol=Symbol(name="PyComplex_FromDoubles"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyComplex_ImagAsDouble"): Function(
        symbol=Symbol(name="PyComplex_ImagAsDouble"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyComplex_RealAsDouble"): Function(
        symbol=Symbol(name="PyComplex_RealAsDouble"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDescr_NewClassMethod"): Function(
        symbol=Symbol(name="PyDescr_NewClassMethod"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDescr_NewGetSet"): Function(
        symbol=Symbol(name="PyDescr_NewGetSet"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDescr_NewMember"): Function(
        symbol=Symbol(name="PyDescr_NewMember"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDescr_NewMethod"): Function(
        symbol=Symbol(name="PyDescr_NewMethod"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictProxy_New"): Function(
        symbol=Symbol(name="PyDictProxy_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Clear"): Function(
        symbol=Symbol(name="PyDict_Clear"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Contains"): Function(
        symbol=Symbol(name="PyDict_Contains"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Copy"): Function(
        symbol=Symbol(name="PyDict_Copy"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_DelItem"): Function(
        symbol=Symbol(name="PyDict_DelItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_DelItemString"): Function(
        symbol=Symbol(name="PyDict_DelItemString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_GetItem"): Function(
        symbol=Symbol(name="PyDict_GetItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_GetItemString"): Function(
        symbol=Symbol(name="PyDict_GetItemString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_GetItemWithError"): Function(
        symbol=Symbol(name="PyDict_GetItemWithError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Items"): Function(
        symbol=Symbol(name="PyDict_Items"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Keys"): Function(
        symbol=Symbol(name="PyDict_Keys"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Merge"): Function(
        symbol=Symbol(name="PyDict_Merge"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_MergeFromSeq2"): Function(
        symbol=Symbol(name="PyDict_MergeFromSeq2"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_New"): Function(
        symbol=Symbol(name="PyDict_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Next"): Function(
        symbol=Symbol(name="PyDict_Next"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_SetItem"): Function(
        symbol=Symbol(name="PyDict_SetItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_SetItemString"): Function(
        symbol=Symbol(name="PyDict_SetItemString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Size"): Function(
        symbol=Symbol(name="PyDict_Size"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Update"): Function(
        symbol=Symbol(name="PyDict_Update"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Values"): Function(
        symbol=Symbol(name="PyDict_Values"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_BadArgument"): Function(
        symbol=Symbol(name="PyErr_BadArgument"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_BadInternalCall"): Function(
        symbol=Symbol(name="PyErr_BadInternalCall"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_CheckSignals"): Function(
        symbol=Symbol(name="PyErr_CheckSignals"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Clear"): Function(
        symbol=Symbol(name="PyErr_Clear"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Display"): Function(
        symbol=Symbol(name="PyErr_Display"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_ExceptionMatches"): Function(
        symbol=Symbol(name="PyErr_ExceptionMatches"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Fetch"): Function(
        symbol=Symbol(name="PyErr_Fetch"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Format"): Function(
        symbol=Symbol(name="PyErr_Format"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_GivenExceptionMatches"): Function(
        symbol=Symbol(name="PyErr_GivenExceptionMatches"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_NewException"): Function(
        symbol=Symbol(name="PyErr_NewException"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_NewExceptionWithDoc"): Function(
        symbol=Symbol(name="PyErr_NewExceptionWithDoc"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_NoMemory"): Function(
        symbol=Symbol(name="PyErr_NoMemory"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_NormalizeException"): Function(
        symbol=Symbol(name="PyErr_NormalizeException"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Occurred"): Function(
        symbol=Symbol(name="PyErr_Occurred"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Print"): Function(
        symbol=Symbol(name="PyErr_Print"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_PrintEx"): Function(
        symbol=Symbol(name="PyErr_PrintEx"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_ProgramText"): Function(
        symbol=Symbol(name="PyErr_ProgramText"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_Restore"): Function(
        symbol=Symbol(name="PyErr_Restore"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetFromErrno"): Function(
        symbol=Symbol(name="PyErr_SetFromErrno"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetFromErrnoWithFilename"): Function(
        symbol=Symbol(name="PyErr_SetFromErrnoWithFilename"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetFromErrnoWithFilenameObject"): Function(
        symbol=Symbol(name="PyErr_SetFromErrnoWithFilenameObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetInterrupt"): Function(
        symbol=Symbol(name="PyErr_SetInterrupt"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetNone"): Function(
        symbol=Symbol(name="PyErr_SetNone"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetObject"): Function(
        symbol=Symbol(name="PyErr_SetObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetString"): Function(
        symbol=Symbol(name="PyErr_SetString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SyntaxLocation"): Function(
        symbol=Symbol(name="PyErr_SyntaxLocation"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_WarnEx"): Function(
        symbol=Symbol(name="PyErr_WarnEx"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_WarnExplicit"): Function(
        symbol=Symbol(name="PyErr_WarnExplicit"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_WarnFormat"): Function(
        symbol=Symbol(name="PyErr_WarnFormat"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_WriteUnraisable"): Function(
        symbol=Symbol(name="PyErr_WriteUnraisable"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_AcquireLock"): Function(
        symbol=Symbol(name="PyEval_AcquireLock"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_AcquireThread"): Function(
        symbol=Symbol(name="PyEval_AcquireThread"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_CallFunction"): Function(
        symbol=Symbol(name="PyEval_CallFunction"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_CallMethod"): Function(
        symbol=Symbol(name="PyEval_CallMethod"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_CallObjectWithKeywords"): Function(
        symbol=Symbol(name="PyEval_CallObjectWithKeywords"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_EvalCode"): Function(
        symbol=Symbol(name="PyEval_EvalCode"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_EvalCodeEx"): Function(
        symbol=Symbol(name="PyEval_EvalCodeEx"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_EvalFrame"): Function(
        symbol=Symbol(name="PyEval_EvalFrame"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_EvalFrameEx"): Function(
        symbol=Symbol(name="PyEval_EvalFrameEx"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetBuiltins"): Function(
        symbol=Symbol(name="PyEval_GetBuiltins"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetFrame"): Function(
        symbol=Symbol(name="PyEval_GetFrame"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetFuncDesc"): Function(
        symbol=Symbol(name="PyEval_GetFuncDesc"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetFuncName"): Function(
        symbol=Symbol(name="PyEval_GetFuncName"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetGlobals"): Function(
        symbol=Symbol(name="PyEval_GetGlobals"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_GetLocals"): Function(
        symbol=Symbol(name="PyEval_GetLocals"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_InitThreads"): Function(
        symbol=Symbol(name="PyEval_InitThreads"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_ReleaseLock"): Function(
        symbol=Symbol(name="PyEval_ReleaseLock"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_ReleaseThread"): Function(
        symbol=Symbol(name="PyEval_ReleaseThread"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_RestoreThread"): Function(
        symbol=Symbol(name="PyEval_RestoreThread"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_SaveThread"): Function(
        symbol=Symbol(name="PyEval_SaveThread"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEval_ThreadsInitialized"): Function(
        symbol=Symbol(name="PyEval_ThreadsInitialized"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyException_GetCause"): Function(
        symbol=Symbol(name="PyException_GetCause"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyException_GetContext"): Function(
        symbol=Symbol(name="PyException_GetContext"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyException_GetTraceback"): Function(
        symbol=Symbol(name="PyException_GetTraceback"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyException_SetCause"): Function(
        symbol=Symbol(name="PyException_SetCause"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyException_SetContext"): Function(
        symbol=Symbol(name="PyException_SetContext"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyException_SetTraceback"): Function(
        symbol=Symbol(name="PyException_SetTraceback"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFile_FromFd"): Function(
        symbol=Symbol(name="PyFile_FromFd"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFile_GetLine"): Function(
        symbol=Symbol(name="PyFile_GetLine"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFile_WriteObject"): Function(
        symbol=Symbol(name="PyFile_WriteObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFile_WriteString"): Function(
        symbol=Symbol(name="PyFile_WriteString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_AsDouble"): Function(
        symbol=Symbol(name="PyFloat_AsDouble"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_FromDouble"): Function(
        symbol=Symbol(name="PyFloat_FromDouble"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_FromString"): Function(
        symbol=Symbol(name="PyFloat_FromString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_GetInfo"): Function(
        symbol=Symbol(name="PyFloat_GetInfo"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_GetMax"): Function(
        symbol=Symbol(name="PyFloat_GetMax"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_GetMin"): Function(
        symbol=Symbol(name="PyFloat_GetMin"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFrozenSet_New"): Function(
        symbol=Symbol(name="PyFrozenSet_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGC_Collect"): Function(
        symbol=Symbol(name="PyGC_Collect"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGILState_Ensure"): Function(
        symbol=Symbol(name="PyGILState_Ensure"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGILState_GetThisThreadState"): Function(
        symbol=Symbol(name="PyGILState_GetThisThreadState"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGILState_Release"): Function(
        symbol=Symbol(name="PyGILState_Release"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_AddModule"): Function(
        symbol=Symbol(name="PyImport_AddModule"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_AppendInittab"): Function(
        symbol=Symbol(name="PyImport_AppendInittab"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ExecCodeModule"): Function(
        symbol=Symbol(name="PyImport_ExecCodeModule"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ExecCodeModuleEx"): Function(
        symbol=Symbol(name="PyImport_ExecCodeModuleEx"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ExecCodeModuleWithPathnames"): Function(
        symbol=Symbol(name="PyImport_ExecCodeModuleWithPathnames"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_GetImporter"): Function(
        symbol=Symbol(name="PyImport_GetImporter"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_GetMagicNumber"): Function(
        symbol=Symbol(name="PyImport_GetMagicNumber"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_GetMagicTag"): Function(
        symbol=Symbol(name="PyImport_GetMagicTag"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_GetModuleDict"): Function(
        symbol=Symbol(name="PyImport_GetModuleDict"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_Import"): Function(
        symbol=Symbol(name="PyImport_Import"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ImportFrozenModule"): Function(
        symbol=Symbol(name="PyImport_ImportFrozenModule"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ImportModule"): Function(
        symbol=Symbol(name="PyImport_ImportModule"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ImportModuleLevel"): Function(
        symbol=Symbol(name="PyImport_ImportModuleLevel"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ImportModuleNoBlock"): Function(
        symbol=Symbol(name="PyImport_ImportModuleNoBlock"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ReloadModule"): Function(
        symbol=Symbol(name="PyImport_ReloadModule"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyInterpreterState_Clear"): Function(
        symbol=Symbol(name="PyInterpreterState_Clear"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyInterpreterState_Delete"): Function(
        symbol=Symbol(name="PyInterpreterState_Delete"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyInterpreterState_New"): Function(
        symbol=Symbol(name="PyInterpreterState_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyIter_Next"): Function(
        symbol=Symbol(name="PyIter_Next"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_Append"): Function(
        symbol=Symbol(name="PyList_Append"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_AsTuple"): Function(
        symbol=Symbol(name="PyList_AsTuple"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_GetItem"): Function(
        symbol=Symbol(name="PyList_GetItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_GetSlice"): Function(
        symbol=Symbol(name="PyList_GetSlice"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_Insert"): Function(
        symbol=Symbol(name="PyList_Insert"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_New"): Function(
        symbol=Symbol(name="PyList_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_Reverse"): Function(
        symbol=Symbol(name="PyList_Reverse"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_SetItem"): Function(
        symbol=Symbol(name="PyList_SetItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_SetSlice"): Function(
        symbol=Symbol(name="PyList_SetSlice"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_Size"): Function(
        symbol=Symbol(name="PyList_Size"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_Sort"): Function(
        symbol=Symbol(name="PyList_Sort"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsDouble"): Function(
        symbol=Symbol(name="PyLong_AsDouble"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsLong"): Function(
        symbol=Symbol(name="PyLong_AsLong"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsLongAndOverflow"): Function(
        symbol=Symbol(name="PyLong_AsLongAndOverflow"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsLongLong"): Function(
        symbol=Symbol(name="PyLong_AsLongLong"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsLongLongAndOverflow"): Function(
        symbol=Symbol(name="PyLong_AsLongLongAndOverflow"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsSize_t"): Function(
        symbol=Symbol(name="PyLong_AsSize_t"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsSsize_t"): Function(
        symbol=Symbol(name="PyLong_AsSsize_t"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsUnsignedLong"): Function(
        symbol=Symbol(name="PyLong_AsUnsignedLong"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsUnsignedLongLong"): Function(
        symbol=Symbol(name="PyLong_AsUnsignedLongLong"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsUnsignedLongLongMask"): Function(
        symbol=Symbol(name="PyLong_AsUnsignedLongLongMask"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsUnsignedLongMask"): Function(
        symbol=Symbol(name="PyLong_AsUnsignedLongMask"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_AsVoidPtr"): Function(
        symbol=Symbol(name="PyLong_AsVoidPtr"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromDouble"): Function(
        symbol=Symbol(name="PyLong_FromDouble"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromLong"): Function(
        symbol=Symbol(name="PyLong_FromLong"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromLongLong"): Function(
        symbol=Symbol(name="PyLong_FromLongLong"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromSize_t"): Function(
        symbol=Symbol(name="PyLong_FromSize_t"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromSsize_t"): Function(
        symbol=Symbol(name="PyLong_FromSsize_t"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromString"): Function(
        symbol=Symbol(name="PyLong_FromString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromUnsignedLong"): Function(
        symbol=Symbol(name="PyLong_FromUnsignedLong"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromUnsignedLongLong"): Function(
        symbol=Symbol(name="PyLong_FromUnsignedLongLong"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_FromVoidPtr"): Function(
        symbol=Symbol(name="PyLong_FromVoidPtr"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_GetInfo"): Function(
        symbol=Symbol(name="PyLong_GetInfo"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_Check"): Function(
        symbol=Symbol(name="PyMapping_Check"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_GetItemString"): Function(
        symbol=Symbol(name="PyMapping_GetItemString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_HasKey"): Function(
        symbol=Symbol(name="PyMapping_HasKey"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_HasKeyString"): Function(
        symbol=Symbol(name="PyMapping_HasKeyString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_Items"): Function(
        symbol=Symbol(name="PyMapping_Items"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_Keys"): Function(
        symbol=Symbol(name="PyMapping_Keys"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_Length"): Function(
        symbol=Symbol(name="PyMapping_Length"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_SetItemString"): Function(
        symbol=Symbol(name="PyMapping_SetItemString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_Size"): Function(
        symbol=Symbol(name="PyMapping_Size"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMapping_Values"): Function(
        symbol=Symbol(name="PyMapping_Values"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMem_Free"): Function(
        symbol=Symbol(name="PyMem_Free"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMem_Malloc"): Function(
        symbol=Symbol(name="PyMem_Malloc"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMem_Realloc"): Function(
        symbol=Symbol(name="PyMem_Realloc"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMemoryView_FromObject"): Function(
        symbol=Symbol(name="PyMemoryView_FromObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMemoryView_GetContiguous"): Function(
        symbol=Symbol(name="PyMemoryView_GetContiguous"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_AddIntConstant"): Function(
        symbol=Symbol(name="PyModule_AddIntConstant"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_AddObject"): Function(
        symbol=Symbol(name="PyModule_AddObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_AddStringConstant"): Function(
        symbol=Symbol(name="PyModule_AddStringConstant"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_Create2"): Function(
        symbol=Symbol(name="PyModule_Create2"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetDef"): Function(
        symbol=Symbol(name="PyModule_GetDef"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetDict"): Function(
        symbol=Symbol(name="PyModule_GetDict"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetFilename"): Function(
        symbol=Symbol(name="PyModule_GetFilename"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetFilenameObject"): Function(
        symbol=Symbol(name="PyModule_GetFilenameObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetName"): Function(
        symbol=Symbol(name="PyModule_GetName"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetState"): Function(
        symbol=Symbol(name="PyModule_GetState"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_New"): Function(
        symbol=Symbol(name="PyModule_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Absolute"): Function(
        symbol=Symbol(name="PyNumber_Absolute"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Add"): Function(
        symbol=Symbol(name="PyNumber_Add"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_And"): Function(
        symbol=Symbol(name="PyNumber_And"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_AsSsize_t"): Function(
        symbol=Symbol(name="PyNumber_AsSsize_t"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Check"): Function(
        symbol=Symbol(name="PyNumber_Check"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Divmod"): Function(
        symbol=Symbol(name="PyNumber_Divmod"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Float"): Function(
        symbol=Symbol(name="PyNumber_Float"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_FloorDivide"): Function(
        symbol=Symbol(name="PyNumber_FloorDivide"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceAdd"): Function(
        symbol=Symbol(name="PyNumber_InPlaceAdd"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceAnd"): Function(
        symbol=Symbol(name="PyNumber_InPlaceAnd"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceFloorDivide"): Function(
        symbol=Symbol(name="PyNumber_InPlaceFloorDivide"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceLshift"): Function(
        symbol=Symbol(name="PyNumber_InPlaceLshift"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceMultiply"): Function(
        symbol=Symbol(name="PyNumber_InPlaceMultiply"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceOr"): Function(
        symbol=Symbol(name="PyNumber_InPlaceOr"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlacePower"): Function(
        symbol=Symbol(name="PyNumber_InPlacePower"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceRemainder"): Function(
        symbol=Symbol(name="PyNumber_InPlaceRemainder"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceRshift"): Function(
        symbol=Symbol(name="PyNumber_InPlaceRshift"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceSubtract"): Function(
        symbol=Symbol(name="PyNumber_InPlaceSubtract"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceTrueDivide"): Function(
        symbol=Symbol(name="PyNumber_InPlaceTrueDivide"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceXor"): Function(
        symbol=Symbol(name="PyNumber_InPlaceXor"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Index"): Function(
        symbol=Symbol(name="PyNumber_Index"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Invert"): Function(
        symbol=Symbol(name="PyNumber_Invert"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Long"): Function(
        symbol=Symbol(name="PyNumber_Long"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Lshift"): Function(
        symbol=Symbol(name="PyNumber_Lshift"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Multiply"): Function(
        symbol=Symbol(name="PyNumber_Multiply"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Negative"): Function(
        symbol=Symbol(name="PyNumber_Negative"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Or"): Function(
        symbol=Symbol(name="PyNumber_Or"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Positive"): Function(
        symbol=Symbol(name="PyNumber_Positive"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Power"): Function(
        symbol=Symbol(name="PyNumber_Power"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Remainder"): Function(
        symbol=Symbol(name="PyNumber_Remainder"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Rshift"): Function(
        symbol=Symbol(name="PyNumber_Rshift"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Subtract"): Function(
        symbol=Symbol(name="PyNumber_Subtract"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_ToBase"): Function(
        symbol=Symbol(name="PyNumber_ToBase"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_TrueDivide"): Function(
        symbol=Symbol(name="PyNumber_TrueDivide"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_Xor"): Function(
        symbol=Symbol(name="PyNumber_Xor"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_AfterFork"): Function(
        symbol=Symbol(name="PyOS_AfterFork"),
        added=PyVersion(major=3, minor=2),
        ifdef=FeatureMacro(name="HAVE_FORK", doc="on platforms with fork()", windows=False),
        abi_only=False,
    ),
    Symbol(name="PyOS_InterruptOccurred"): Function(
        symbol=Symbol(name="PyOS_InterruptOccurred"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_double_to_string"): Function(
        symbol=Symbol(name="PyOS_double_to_string"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_getsig"): Function(
        symbol=Symbol(name="PyOS_getsig"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_mystricmp"): Function(
        symbol=Symbol(name="PyOS_mystricmp"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_mystrnicmp"): Function(
        symbol=Symbol(name="PyOS_mystrnicmp"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_setsig"): Function(
        symbol=Symbol(name="PyOS_setsig"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_snprintf"): Function(
        symbol=Symbol(name="PyOS_snprintf"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_string_to_double"): Function(
        symbol=Symbol(name="PyOS_string_to_double"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_strtol"): Function(
        symbol=Symbol(name="PyOS_strtol"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_strtoul"): Function(
        symbol=Symbol(name="PyOS_strtoul"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_vsnprintf"): Function(
        symbol=Symbol(name="PyOS_vsnprintf"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_ASCII"): Function(
        symbol=Symbol(name="PyObject_ASCII"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_AsFileDescriptor"): Function(
        symbol=Symbol(name="PyObject_AsFileDescriptor"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Bytes"): Function(
        symbol=Symbol(name="PyObject_Bytes"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Call"): Function(
        symbol=Symbol(name="PyObject_Call"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CallFunction"): Function(
        symbol=Symbol(name="PyObject_CallFunction"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CallFunctionObjArgs"): Function(
        symbol=Symbol(name="PyObject_CallFunctionObjArgs"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CallMethod"): Function(
        symbol=Symbol(name="PyObject_CallMethod"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CallMethodObjArgs"): Function(
        symbol=Symbol(name="PyObject_CallMethodObjArgs"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CallObject"): Function(
        symbol=Symbol(name="PyObject_CallObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_ClearWeakRefs"): Function(
        symbol=Symbol(name="PyObject_ClearWeakRefs"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_DelItem"): Function(
        symbol=Symbol(name="PyObject_DelItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_DelItemString"): Function(
        symbol=Symbol(name="PyObject_DelItemString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Dir"): Function(
        symbol=Symbol(name="PyObject_Dir"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Format"): Function(
        symbol=Symbol(name="PyObject_Format"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Free"): Function(
        symbol=Symbol(name="PyObject_Free"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GC_Del"): Function(
        symbol=Symbol(name="PyObject_GC_Del"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GC_Track"): Function(
        symbol=Symbol(name="PyObject_GC_Track"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GC_UnTrack"): Function(
        symbol=Symbol(name="PyObject_GC_UnTrack"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GenericGetAttr"): Function(
        symbol=Symbol(name="PyObject_GenericGetAttr"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GenericSetAttr"): Function(
        symbol=Symbol(name="PyObject_GenericSetAttr"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetAttr"): Function(
        symbol=Symbol(name="PyObject_GetAttr"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetAttrString"): Function(
        symbol=Symbol(name="PyObject_GetAttrString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetItem"): Function(
        symbol=Symbol(name="PyObject_GetItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetIter"): Function(
        symbol=Symbol(name="PyObject_GetIter"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_HasAttr"): Function(
        symbol=Symbol(name="PyObject_HasAttr"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_HasAttrString"): Function(
        symbol=Symbol(name="PyObject_HasAttrString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Hash"): Function(
        symbol=Symbol(name="PyObject_Hash"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_HashNotImplemented"): Function(
        symbol=Symbol(name="PyObject_HashNotImplemented"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Init"): Function(
        symbol=Symbol(name="PyObject_Init"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_InitVar"): Function(
        symbol=Symbol(name="PyObject_InitVar"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_IsInstance"): Function(
        symbol=Symbol(name="PyObject_IsInstance"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_IsSubclass"): Function(
        symbol=Symbol(name="PyObject_IsSubclass"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_IsTrue"): Function(
        symbol=Symbol(name="PyObject_IsTrue"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Length"): Function(
        symbol=Symbol(name="PyObject_Length"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Malloc"): Function(
        symbol=Symbol(name="PyObject_Malloc"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Not"): Function(
        symbol=Symbol(name="PyObject_Not"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Realloc"): Function(
        symbol=Symbol(name="PyObject_Realloc"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Repr"): Function(
        symbol=Symbol(name="PyObject_Repr"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_RichCompare"): Function(
        symbol=Symbol(name="PyObject_RichCompare"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_RichCompareBool"): Function(
        symbol=Symbol(name="PyObject_RichCompareBool"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_SelfIter"): Function(
        symbol=Symbol(name="PyObject_SelfIter"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_SetAttr"): Function(
        symbol=Symbol(name="PyObject_SetAttr"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_SetAttrString"): Function(
        symbol=Symbol(name="PyObject_SetAttrString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_SetItem"): Function(
        symbol=Symbol(name="PyObject_SetItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Size"): Function(
        symbol=Symbol(name="PyObject_Size"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Str"): Function(
        symbol=Symbol(name="PyObject_Str"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Type"): Function(
        symbol=Symbol(name="PyObject_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySeqIter_New"): Function(
        symbol=Symbol(name="PySeqIter_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Check"): Function(
        symbol=Symbol(name="PySequence_Check"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Concat"): Function(
        symbol=Symbol(name="PySequence_Concat"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Contains"): Function(
        symbol=Symbol(name="PySequence_Contains"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Count"): Function(
        symbol=Symbol(name="PySequence_Count"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_DelItem"): Function(
        symbol=Symbol(name="PySequence_DelItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_DelSlice"): Function(
        symbol=Symbol(name="PySequence_DelSlice"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Fast"): Function(
        symbol=Symbol(name="PySequence_Fast"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_GetItem"): Function(
        symbol=Symbol(name="PySequence_GetItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_GetSlice"): Function(
        symbol=Symbol(name="PySequence_GetSlice"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_In"): Function(
        symbol=Symbol(name="PySequence_In"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_InPlaceConcat"): Function(
        symbol=Symbol(name="PySequence_InPlaceConcat"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_InPlaceRepeat"): Function(
        symbol=Symbol(name="PySequence_InPlaceRepeat"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Index"): Function(
        symbol=Symbol(name="PySequence_Index"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Length"): Function(
        symbol=Symbol(name="PySequence_Length"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_List"): Function(
        symbol=Symbol(name="PySequence_List"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Repeat"): Function(
        symbol=Symbol(name="PySequence_Repeat"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_SetItem"): Function(
        symbol=Symbol(name="PySequence_SetItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_SetSlice"): Function(
        symbol=Symbol(name="PySequence_SetSlice"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Size"): Function(
        symbol=Symbol(name="PySequence_Size"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySequence_Tuple"): Function(
        symbol=Symbol(name="PySequence_Tuple"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Add"): Function(
        symbol=Symbol(name="PySet_Add"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Clear"): Function(
        symbol=Symbol(name="PySet_Clear"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Contains"): Function(
        symbol=Symbol(name="PySet_Contains"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Discard"): Function(
        symbol=Symbol(name="PySet_Discard"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_New"): Function(
        symbol=Symbol(name="PySet_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Pop"): Function(
        symbol=Symbol(name="PySet_Pop"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Size"): Function(
        symbol=Symbol(name="PySet_Size"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySlice_GetIndices"): Function(
        symbol=Symbol(name="PySlice_GetIndices"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySlice_GetIndicesEx"): Function(
        symbol=Symbol(name="PySlice_GetIndicesEx"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySlice_New"): Function(
        symbol=Symbol(name="PySlice_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyState_FindModule"): Function(
        symbol=Symbol(name="PyState_FindModule"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyStructSequence_GetItem"): Function(
        symbol=Symbol(name="PyStructSequence_GetItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyStructSequence_New"): Function(
        symbol=Symbol(name="PyStructSequence_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyStructSequence_NewType"): Function(
        symbol=Symbol(name="PyStructSequence_NewType"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyStructSequence_SetItem"): Function(
        symbol=Symbol(name="PyStructSequence_SetItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_AddWarnOption"): Function(
        symbol=Symbol(name="PySys_AddWarnOption"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_AddWarnOptionUnicode"): Function(
        symbol=Symbol(name="PySys_AddWarnOptionUnicode"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_FormatStderr"): Function(
        symbol=Symbol(name="PySys_FormatStderr"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_FormatStdout"): Function(
        symbol=Symbol(name="PySys_FormatStdout"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_GetObject"): Function(
        symbol=Symbol(name="PySys_GetObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_HasWarnOptions"): Function(
        symbol=Symbol(name="PySys_HasWarnOptions"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_ResetWarnOptions"): Function(
        symbol=Symbol(name="PySys_ResetWarnOptions"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_SetArgv"): Function(
        symbol=Symbol(name="PySys_SetArgv"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_SetArgvEx"): Function(
        symbol=Symbol(name="PySys_SetArgvEx"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_SetObject"): Function(
        symbol=Symbol(name="PySys_SetObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_SetPath"): Function(
        symbol=Symbol(name="PySys_SetPath"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_WriteStderr"): Function(
        symbol=Symbol(name="PySys_WriteStderr"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_WriteStdout"): Function(
        symbol=Symbol(name="PySys_WriteStdout"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_Clear"): Function(
        symbol=Symbol(name="PyThreadState_Clear"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_Delete"): Function(
        symbol=Symbol(name="PyThreadState_Delete"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_DeleteCurrent"): Function(
        symbol=Symbol(name="PyThreadState_DeleteCurrent"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyThreadState_Get"): Function(
        symbol=Symbol(name="PyThreadState_Get"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_GetDict"): Function(
        symbol=Symbol(name="PyThreadState_GetDict"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_New"): Function(
        symbol=Symbol(name="PyThreadState_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_SetAsyncExc"): Function(
        symbol=Symbol(name="PyThreadState_SetAsyncExc"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_Swap"): Function(
        symbol=Symbol(name="PyThreadState_Swap"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTraceBack_Here"): Function(
        symbol=Symbol(name="PyTraceBack_Here"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTraceBack_Print"): Function(
        symbol=Symbol(name="PyTraceBack_Print"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_GetItem"): Function(
        symbol=Symbol(name="PyTuple_GetItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_GetSlice"): Function(
        symbol=Symbol(name="PyTuple_GetSlice"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_New"): Function(
        symbol=Symbol(name="PyTuple_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_Pack"): Function(
        symbol=Symbol(name="PyTuple_Pack"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_SetItem"): Function(
        symbol=Symbol(name="PyTuple_SetItem"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_Size"): Function(
        symbol=Symbol(name="PyTuple_Size"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_ClearCache"): Function(
        symbol=Symbol(name="PyType_ClearCache"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GenericAlloc"): Function(
        symbol=Symbol(name="PyType_GenericAlloc"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GenericNew"): Function(
        symbol=Symbol(name="PyType_GenericNew"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetFlags"): Function(
        symbol=Symbol(name="PyType_GetFlags"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_IsSubtype"): Function(
        symbol=Symbol(name="PyType_IsSubtype"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_Modified"): Function(
        symbol=Symbol(name="PyType_Modified"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_Ready"): Function(
        symbol=Symbol(name="PyType_Ready"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_Create"): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_Create"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_GetEncoding"): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_GetEncoding"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_GetEnd"): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_GetEnd"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_GetObject"): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_GetObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_GetReason"): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_GetReason"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_GetStart"): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_GetStart"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_SetEnd"): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_SetEnd"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_SetReason"): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_SetReason"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeDecodeError_SetStart"): Function(
        symbol=Symbol(name="PyUnicodeDecodeError_SetStart"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_GetEncoding"): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_GetEncoding"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_GetEnd"): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_GetEnd"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_GetObject"): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_GetObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_GetReason"): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_GetReason"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_GetStart"): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_GetStart"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_SetEnd"): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_SetEnd"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_SetReason"): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_SetReason"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeEncodeError_SetStart"): Function(
        symbol=Symbol(name="PyUnicodeEncodeError_SetStart"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_GetEnd"): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_GetEnd"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_GetObject"): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_GetObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_GetReason"): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_GetReason"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_GetStart"): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_GetStart"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_SetEnd"): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_SetEnd"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_SetReason"): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_SetReason"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeTranslateError_SetStart"): Function(
        symbol=Symbol(name="PyUnicodeTranslateError_SetStart"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Append"): Function(
        symbol=Symbol(name="PyUnicode_Append"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AppendAndDel"): Function(
        symbol=Symbol(name="PyUnicode_AppendAndDel"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsASCIIString"): Function(
        symbol=Symbol(name="PyUnicode_AsASCIIString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsCharmapString"): Function(
        symbol=Symbol(name="PyUnicode_AsCharmapString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsDecodedObject"): Function(
        symbol=Symbol(name="PyUnicode_AsDecodedObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsDecodedUnicode"): Function(
        symbol=Symbol(name="PyUnicode_AsDecodedUnicode"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsEncodedObject"): Function(
        symbol=Symbol(name="PyUnicode_AsEncodedObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsEncodedString"): Function(
        symbol=Symbol(name="PyUnicode_AsEncodedString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsEncodedUnicode"): Function(
        symbol=Symbol(name="PyUnicode_AsEncodedUnicode"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsLatin1String"): Function(
        symbol=Symbol(name="PyUnicode_AsLatin1String"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsRawUnicodeEscapeString"): Function(
        symbol=Symbol(name="PyUnicode_AsRawUnicodeEscapeString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUTF16String"): Function(
        symbol=Symbol(name="PyUnicode_AsUTF16String"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUTF32String"): Function(
        symbol=Symbol(name="PyUnicode_AsUTF32String"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUTF8String"): Function(
        symbol=Symbol(name="PyUnicode_AsUTF8String"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUnicodeEscapeString"): Function(
        symbol=Symbol(name="PyUnicode_AsUnicodeEscapeString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsWideChar"): Function(
        symbol=Symbol(name="PyUnicode_AsWideChar"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Compare"): Function(
        symbol=Symbol(name="PyUnicode_Compare"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Concat"): Function(
        symbol=Symbol(name="PyUnicode_Concat"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Contains"): Function(
        symbol=Symbol(name="PyUnicode_Contains"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Count"): Function(
        symbol=Symbol(name="PyUnicode_Count"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Decode"): Function(
        symbol=Symbol(name="PyUnicode_Decode"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeASCII"): Function(
        symbol=Symbol(name="PyUnicode_DecodeASCII"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeCharmap"): Function(
        symbol=Symbol(name="PyUnicode_DecodeCharmap"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeFSDefault"): Function(
        symbol=Symbol(name="PyUnicode_DecodeFSDefault"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeFSDefaultAndSize"): Function(
        symbol=Symbol(name="PyUnicode_DecodeFSDefaultAndSize"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeLatin1"): Function(
        symbol=Symbol(name="PyUnicode_DecodeLatin1"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeRawUnicodeEscape"): Function(
        symbol=Symbol(name="PyUnicode_DecodeRawUnicodeEscape"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF16"): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF16"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF16Stateful"): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF16Stateful"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF32"): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF32"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF32Stateful"): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF32Stateful"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF8"): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF8"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF8Stateful"): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF8Stateful"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUnicodeEscape"): Function(
        symbol=Symbol(name="PyUnicode_DecodeUnicodeEscape"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FSConverter"): Function(
        symbol=Symbol(name="PyUnicode_FSConverter"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FSDecoder"): Function(
        symbol=Symbol(name="PyUnicode_FSDecoder"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Find"): Function(
        symbol=Symbol(name="PyUnicode_Find"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Format"): Function(
        symbol=Symbol(name="PyUnicode_Format"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromEncodedObject"): Function(
        symbol=Symbol(name="PyUnicode_FromEncodedObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromFormat"): Function(
        symbol=Symbol(name="PyUnicode_FromFormat"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromFormatV"): Function(
        symbol=Symbol(name="PyUnicode_FromFormatV"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromObject"): Function(
        symbol=Symbol(name="PyUnicode_FromObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromOrdinal"): Function(
        symbol=Symbol(name="PyUnicode_FromOrdinal"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromString"): Function(
        symbol=Symbol(name="PyUnicode_FromString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromStringAndSize"): Function(
        symbol=Symbol(name="PyUnicode_FromStringAndSize"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FromWideChar"): Function(
        symbol=Symbol(name="PyUnicode_FromWideChar"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_GetDefaultEncoding"): Function(
        symbol=Symbol(name="PyUnicode_GetDefaultEncoding"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_GetSize"): Function(
        symbol=Symbol(name="PyUnicode_GetSize"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyUnicode_IsIdentifier"): Function(
        symbol=Symbol(name="PyUnicode_IsIdentifier"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Join"): Function(
        symbol=Symbol(name="PyUnicode_Join"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Partition"): Function(
        symbol=Symbol(name="PyUnicode_Partition"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_RPartition"): Function(
        symbol=Symbol(name="PyUnicode_RPartition"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_RSplit"): Function(
        symbol=Symbol(name="PyUnicode_RSplit"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Replace"): Function(
        symbol=Symbol(name="PyUnicode_Replace"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Resize"): Function(
        symbol=Symbol(name="PyUnicode_Resize"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_RichCompare"): Function(
        symbol=Symbol(name="PyUnicode_RichCompare"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Split"): Function(
        symbol=Symbol(name="PyUnicode_Split"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Splitlines"): Function(
        symbol=Symbol(name="PyUnicode_Splitlines"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Tailmatch"): Function(
        symbol=Symbol(name="PyUnicode_Tailmatch"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Translate"): Function(
        symbol=Symbol(name="PyUnicode_Translate"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_BuildEncodingMap"): Function(
        symbol=Symbol(name="PyUnicode_BuildEncodingMap"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_CompareWithASCIIString"): Function(
        symbol=Symbol(name="PyUnicode_CompareWithASCIIString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF7"): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF7"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeUTF7Stateful"): Function(
        symbol=Symbol(name="PyUnicode_DecodeUTF7Stateful"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_EncodeFSDefault"): Function(
        symbol=Symbol(name="PyUnicode_EncodeFSDefault"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_InternFromString"): Function(
        symbol=Symbol(name="PyUnicode_InternFromString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_InternImmortal"): Function(
        symbol=Symbol(name="PyUnicode_InternImmortal"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyUnicode_InternInPlace"): Function(
        symbol=Symbol(name="PyUnicode_InternInPlace"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyWeakref_GetObject"): Function(
        symbol=Symbol(name="PyWeakref_GetObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyWeakref_NewProxy"): Function(
        symbol=Symbol(name="PyWeakref_NewProxy"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyWeakref_NewRef"): Function(
        symbol=Symbol(name="PyWeakref_NewRef"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyWrapper_New"): Function(
        symbol=Symbol(name="PyWrapper_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_AddPendingCall"): Function(
        symbol=Symbol(name="Py_AddPendingCall"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_AtExit"): Function(
        symbol=Symbol(name="Py_AtExit"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_BuildValue"): Function(
        symbol=Symbol(name="Py_BuildValue"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_CompileString"): Function(
        symbol=Symbol(name="Py_CompileString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_DecRef"): Function(
        symbol=Symbol(name="Py_DecRef"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_EndInterpreter"): Function(
        symbol=Symbol(name="Py_EndInterpreter"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_Exit"): Function(
        symbol=Symbol(name="Py_Exit"), added=PyVersion(major=3, minor=2), ifdef=None, abi_only=False
    ),
    Symbol(name="Py_FatalError"): Function(
        symbol=Symbol(name="Py_FatalError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_Finalize"): Function(
        symbol=Symbol(name="Py_Finalize"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetBuildInfo"): Function(
        symbol=Symbol(name="Py_GetBuildInfo"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetCompiler"): Function(
        symbol=Symbol(name="Py_GetCompiler"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetCopyright"): Function(
        symbol=Symbol(name="Py_GetCopyright"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetExecPrefix"): Function(
        symbol=Symbol(name="Py_GetExecPrefix"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetPath"): Function(
        symbol=Symbol(name="Py_GetPath"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetPlatform"): Function(
        symbol=Symbol(name="Py_GetPlatform"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetPrefix"): Function(
        symbol=Symbol(name="Py_GetPrefix"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetProgramFullPath"): Function(
        symbol=Symbol(name="Py_GetProgramFullPath"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetProgramName"): Function(
        symbol=Symbol(name="Py_GetProgramName"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetPythonHome"): Function(
        symbol=Symbol(name="Py_GetPythonHome"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetRecursionLimit"): Function(
        symbol=Symbol(name="Py_GetRecursionLimit"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetVersion"): Function(
        symbol=Symbol(name="Py_GetVersion"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_IncRef"): Function(
        symbol=Symbol(name="Py_IncRef"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_Initialize"): Function(
        symbol=Symbol(name="Py_Initialize"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_InitializeEx"): Function(
        symbol=Symbol(name="Py_InitializeEx"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_IsInitialized"): Function(
        symbol=Symbol(name="Py_IsInitialized"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_Main"): Function(
        symbol=Symbol(name="Py_Main"), added=PyVersion(major=3, minor=2), ifdef=None, abi_only=False
    ),
    Symbol(name="Py_MakePendingCalls"): Function(
        symbol=Symbol(name="Py_MakePendingCalls"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_NewInterpreter"): Function(
        symbol=Symbol(name="Py_NewInterpreter"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_ReprEnter"): Function(
        symbol=Symbol(name="Py_ReprEnter"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_ReprLeave"): Function(
        symbol=Symbol(name="Py_ReprLeave"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_SetProgramName"): Function(
        symbol=Symbol(name="Py_SetProgramName"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_SetPythonHome"): Function(
        symbol=Symbol(name="Py_SetPythonHome"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_SetRecursionLimit"): Function(
        symbol=Symbol(name="Py_SetRecursionLimit"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_VaBuildValue"): Function(
        symbol=Symbol(name="Py_VaBuildValue"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="_PyErr_BadInternalCall"): Function(
        symbol=Symbol(name="_PyErr_BadInternalCall"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_CallFunction_SizeT"): Function(
        symbol=Symbol(name="_PyObject_CallFunction_SizeT"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_CallMethod_SizeT"): Function(
        symbol=Symbol(name="_PyObject_CallMethod_SizeT"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_GC_New"): Function(
        symbol=Symbol(name="_PyObject_GC_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_GC_NewVar"): Function(
        symbol=Symbol(name="_PyObject_GC_NewVar"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_GC_Resize"): Function(
        symbol=Symbol(name="_PyObject_GC_Resize"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_New"): Function(
        symbol=Symbol(name="_PyObject_New"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyObject_NewVar"): Function(
        symbol=Symbol(name="_PyObject_NewVar"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyState_AddModule"): Function(
        symbol=Symbol(name="_PyState_AddModule"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyThreadState_Init"): Function(
        symbol=Symbol(name="_PyThreadState_Init"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyThreadState_Prealloc"): Function(
        symbol=Symbol(name="_PyThreadState_Prealloc"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_BuildValue_SizeT"): Function(
        symbol=Symbol(name="_Py_BuildValue_SizeT"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_CheckRecursiveCall"): Function(
        symbol=Symbol(name="_Py_CheckRecursiveCall"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_Dealloc"): Function(
        symbol=Symbol(name="_Py_Dealloc"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_VaBuildValue_SizeT"): Function(
        symbol=Symbol(name="_Py_VaBuildValue_SizeT"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyObject_AsCharBuffer"): Function(
        symbol=Symbol(name="PyObject_AsCharBuffer"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_AsReadBuffer"): Function(
        symbol=Symbol(name="PyObject_AsReadBuffer"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_AsWriteBuffer"): Function(
        symbol=Symbol(name="PyObject_AsWriteBuffer"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CheckReadBuffer"): Function(
        symbol=Symbol(name="PyObject_CheckReadBuffer"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMarshal_ReadObjectFromString"): Function(
        symbol=Symbol(name="PyMarshal_ReadObjectFromString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyMarshal_WriteObjectToString"): Function(
        symbol=Symbol(name="PyMarshal_WriteObjectToString"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyMember_GetOne"): Function(
        symbol=Symbol(name="PyMember_GetOne"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMember_SetOne"): Function(
        symbol=Symbol(name="PyMember_SetOne"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_ReInitTLS"): Function(
        symbol=Symbol(name="PyThread_ReInitTLS"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_create_key"): Function(
        symbol=Symbol(name="PyThread_create_key"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_delete_key"): Function(
        symbol=Symbol(name="PyThread_delete_key"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_set_key_value"): Function(
        symbol=Symbol(name="PyThread_set_key_value"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_get_key_value"): Function(
        symbol=Symbol(name="PyThread_get_key_value"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_delete_key_value"): Function(
        symbol=Symbol(name="PyThread_delete_key_value"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_acquire_lock"): Function(
        symbol=Symbol(name="PyThread_acquire_lock"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_acquire_lock_timed"): Function(
        symbol=Symbol(name="PyThread_acquire_lock_timed"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_allocate_lock"): Function(
        symbol=Symbol(name="PyThread_allocate_lock"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_exit_thread"): Function(
        symbol=Symbol(name="PyThread_exit_thread"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_free_lock"): Function(
        symbol=Symbol(name="PyThread_free_lock"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_get_stacksize"): Function(
        symbol=Symbol(name="PyThread_get_stacksize"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_get_thread_ident"): Function(
        symbol=Symbol(name="PyThread_get_thread_ident"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_get_thread_native_id"): Function(
        symbol=Symbol(name="PyThread_get_thread_native_id"),
        added=PyVersion(major=3, minor=2),
        ifdef=FeatureMacro(
            name="PY_HAVE_THREAD_NATIVE_ID", doc="on platforms with native thread IDs", windows=True
        ),
        abi_only=False,
    ),
    Symbol(name="PyThread_init_thread"): Function(
        symbol=Symbol(name="PyThread_init_thread"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_release_lock"): Function(
        symbol=Symbol(name="PyThread_release_lock"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_set_stacksize"): Function(
        symbol=Symbol(name="PyThread_set_stacksize"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_start_new_thread"): Function(
        symbol=Symbol(name="PyThread_start_new_thread"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyState_AddModule"): Function(
        symbol=Symbol(name="PyState_AddModule"),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyState_RemoveModule"): Function(
        symbol=Symbol(name="PyState_RemoveModule"),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_FromSpecWithBases"): Function(
        symbol=Symbol(name="PyType_FromSpecWithBases"),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="_PyArg_Parse_SizeT"): Function(
        symbol=Symbol(name="_PyArg_Parse_SizeT"),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyArg_ParseTuple_SizeT"): Function(
        symbol=Symbol(name="_PyArg_ParseTuple_SizeT"),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyArg_ParseTupleAndKeywords_SizeT"): Function(
        symbol=Symbol(name="_PyArg_ParseTupleAndKeywords_SizeT"),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyArg_VaParse_SizeT"): Function(
        symbol=Symbol(name="_PyArg_VaParse_SizeT"),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyArg_VaParseTupleAndKeywords_SizeT"): Function(
        symbol=Symbol(name="_PyArg_VaParseTupleAndKeywords_SizeT"),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyThread_GetInfo"): Function(
        symbol=Symbol(name="PyThread_GetInfo"),
        added=PyVersion(major=3, minor=3),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCFunction_New"): Function(
        symbol=Symbol(name="PyCFunction_New"),
        added=PyVersion(major=3, minor=4),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetSlot"): Function(
        symbol=Symbol(name="PyType_GetSlot"),
        added=PyVersion(major=3, minor=4),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_FormatV"): Function(
        symbol=Symbol(name="PyErr_FormatV"),
        added=PyVersion(major=3, minor=5),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModuleDef_Init"): Function(
        symbol=Symbol(name="PyModuleDef_Init"),
        added=PyVersion(major=3, minor=5),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_FinalizeEx"): Function(
        symbol=Symbol(name="Py_FinalizeEx"),
        added=PyVersion(major=3, minor=6),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_FSPath"): Function(
        symbol=Symbol(name="PyOS_FSPath"),
        added=PyVersion(major=3, minor=6),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_ResourceWarning"): Function(
        symbol=Symbol(name="PyErr_ResourceWarning"),
        added=PyVersion(major=3, minor=6),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetImportErrorSubclass"): Function(
        symbol=Symbol(name="PyErr_SetImportErrorSubclass"),
        added=PyVersion(major=3, minor=6),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_NameReplaceErrors"): Function(
        symbol=Symbol(name="PyCodec_NameReplaceErrors"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_GetExcInfo"): Function(
        symbol=Symbol(name="PyErr_GetExcInfo"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetExcInfo"): Function(
        symbol=Symbol(name="PyErr_SetExcInfo"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetFromErrnoWithFilenameObjects"): Function(
        symbol=Symbol(name="PyErr_SetFromErrnoWithFilenameObjects"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetImportError"): Function(
        symbol=Symbol(name="PyErr_SetImportError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SyntaxLocationEx"): Function(
        symbol=Symbol(name="PyErr_SyntaxLocationEx"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_AddModuleObject"): Function(
        symbol=Symbol(name="PyImport_AddModuleObject"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ExecCodeModuleObject"): Function(
        symbol=Symbol(name="PyImport_ExecCodeModuleObject"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ImportFrozenModuleObject"): Function(
        symbol=Symbol(name="PyImport_ImportFrozenModuleObject"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyImport_ImportModuleLevelObject"): Function(
        symbol=Symbol(name="PyImport_ImportModuleLevelObject"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMem_Calloc"): Function(
        symbol=Symbol(name="PyMem_Calloc"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMemoryView_FromMemory"): Function(
        symbol=Symbol(name="PyMemoryView_FromMemory"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_AddFunctions"): Function(
        symbol=Symbol(name="PyModule_AddFunctions"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_ExecDef"): Function(
        symbol=Symbol(name="PyModule_ExecDef"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_FromDefAndSpec2"): Function(
        symbol=Symbol(name="PyModule_FromDefAndSpec2"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_GetNameObject"): Function(
        symbol=Symbol(name="PyModule_GetNameObject"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_NewObject"): Function(
        symbol=Symbol(name="PyModule_NewObject"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_SetDocString"): Function(
        symbol=Symbol(name="PyModule_SetDocString"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_InPlaceMatrixMultiply"): Function(
        symbol=Symbol(name="PyNumber_InPlaceMatrixMultiply"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyNumber_MatrixMultiply"): Function(
        symbol=Symbol(name="PyNumber_MatrixMultiply"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Calloc"): Function(
        symbol=Symbol(name="PyObject_Calloc"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GenericSetDict"): Function(
        symbol=Symbol(name="PyObject_GenericSetDict"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_AddXOption"): Function(
        symbol=Symbol(name="PySys_AddXOption"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySys_GetXOptions"): Function(
        symbol=Symbol(name="PySys_GetXOptions"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUCS4"): Function(
        symbol=Symbol(name="PyUnicode_AsUCS4"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUCS4Copy"): Function(
        symbol=Symbol(name="PyUnicode_AsUCS4Copy"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsWideCharString"): Function(
        symbol=Symbol(name="PyUnicode_AsWideCharString"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeLocale"): Function(
        symbol=Symbol(name="PyUnicode_DecodeLocale"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeLocaleAndSize"): Function(
        symbol=Symbol(name="PyUnicode_DecodeLocaleAndSize"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_EncodeLocale"): Function(
        symbol=Symbol(name="PyUnicode_EncodeLocale"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_FindChar"): Function(
        symbol=Symbol(name="PyUnicode_FindChar"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_GetLength"): Function(
        symbol=Symbol(name="PyUnicode_GetLength"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_ReadChar"): Function(
        symbol=Symbol(name="PyUnicode_ReadChar"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Substring"): Function(
        symbol=Symbol(name="PyUnicode_Substring"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_WriteChar"): Function(
        symbol=Symbol(name="PyUnicode_WriteChar"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_DecodeLocale"): Function(
        symbol=Symbol(name="Py_DecodeLocale"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_EncodeLocale"): Function(
        symbol=Symbol(name="Py_EncodeLocale"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_SetPath"): Function(
        symbol=Symbol(name="Py_SetPath"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetExcFromWindowsErr"): Function(
        symbol=Symbol(name="PyErr_SetExcFromWindowsErr"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyErr_SetExcFromWindowsErrWithFilename"): Function(
        symbol=Symbol(name="PyErr_SetExcFromWindowsErrWithFilename"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyErr_SetExcFromWindowsErrWithFilenameObject"): Function(
        symbol=Symbol(name="PyErr_SetExcFromWindowsErrWithFilenameObject"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyErr_SetExcFromWindowsErrWithFilenameObjects"): Function(
        symbol=Symbol(name="PyErr_SetExcFromWindowsErrWithFilenameObjects"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyErr_SetFromWindowsErr"): Function(
        symbol=Symbol(name="PyErr_SetFromWindowsErr"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyErr_SetFromWindowsErrWithFilename"): Function(
        symbol=Symbol(name="PyErr_SetFromWindowsErrWithFilename"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyOS_CheckStack"): Function(
        symbol=Symbol(name="PyOS_CheckStack"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(
            name="USE_STACKCHECK", doc="on platforms with USE_STACKCHECK", windows="maybe"
        ),
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsMBCSString"): Function(
        symbol=Symbol(name="PyUnicode_AsMBCSString"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeCodePageStateful"): Function(
        symbol=Symbol(name="PyUnicode_DecodeCodePageStateful"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeMBCS"): Function(
        symbol=Symbol(name="PyUnicode_DecodeMBCS"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyUnicode_DecodeMBCSStateful"): Function(
        symbol=Symbol(name="PyUnicode_DecodeMBCSStateful"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PyUnicode_EncodeCodePage"): Function(
        symbol=Symbol(name="PyUnicode_EncodeCodePage"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="PySlice_AdjustIndices"): Function(
        symbol=Symbol(name="PySlice_AdjustIndices"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySlice_Unpack"): Function(
        symbol=Symbol(name="PySlice_Unpack"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyInterpreterState_GetID"): Function(
        symbol=Symbol(name="PyInterpreterState_GetID"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_alloc"): Function(
        symbol=Symbol(name="PyThread_tss_alloc"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_create"): Function(
        symbol=Symbol(name="PyThread_tss_create"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_delete"): Function(
        symbol=Symbol(name="PyThread_tss_delete"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_free"): Function(
        symbol=Symbol(name="PyThread_tss_free"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_get"): Function(
        symbol=Symbol(name="PyThread_tss_get"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_is_created"): Function(
        symbol=Symbol(name="PyThread_tss_is_created"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThread_tss_set"): Function(
        symbol=Symbol(name="PyThread_tss_set"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_BeforeFork"): Function(
        symbol=Symbol(name="PyOS_BeforeFork"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="HAVE_FORK", doc="on platforms with fork()", windows=False),
        abi_only=False,
    ),
    Symbol(name="PyOS_AfterFork_Parent"): Function(
        symbol=Symbol(name="PyOS_AfterFork_Parent"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="HAVE_FORK", doc="on platforms with fork()", windows=False),
        abi_only=False,
    ),
    Symbol(name="PyOS_AfterFork_Child"): Function(
        symbol=Symbol(name="PyOS_AfterFork_Child"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="HAVE_FORK", doc="on platforms with fork()", windows=False),
        abi_only=False,
    ),
    Symbol(name="PyImport_GetModule"): Function(
        symbol=Symbol(name="PyImport_GetModule"),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExceptionClass_Name"): Function(
        symbol=Symbol(name="PyExceptionClass_Name"),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyIndex_Check"): Function(
        symbol=Symbol(name="PyIndex_Check"),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyIter_Check"): Function(
        symbol=Symbol(name="PyIter_Check"),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyInterpreterState_GetDict"): Function(
        symbol=Symbol(name="PyInterpreterState_GetDict"),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_BytesMain"): Function(
        symbol=Symbol(name="Py_BytesMain"),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_EnterRecursiveCall"): Function(
        symbol=Symbol(name="Py_EnterRecursiveCall"),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_LeaveRecursiveCall"): Function(
        symbol=Symbol(name="Py_LeaveRecursiveCall"),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GenericAlias"): Function(
        symbol=Symbol(name="Py_GenericAlias"),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCMethod_New"): Function(
        symbol=Symbol(name="PyCMethod_New"),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyInterpreterState_Get"): Function(
        symbol=Symbol(name="PyInterpreterState_Get"),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GC_IsFinalized"): Function(
        symbol=Symbol(name="PyObject_GC_IsFinalized"),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GC_IsTracked"): Function(
        symbol=Symbol(name="PyObject_GC_IsTracked"),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GetArgcArgv"): Function(
        symbol=Symbol(name="Py_GetArgcArgv"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyIter_Send"): Function(
        symbol=Symbol(name="PyIter_Send"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_AsUTF8AndSize"): Function(
        symbol=Symbol(name="PyUnicode_AsUTF8AndSize"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GenericGetDict"): Function(
        symbol=Symbol(name="PyObject_GenericGetDict"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_NewRef"): Function(
        symbol=Symbol(name="Py_NewRef"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_XNewRef"): Function(
        symbol=Symbol(name="Py_XNewRef"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_AddType"): Function(
        symbol=Symbol(name="PyModule_AddType"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_FromModuleAndSpec"): Function(
        symbol=Symbol(name="PyType_FromModuleAndSpec"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetModule"): Function(
        symbol=Symbol(name="PyType_GetModule"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetModuleState"): Function(
        symbol=Symbol(name="PyType_GetModuleState"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFrame_GetLineNumber"): Function(
        symbol=Symbol(name="PyFrame_GetLineNumber"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFrame_GetCode"): Function(
        symbol=Symbol(name="PyFrame_GetCode"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CallNoArgs"): Function(
        symbol=Symbol(name="PyObject_CallNoArgs"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_GetFrame"): Function(
        symbol=Symbol(name="PyThreadState_GetFrame"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_GetID"): Function(
        symbol=Symbol(name="PyThreadState_GetID"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyThreadState_GetInterpreter"): Function(
        symbol=Symbol(name="PyThreadState_GetInterpreter"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_AddObjectRef"): Function(
        symbol=Symbol(name="PyModule_AddObjectRef"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCodec_Unregister"): Function(
        symbol=Symbol(name="PyCodec_Unregister"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetInterruptEx"): Function(
        symbol=Symbol(name="PyErr_SetInterruptEx"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_Is"): Function(
        symbol=Symbol(name="Py_Is"), added=PyVersion(major=3, minor=10), ifdef=None, abi_only=False
    ),
    Symbol(name="Py_IsTrue"): Function(
        symbol=Symbol(name="Py_IsTrue"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_IsFalse"): Function(
        symbol=Symbol(name="Py_IsFalse"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_IsNone"): Function(
        symbol=Symbol(name="Py_IsNone"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="_Py_IncRef"): Function(
        symbol=Symbol(name="_Py_IncRef"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_DecRef"): Function(
        symbol=Symbol(name="_Py_DecRef"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyAIter_Check"): Function(
        symbol=Symbol(name="PyAIter_Check"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetAIter"): Function(
        symbol=Symbol(name="PyObject_GetAIter"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="_Py_NegativeRefcount"): Function(
        symbol=Symbol(name="_Py_NegativeRefcount"),
        added=PyVersion(major=3, minor=10),
        ifdef=FeatureMacro(
            name="Py_REF_DEBUG",
            doc="when Python is compiled in debug mode (with Py_REF_DEBUG)",
            windows="maybe",
        ),
        abi_only=True,
    ),
    Symbol(name="PyGC_Disable"): Function(
        symbol=Symbol(name="PyGC_Disable"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGC_Enable"): Function(
        symbol=Symbol(name="PyGC_Enable"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGC_IsEnabled"): Function(
        symbol=Symbol(name="PyGC_IsEnabled"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetName"): Function(
        symbol=Symbol(name="PyType_GetName"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_GetQualName"): Function(
        symbol=Symbol(name="PyType_GetQualName"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CheckBuffer"): Function(
        symbol=Symbol(name="PyObject_CheckBuffer"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_GetBuffer"): Function(
        symbol=Symbol(name="PyObject_GetBuffer"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_GetPointer"): Function(
        symbol=Symbol(name="PyBuffer_GetPointer"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_SizeFromFormat"): Function(
        symbol=Symbol(name="PyBuffer_SizeFromFormat"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_ToContiguous"): Function(
        symbol=Symbol(name="PyBuffer_ToContiguous"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_FromContiguous"): Function(
        symbol=Symbol(name="PyBuffer_FromContiguous"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_CopyData"): Function(
        symbol=Symbol(name="PyObject_CopyData"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_IsContiguous"): Function(
        symbol=Symbol(name="PyBuffer_IsContiguous"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_FillContiguousStrides"): Function(
        symbol=Symbol(name="PyBuffer_FillContiguousStrides"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_FillInfo"): Function(
        symbol=Symbol(name="PyBuffer_FillInfo"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBuffer_Release"): Function(
        symbol=Symbol(name="PyBuffer_Release"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMemoryView_FromBuffer"): Function(
        symbol=Symbol(name="PyMemoryView_FromBuffer"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_GetHandledException"): Function(
        symbol=Symbol(name="PyErr_GetHandledException"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyErr_SetHandledException"): Function(
        symbol=Symbol(name="PyErr_SetHandledException"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_FromMetaclass"): Function(
        symbol=Symbol(name="PyType_FromMetaclass"),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyVectorcall_NARGS"): Function(
        symbol=Symbol(name="PyVectorcall_NARGS"),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyVectorcall_Call"): Function(
        symbol=Symbol(name="PyVectorcall_Call"),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_Vectorcall"): Function(
        symbol=Symbol(name="PyObject_Vectorcall"),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyObject_VectorcallMethod"): Function(
        symbol=Symbol(name="PyObject_VectorcallMethod"),
        added=PyVersion(major=3, minor=12),
        ifdef=None,
        abi_only=False,
    ),
}
_MACROS: Final[dict[str, Macro]] = {
    "Py_tp_dealloc": Macro(name="Py_tp_dealloc", added=PyVersion(major=3, minor=2)),
    "Py_tp_getattr": Macro(name="Py_tp_getattr", added=PyVersion(major=3, minor=2)),
    "Py_tp_setattr": Macro(name="Py_tp_setattr", added=PyVersion(major=3, minor=2)),
    "Py_tp_repr": Macro(name="Py_tp_repr", added=PyVersion(major=3, minor=2)),
    "Py_tp_hash": Macro(name="Py_tp_hash", added=PyVersion(major=3, minor=2)),
    "Py_tp_call": Macro(name="Py_tp_call", added=PyVersion(major=3, minor=2)),
    "Py_tp_str": Macro(name="Py_tp_str", added=PyVersion(major=3, minor=2)),
    "Py_tp_getattro": Macro(name="Py_tp_getattro", added=PyVersion(major=3, minor=2)),
    "Py_tp_setattro": Macro(name="Py_tp_setattro", added=PyVersion(major=3, minor=2)),
    "Py_tp_doc": Macro(name="Py_tp_doc", added=PyVersion(major=3, minor=2)),
    "Py_tp_traverse": Macro(name="Py_tp_traverse", added=PyVersion(major=3, minor=2)),
    "Py_tp_clear": Macro(name="Py_tp_clear", added=PyVersion(major=3, minor=2)),
    "Py_tp_richcompare": Macro(name="Py_tp_richcompare", added=PyVersion(major=3, minor=2)),
    "Py_tp_iter": Macro(name="Py_tp_iter", added=PyVersion(major=3, minor=2)),
    "Py_tp_iternext": Macro(name="Py_tp_iternext", added=PyVersion(major=3, minor=2)),
    "Py_tp_methods": Macro(name="Py_tp_methods", added=PyVersion(major=3, minor=2)),
    "Py_tp_base": Macro(name="Py_tp_base", added=PyVersion(major=3, minor=2)),
    "Py_tp_descr_get": Macro(name="Py_tp_descr_get", added=PyVersion(major=3, minor=2)),
    "Py_tp_descr_set": Macro(name="Py_tp_descr_set", added=PyVersion(major=3, minor=2)),
    "Py_tp_init": Macro(name="Py_tp_init", added=PyVersion(major=3, minor=2)),
    "Py_tp_alloc": Macro(name="Py_tp_alloc", added=PyVersion(major=3, minor=2)),
    "Py_tp_new": Macro(name="Py_tp_new", added=PyVersion(major=3, minor=2)),
    "Py_tp_members": Macro(name="Py_tp_members", added=PyVersion(major=3, minor=2)),
    "Py_tp_getset": Macro(name="Py_tp_getset", added=PyVersion(major=3, minor=2)),
    "Py_tp_free": Macro(name="Py_tp_free", added=PyVersion(major=3, minor=2)),
    "Py_tp_is_gc": Macro(name="Py_tp_is_gc", added=PyVersion(major=3, minor=2)),
    "Py_tp_bases": Macro(name="Py_tp_bases", added=PyVersion(major=3, minor=2)),
    "Py_tp_del": Macro(name="Py_tp_del", added=PyVersion(major=3, minor=2)),
    "Py_nb_add": Macro(name="Py_nb_add", added=PyVersion(major=3, minor=2)),
    "Py_nb_subtract": Macro(name="Py_nb_subtract", added=PyVersion(major=3, minor=2)),
    "Py_nb_multiply": Macro(name="Py_nb_multiply", added=PyVersion(major=3, minor=2)),
    "Py_nb_remainder": Macro(name="Py_nb_remainder", added=PyVersion(major=3, minor=2)),
    "Py_nb_divmod": Macro(name="Py_nb_divmod", added=PyVersion(major=3, minor=2)),
    "Py_nb_power": Macro(name="Py_nb_power", added=PyVersion(major=3, minor=2)),
    "Py_nb_negative": Macro(name="Py_nb_negative", added=PyVersion(major=3, minor=2)),
    "Py_nb_positive": Macro(name="Py_nb_positive", added=PyVersion(major=3, minor=2)),
    "Py_nb_absolute": Macro(name="Py_nb_absolute", added=PyVersion(major=3, minor=2)),
    "Py_nb_bool": Macro(name="Py_nb_bool", added=PyVersion(major=3, minor=2)),
    "Py_nb_invert": Macro(name="Py_nb_invert", added=PyVersion(major=3, minor=2)),
    "Py_nb_lshift": Macro(name="Py_nb_lshift", added=PyVersion(major=3, minor=2)),
    "Py_nb_rshift": Macro(name="Py_nb_rshift", added=PyVersion(major=3, minor=2)),
    "Py_nb_and": Macro(name="Py_nb_and", added=PyVersion(major=3, minor=2)),
    "Py_nb_xor": Macro(name="Py_nb_xor", added=PyVersion(major=3, minor=2)),
    "Py_nb_or": Macro(name="Py_nb_or", added=PyVersion(major=3, minor=2)),
    "Py_nb_int": Macro(name="Py_nb_int", added=PyVersion(major=3, minor=2)),
    "Py_nb_float": Macro(name="Py_nb_float", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_add": Macro(name="Py_nb_inplace_add", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_subtract": Macro(
        name="Py_nb_inplace_subtract", added=PyVersion(major=3, minor=2)
    ),
    "Py_nb_inplace_multiply": Macro(
        name="Py_nb_inplace_multiply", added=PyVersion(major=3, minor=2)
    ),
    "Py_nb_inplace_remainder": Macro(
        name="Py_nb_inplace_remainder", added=PyVersion(major=3, minor=2)
    ),
    "Py_nb_inplace_power": Macro(name="Py_nb_inplace_power", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_lshift": Macro(name="Py_nb_inplace_lshift", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_rshift": Macro(name="Py_nb_inplace_rshift", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_and": Macro(name="Py_nb_inplace_and", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_xor": Macro(name="Py_nb_inplace_xor", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_or": Macro(name="Py_nb_inplace_or", added=PyVersion(major=3, minor=2)),
    "Py_nb_floor_divide": Macro(name="Py_nb_floor_divide", added=PyVersion(major=3, minor=2)),
    "Py_nb_true_divide": Macro(name="Py_nb_true_divide", added=PyVersion(major=3, minor=2)),
    "Py_nb_inplace_floor_divide": Macro(
        name="Py_nb_inplace_floor_divide", added=PyVersion(major=3, minor=2)
    ),
    "Py_nb_inplace_true_divide": Macro(
        name="Py_nb_inplace_true_divide", added=PyVersion(major=3, minor=2)
    ),
    "Py_nb_index": Macro(name="Py_nb_index", added=PyVersion(major=3, minor=2)),
    "Py_sq_length": Macro(name="Py_sq_length", added=PyVersion(major=3, minor=2)),
    "Py_sq_concat": Macro(name="Py_sq_concat", added=PyVersion(major=3, minor=2)),
    "Py_sq_repeat": Macro(name="Py_sq_repeat", added=PyVersion(major=3, minor=2)),
    "Py_sq_item": Macro(name="Py_sq_item", added=PyVersion(major=3, minor=2)),
    "Py_sq_ass_item": Macro(name="Py_sq_ass_item", added=PyVersion(major=3, minor=2)),
    "Py_sq_contains": Macro(name="Py_sq_contains", added=PyVersion(major=3, minor=2)),
    "Py_sq_inplace_concat": Macro(name="Py_sq_inplace_concat", added=PyVersion(major=3, minor=2)),
    "Py_sq_inplace_repeat": Macro(name="Py_sq_inplace_repeat", added=PyVersion(major=3, minor=2)),
    "Py_mp_length": Macro(name="Py_mp_length", added=PyVersion(major=3, minor=2)),
    "Py_mp_subscript": Macro(name="Py_mp_subscript", added=PyVersion(major=3, minor=2)),
    "Py_mp_ass_subscript": Macro(name="Py_mp_ass_subscript", added=PyVersion(major=3, minor=2)),
    "Py_TPFLAGS_DEFAULT": Macro(name="Py_TPFLAGS_DEFAULT", added=PyVersion(major=3, minor=2)),
    "Py_TPFLAGS_BASETYPE": Macro(name="Py_TPFLAGS_BASETYPE", added=PyVersion(major=3, minor=2)),
    "Py_TPFLAGS_HAVE_GC": Macro(name="Py_TPFLAGS_HAVE_GC", added=PyVersion(major=3, minor=2)),
    "METH_VARARGS": Macro(name="METH_VARARGS", added=PyVersion(major=3, minor=2)),
    "METH_NOARGS": Macro(name="METH_NOARGS", added=PyVersion(major=3, minor=2)),
    "METH_O": Macro(name="METH_O", added=PyVersion(major=3, minor=2)),
    "METH_CLASS": Macro(name="METH_CLASS", added=PyVersion(major=3, minor=2)),
    "METH_STATIC": Macro(name="METH_STATIC", added=PyVersion(major=3, minor=2)),
    "METH_COEXIST": Macro(name="METH_COEXIST", added=PyVersion(major=3, minor=2)),
    "Py_nb_matrix_multiply": Macro(name="Py_nb_matrix_multiply", added=PyVersion(major=3, minor=5)),
    "Py_nb_inplace_matrix_multiply": Macro(
        name="Py_nb_inplace_matrix_multiply", added=PyVersion(major=3, minor=5)
    ),
    "Py_am_await": Macro(name="Py_am_await", added=PyVersion(major=3, minor=5)),
    "Py_am_aiter": Macro(name="Py_am_aiter", added=PyVersion(major=3, minor=5)),
    "Py_am_anext": Macro(name="Py_am_anext", added=PyVersion(major=3, minor=5)),
    "Py_tp_finalize": Macro(name="Py_tp_finalize", added=PyVersion(major=3, minor=5)),
    "METH_FASTCALL": Macro(name="METH_FASTCALL", added=PyVersion(major=3, minor=7)),
    "METH_METHOD": Macro(name="METH_METHOD", added=PyVersion(major=3, minor=7)),
    "Py_TPFLAGS_METHOD_DESCRIPTOR": Macro(
        name="Py_TPFLAGS_METHOD_DESCRIPTOR", added=PyVersion(major=3, minor=8)
    ),
    "Py_am_send": Macro(name="Py_am_send", added=PyVersion(major=3, minor=10)),
    "PyBUF_MAX_NDIM": Macro(name="PyBUF_MAX_NDIM", added=PyVersion(major=3, minor=11)),
    "PyBUF_SIMPLE": Macro(name="PyBUF_SIMPLE", added=PyVersion(major=3, minor=11)),
    "PyBUF_WRITABLE": Macro(name="PyBUF_WRITABLE", added=PyVersion(major=3, minor=11)),
    "PyBUF_FORMAT": Macro(name="PyBUF_FORMAT", added=PyVersion(major=3, minor=11)),
    "PyBUF_ND": Macro(name="PyBUF_ND", added=PyVersion(major=3, minor=11)),
    "PyBUF_STRIDES": Macro(name="PyBUF_STRIDES", added=PyVersion(major=3, minor=11)),
    "PyBUF_C_CONTIGUOUS": Macro(name="PyBUF_C_CONTIGUOUS", added=PyVersion(major=3, minor=11)),
    "PyBUF_F_CONTIGUOUS": Macro(name="PyBUF_F_CONTIGUOUS", added=PyVersion(major=3, minor=11)),
    "PyBUF_ANY_CONTIGUOUS": Macro(name="PyBUF_ANY_CONTIGUOUS", added=PyVersion(major=3, minor=11)),
    "PyBUF_INDIRECT": Macro(name="PyBUF_INDIRECT", added=PyVersion(major=3, minor=11)),
    "PyBUF_CONTIG": Macro(name="PyBUF_CONTIG", added=PyVersion(major=3, minor=11)),
    "PyBUF_CONTIG_RO": Macro(name="PyBUF_CONTIG_RO", added=PyVersion(major=3, minor=11)),
    "PyBUF_STRIDED": Macro(name="PyBUF_STRIDED", added=PyVersion(major=3, minor=11)),
    "PyBUF_STRIDED_RO": Macro(name="PyBUF_STRIDED_RO", added=PyVersion(major=3, minor=11)),
    "PyBUF_RECORDS": Macro(name="PyBUF_RECORDS", added=PyVersion(major=3, minor=11)),
    "PyBUF_RECORDS_RO": Macro(name="PyBUF_RECORDS_RO", added=PyVersion(major=3, minor=11)),
    "PyBUF_FULL": Macro(name="PyBUF_FULL", added=PyVersion(major=3, minor=11)),
    "PyBUF_FULL_RO": Macro(name="PyBUF_FULL_RO", added=PyVersion(major=3, minor=11)),
    "PyBUF_READ": Macro(name="PyBUF_READ", added=PyVersion(major=3, minor=11)),
    "PyBUF_WRITE": Macro(name="PyBUF_WRITE", added=PyVersion(major=3, minor=11)),
    "Py_TPFLAGS_HAVE_VECTORCALL": Macro(
        name="Py_TPFLAGS_HAVE_VECTORCALL", added=PyVersion(major=3, minor=12)
    ),
    "Py_T_BYTE": Macro(name="Py_T_BYTE", added=PyVersion(major=3, minor=12)),
    "Py_T_SHORT": Macro(name="Py_T_SHORT", added=PyVersion(major=3, minor=12)),
    "Py_T_INT": Macro(name="Py_T_INT", added=PyVersion(major=3, minor=12)),
    "Py_T_LONG": Macro(name="Py_T_LONG", added=PyVersion(major=3, minor=12)),
    "Py_T_LONGLONG": Macro(name="Py_T_LONGLONG", added=PyVersion(major=3, minor=12)),
    "Py_T_UBYTE": Macro(name="Py_T_UBYTE", added=PyVersion(major=3, minor=12)),
    "Py_T_UINT": Macro(name="Py_T_UINT", added=PyVersion(major=3, minor=12)),
    "Py_T_USHORT": Macro(name="Py_T_USHORT", added=PyVersion(major=3, minor=12)),
    "Py_T_ULONG": Macro(name="Py_T_ULONG", added=PyVersion(major=3, minor=12)),
    "Py_T_ULONGLONG": Macro(name="Py_T_ULONGLONG", added=PyVersion(major=3, minor=12)),
    "Py_T_PYSSIZET": Macro(name="Py_T_PYSSIZET", added=PyVersion(major=3, minor=12)),
    "Py_T_FLOAT": Macro(name="Py_T_FLOAT", added=PyVersion(major=3, minor=12)),
    "Py_T_DOUBLE": Macro(name="Py_T_DOUBLE", added=PyVersion(major=3, minor=12)),
    "Py_T_BOOL": Macro(name="Py_T_BOOL", added=PyVersion(major=3, minor=12)),
    "Py_T_STRING": Macro(name="Py_T_STRING", added=PyVersion(major=3, minor=12)),
    "Py_T_STRING_INPLACE": Macro(name="Py_T_STRING_INPLACE", added=PyVersion(major=3, minor=12)),
    "Py_T_CHAR": Macro(name="Py_T_CHAR", added=PyVersion(major=3, minor=12)),
    "Py_T_OBJECT_EX": Macro(name="Py_T_OBJECT_EX", added=PyVersion(major=3, minor=12)),
    "Py_READONLY": Macro(name="Py_READONLY", added=PyVersion(major=3, minor=12)),
    "Py_AUDIT_READ": Macro(name="Py_AUDIT_READ", added=PyVersion(major=3, minor=12)),
    "Py_BEGIN_ALLOW_THREADS": Macro(
        name="Py_BEGIN_ALLOW_THREADS", added=PyVersion(major=3, minor=2)
    ),
    "Py_BLOCK_THREADS": Macro(name="Py_BLOCK_THREADS", added=PyVersion(major=3, minor=2)),
    "Py_UNBLOCK_THREADS": Macro(name="Py_UNBLOCK_THREADS", added=PyVersion(major=3, minor=2)),
    "Py_END_ALLOW_THREADS": Macro(name="Py_END_ALLOW_THREADS", added=PyVersion(major=3, minor=2)),
    "PY_VECTORCALL_ARGUMENTS_OFFSET": Macro(
        name="PY_VECTORCALL_ARGUMENTS_OFFSET", added=PyVersion(major=3, minor=12)
    ),
}
_DATAS: Final[dict[Symbol, Data]] = {
    Symbol(name="PyBaseObject_Type"): Data(
        symbol=Symbol(name="PyBaseObject_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBool_Type"): Data(
        symbol=Symbol(name="PyBool_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArrayIter_Type"): Data(
        symbol=Symbol(name="PyByteArrayIter_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyByteArray_Type"): Data(
        symbol=Symbol(name="PyByteArray_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytesIter_Type"): Data(
        symbol=Symbol(name="PyBytesIter_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyBytes_Type"): Data(
        symbol=Symbol(name="PyBytes_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCFunction_Type"): Data(
        symbol=Symbol(name="PyCFunction_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCallIter_Type"): Data(
        symbol=Symbol(name="PyCallIter_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyCapsule_Type"): Data(
        symbol=Symbol(name="PyCapsule_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyClassMethodDescr_Type"): Data(
        symbol=Symbol(name="PyClassMethodDescr_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyComplex_Type"): Data(
        symbol=Symbol(name="PyComplex_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictItems_Type"): Data(
        symbol=Symbol(name="PyDictItems_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictIterItem_Type"): Data(
        symbol=Symbol(name="PyDictIterItem_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictIterKey_Type"): Data(
        symbol=Symbol(name="PyDictIterKey_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictIterValue_Type"): Data(
        symbol=Symbol(name="PyDictIterValue_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictKeys_Type"): Data(
        symbol=Symbol(name="PyDictKeys_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictProxy_Type"): Data(
        symbol=Symbol(name="PyDictProxy_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictValues_Type"): Data(
        symbol=Symbol(name="PyDictValues_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDict_Type"): Data(
        symbol=Symbol(name="PyDict_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEllipsis_Type"): Data(
        symbol=Symbol(name="PyEllipsis_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyEnum_Type"): Data(
        symbol=Symbol(name="PyEnum_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ArithmeticError"): Data(
        symbol=Symbol(name="PyExc_ArithmeticError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_AssertionError"): Data(
        symbol=Symbol(name="PyExc_AssertionError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_AttributeError"): Data(
        symbol=Symbol(name="PyExc_AttributeError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_BaseException"): Data(
        symbol=Symbol(name="PyExc_BaseException"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_BaseExceptionGroup"): Data(
        symbol=Symbol(name="PyExc_BaseExceptionGroup"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_BufferError"): Data(
        symbol=Symbol(name="PyExc_BufferError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_BytesWarning"): Data(
        symbol=Symbol(name="PyExc_BytesWarning"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_DeprecationWarning"): Data(
        symbol=Symbol(name="PyExc_DeprecationWarning"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_EOFError"): Data(
        symbol=Symbol(name="PyExc_EOFError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_EnvironmentError"): Data(
        symbol=Symbol(name="PyExc_EnvironmentError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_Exception"): Data(
        symbol=Symbol(name="PyExc_Exception"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_FloatingPointError"): Data(
        symbol=Symbol(name="PyExc_FloatingPointError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_FutureWarning"): Data(
        symbol=Symbol(name="PyExc_FutureWarning"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_GeneratorExit"): Data(
        symbol=Symbol(name="PyExc_GeneratorExit"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_IOError"): Data(
        symbol=Symbol(name="PyExc_IOError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ImportError"): Data(
        symbol=Symbol(name="PyExc_ImportError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ImportWarning"): Data(
        symbol=Symbol(name="PyExc_ImportWarning"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_IndentationError"): Data(
        symbol=Symbol(name="PyExc_IndentationError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_IndexError"): Data(
        symbol=Symbol(name="PyExc_IndexError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_KeyError"): Data(
        symbol=Symbol(name="PyExc_KeyError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_KeyboardInterrupt"): Data(
        symbol=Symbol(name="PyExc_KeyboardInterrupt"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_LookupError"): Data(
        symbol=Symbol(name="PyExc_LookupError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_MemoryError"): Data(
        symbol=Symbol(name="PyExc_MemoryError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_NameError"): Data(
        symbol=Symbol(name="PyExc_NameError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_NotImplementedError"): Data(
        symbol=Symbol(name="PyExc_NotImplementedError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_OSError"): Data(
        symbol=Symbol(name="PyExc_OSError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_OverflowError"): Data(
        symbol=Symbol(name="PyExc_OverflowError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_PendingDeprecationWarning"): Data(
        symbol=Symbol(name="PyExc_PendingDeprecationWarning"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ReferenceError"): Data(
        symbol=Symbol(name="PyExc_ReferenceError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_RuntimeError"): Data(
        symbol=Symbol(name="PyExc_RuntimeError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_RuntimeWarning"): Data(
        symbol=Symbol(name="PyExc_RuntimeWarning"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_StopIteration"): Data(
        symbol=Symbol(name="PyExc_StopIteration"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_SyntaxError"): Data(
        symbol=Symbol(name="PyExc_SyntaxError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_SyntaxWarning"): Data(
        symbol=Symbol(name="PyExc_SyntaxWarning"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_SystemError"): Data(
        symbol=Symbol(name="PyExc_SystemError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_SystemExit"): Data(
        symbol=Symbol(name="PyExc_SystemExit"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_TabError"): Data(
        symbol=Symbol(name="PyExc_TabError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_TypeError"): Data(
        symbol=Symbol(name="PyExc_TypeError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UnboundLocalError"): Data(
        symbol=Symbol(name="PyExc_UnboundLocalError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UnicodeDecodeError"): Data(
        symbol=Symbol(name="PyExc_UnicodeDecodeError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UnicodeEncodeError"): Data(
        symbol=Symbol(name="PyExc_UnicodeEncodeError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UnicodeError"): Data(
        symbol=Symbol(name="PyExc_UnicodeError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UnicodeTranslateError"): Data(
        symbol=Symbol(name="PyExc_UnicodeTranslateError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UnicodeWarning"): Data(
        symbol=Symbol(name="PyExc_UnicodeWarning"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_UserWarning"): Data(
        symbol=Symbol(name="PyExc_UserWarning"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ValueError"): Data(
        symbol=Symbol(name="PyExc_ValueError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_Warning"): Data(
        symbol=Symbol(name="PyExc_Warning"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ZeroDivisionError"): Data(
        symbol=Symbol(name="PyExc_ZeroDivisionError"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFilter_Type"): Data(
        symbol=Symbol(name="PyFilter_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFloat_Type"): Data(
        symbol=Symbol(name="PyFloat_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyFrozenSet_Type"): Data(
        symbol=Symbol(name="PyFrozenSet_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyGetSetDescr_Type"): Data(
        symbol=Symbol(name="PyGetSetDescr_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyListIter_Type"): Data(
        symbol=Symbol(name="PyListIter_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyListRevIter_Type"): Data(
        symbol=Symbol(name="PyListRevIter_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyList_Type"): Data(
        symbol=Symbol(name="PyList_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLongRangeIter_Type"): Data(
        symbol=Symbol(name="PyLongRangeIter_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyLong_Type"): Data(
        symbol=Symbol(name="PyLong_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMap_Type"): Data(
        symbol=Symbol(name="PyMap_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMemberDescr_Type"): Data(
        symbol=Symbol(name="PyMemberDescr_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMemoryView_Type"): Data(
        symbol=Symbol(name="PyMemoryView_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyMethodDescr_Type"): Data(
        symbol=Symbol(name="PyMethodDescr_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyModule_Type"): Data(
        symbol=Symbol(name="PyModule_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyOS_InputHook"): Data(
        symbol=Symbol(name="PyOS_InputHook"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyProperty_Type"): Data(
        symbol=Symbol(name="PyProperty_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyRangeIter_Type"): Data(
        symbol=Symbol(name="PyRangeIter_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyRange_Type"): Data(
        symbol=Symbol(name="PyRange_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyReversed_Type"): Data(
        symbol=Symbol(name="PyReversed_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySeqIter_Type"): Data(
        symbol=Symbol(name="PySeqIter_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySetIter_Type"): Data(
        symbol=Symbol(name="PySetIter_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySet_Type"): Data(
        symbol=Symbol(name="PySet_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySlice_Type"): Data(
        symbol=Symbol(name="PySlice_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PySuper_Type"): Data(
        symbol=Symbol(name="PySuper_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTraceBack_Type"): Data(
        symbol=Symbol(name="PyTraceBack_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTupleIter_Type"): Data(
        symbol=Symbol(name="PyTupleIter_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyTuple_Type"): Data(
        symbol=Symbol(name="PyTuple_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyType_Type"): Data(
        symbol=Symbol(name="PyType_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicodeIter_Type"): Data(
        symbol=Symbol(name="PyUnicodeIter_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyUnicode_Type"): Data(
        symbol=Symbol(name="PyUnicode_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyWrapperDescr_Type"): Data(
        symbol=Symbol(name="PyWrapperDescr_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyZip_Type"): Data(
        symbol=Symbol(name="PyZip_Type"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_FileSystemDefaultEncoding"): Data(
        symbol=Symbol(name="Py_FileSystemDefaultEncoding"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_HasFileSystemDefaultEncoding"): Data(
        symbol=Symbol(name="Py_HasFileSystemDefaultEncoding"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="_PyWeakref_CallableProxyType"): Data(
        symbol=Symbol(name="_PyWeakref_CallableProxyType"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyWeakref_ProxyType"): Data(
        symbol=Symbol(name="_PyWeakref_ProxyType"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_PyWeakref_RefType"): Data(
        symbol=Symbol(name="_PyWeakref_RefType"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_EllipsisObject"): Data(
        symbol=Symbol(name="_Py_EllipsisObject"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_FalseStruct"): Data(
        symbol=Symbol(name="_Py_FalseStruct"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_NoneStruct"): Data(
        symbol=Symbol(name="_Py_NoneStruct"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_NotImplementedStruct"): Data(
        symbol=Symbol(name="_Py_NotImplementedStruct"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_SwappedOp"): Data(
        symbol=Symbol(name="_Py_SwappedOp"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="_Py_TrueStruct"): Data(
        symbol=Symbol(name="_Py_TrueStruct"),
        added=PyVersion(major=3, minor=2),
        ifdef=None,
        abi_only=True,
    ),
    Symbol(name="PyModuleDef_Type"): Data(
        symbol=Symbol(name="PyModuleDef_Type"),
        added=PyVersion(major=3, minor=5),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ModuleNotFoundError"): Data(
        symbol=Symbol(name="PyExc_ModuleNotFoundError"),
        added=PyVersion(major=3, minor=6),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_BlockingIOError"): Data(
        symbol=Symbol(name="PyExc_BlockingIOError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_BrokenPipeError"): Data(
        symbol=Symbol(name="PyExc_BrokenPipeError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ChildProcessError"): Data(
        symbol=Symbol(name="PyExc_ChildProcessError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ConnectionAbortedError"): Data(
        symbol=Symbol(name="PyExc_ConnectionAbortedError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ConnectionError"): Data(
        symbol=Symbol(name="PyExc_ConnectionError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ConnectionRefusedError"): Data(
        symbol=Symbol(name="PyExc_ConnectionRefusedError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ConnectionResetError"): Data(
        symbol=Symbol(name="PyExc_ConnectionResetError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_FileExistsError"): Data(
        symbol=Symbol(name="PyExc_FileExistsError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_FileNotFoundError"): Data(
        symbol=Symbol(name="PyExc_FileNotFoundError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_InterruptedError"): Data(
        symbol=Symbol(name="PyExc_InterruptedError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_IsADirectoryError"): Data(
        symbol=Symbol(name="PyExc_IsADirectoryError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_NotADirectoryError"): Data(
        symbol=Symbol(name="PyExc_NotADirectoryError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_PermissionError"): Data(
        symbol=Symbol(name="PyExc_PermissionError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ProcessLookupError"): Data(
        symbol=Symbol(name="PyExc_ProcessLookupError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_RecursionError"): Data(
        symbol=Symbol(name="PyExc_RecursionError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_ResourceWarning"): Data(
        symbol=Symbol(name="PyExc_ResourceWarning"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_StopAsyncIteration"): Data(
        symbol=Symbol(name="PyExc_StopAsyncIteration"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_TimeoutError"): Data(
        symbol=Symbol(name="PyExc_TimeoutError"),
        added=PyVersion(major=3, minor=7),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_WindowsError"): Data(
        symbol=Symbol(name="PyExc_WindowsError"),
        added=PyVersion(major=3, minor=7),
        ifdef=FeatureMacro(name="MS_WINDOWS", doc="on Windows", windows=True),
        abi_only=False,
    ),
    Symbol(name="Py_UTF8Mode"): Data(
        symbol=Symbol(name="Py_UTF8Mode"),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictRevIterItem_Type"): Data(
        symbol=Symbol(name="PyDictRevIterItem_Type"),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictRevIterKey_Type"): Data(
        symbol=Symbol(name="PyDictRevIterKey_Type"),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyDictRevIterValue_Type"): Data(
        symbol=Symbol(name="PyDictRevIterValue_Type"),
        added=PyVersion(major=3, minor=8),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_GenericAliasType"): Data(
        symbol=Symbol(name="Py_GenericAliasType"),
        added=PyVersion(major=3, minor=9),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_FileSystemDefaultEncodeErrors"): Data(
        symbol=Symbol(name="Py_FileSystemDefaultEncodeErrors"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="PyExc_EncodingWarning"): Data(
        symbol=Symbol(name="PyExc_EncodingWarning"),
        added=PyVersion(major=3, minor=10),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="_Py_RefTotal"): Data(
        symbol=Symbol(name="_Py_RefTotal"),
        added=PyVersion(major=3, minor=10),
        ifdef=FeatureMacro(
            name="Py_REF_DEBUG",
            doc="when Python is compiled in debug mode (with Py_REF_DEBUG)",
            windows="maybe",
        ),
        abi_only=True,
    ),
    Symbol(name="PyStructSequence_UnnamedField"): Data(
        symbol=Symbol(name="PyStructSequence_UnnamedField"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
    Symbol(name="Py_Version"): Data(
        symbol=Symbol(name="Py_Version"),
        added=PyVersion(major=3, minor=11),
        ifdef=None,
        abi_only=False,
    ),
}
_TYPEDEFS: Final[dict[str, Typedef]] = {
    "Py_uintptr_t": Typedef(name="Py_uintptr_t", added=PyVersion(major=3, minor=2)),
    "Py_intptr_t": Typedef(name="Py_intptr_t", added=PyVersion(major=3, minor=2)),
    "Py_ssize_t": Typedef(name="Py_ssize_t", added=PyVersion(major=3, minor=2)),
    "unaryfunc": Typedef(name="unaryfunc", added=PyVersion(major=3, minor=2)),
    "binaryfunc": Typedef(name="binaryfunc", added=PyVersion(major=3, minor=2)),
    "ternaryfunc": Typedef(name="ternaryfunc", added=PyVersion(major=3, minor=2)),
    "inquiry": Typedef(name="inquiry", added=PyVersion(major=3, minor=2)),
    "lenfunc": Typedef(name="lenfunc", added=PyVersion(major=3, minor=2)),
    "ssizeargfunc": Typedef(name="ssizeargfunc", added=PyVersion(major=3, minor=2)),
    "ssizessizeargfunc": Typedef(name="ssizessizeargfunc", added=PyVersion(major=3, minor=2)),
    "ssizeobjargproc": Typedef(name="ssizeobjargproc", added=PyVersion(major=3, minor=2)),
    "ssizessizeobjargproc": Typedef(name="ssizessizeobjargproc", added=PyVersion(major=3, minor=2)),
    "objobjargproc": Typedef(name="objobjargproc", added=PyVersion(major=3, minor=2)),
    "objobjproc": Typedef(name="objobjproc", added=PyVersion(major=3, minor=2)),
    "visitproc": Typedef(name="visitproc", added=PyVersion(major=3, minor=2)),
    "traverseproc": Typedef(name="traverseproc", added=PyVersion(major=3, minor=2)),
    "destructor": Typedef(name="destructor", added=PyVersion(major=3, minor=2)),
    "getattrfunc": Typedef(name="getattrfunc", added=PyVersion(major=3, minor=2)),
    "getattrofunc": Typedef(name="getattrofunc", added=PyVersion(major=3, minor=2)),
    "setattrfunc": Typedef(name="setattrfunc", added=PyVersion(major=3, minor=2)),
    "setattrofunc": Typedef(name="setattrofunc", added=PyVersion(major=3, minor=2)),
    "reprfunc": Typedef(name="reprfunc", added=PyVersion(major=3, minor=2)),
    "hashfunc": Typedef(name="hashfunc", added=PyVersion(major=3, minor=2)),
    "richcmpfunc": Typedef(name="richcmpfunc", added=PyVersion(major=3, minor=2)),
    "getiterfunc": Typedef(name="getiterfunc", added=PyVersion(major=3, minor=2)),
    "iternextfunc": Typedef(name="iternextfunc", added=PyVersion(major=3, minor=2)),
    "descrgetfunc": Typedef(name="descrgetfunc", added=PyVersion(major=3, minor=2)),
    "descrsetfunc": Typedef(name="descrsetfunc", added=PyVersion(major=3, minor=2)),
    "initproc": Typedef(name="initproc", added=PyVersion(major=3, minor=2)),
    "newfunc": Typedef(name="newfunc", added=PyVersion(major=3, minor=2)),
    "allocfunc": Typedef(name="allocfunc", added=PyVersion(major=3, minor=2)),
    "PyCFunction": Typedef(name="PyCFunction", added=PyVersion(major=3, minor=2)),
    "PyCFunctionWithKeywords": Typedef(
        name="PyCFunctionWithKeywords", added=PyVersion(major=3, minor=2)
    ),
    "PyCapsule_Destructor": Typedef(name="PyCapsule_Destructor", added=PyVersion(major=3, minor=2)),
    "getter": Typedef(name="getter", added=PyVersion(major=3, minor=2)),
    "setter": Typedef(name="setter", added=PyVersion(major=3, minor=2)),
    "PyOS_sighandler_t": Typedef(name="PyOS_sighandler_t", added=PyVersion(major=3, minor=2)),
    "PyGILState_STATE": Typedef(name="PyGILState_STATE", added=PyVersion(major=3, minor=2)),
    "Py_UCS4": Typedef(name="Py_UCS4", added=PyVersion(major=3, minor=2)),
    "vectorcallfunc": Typedef(name="vectorcallfunc", added=PyVersion(major=3, minor=12)),
    "getbufferproc": Typedef(name="getbufferproc", added=PyVersion(major=3, minor=12)),
    "releasebufferproc": Typedef(name="releasebufferproc", added=PyVersion(major=3, minor=12)),
}
