import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeWarehousesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/warehouses#id DataSnowflakeWarehouses#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataSnowflakeWarehousesWarehouses {
}
export declare function dataSnowflakeWarehousesWarehousesToTerraform(struct?: DataSnowflakeWarehousesWarehouses): any;
export declare class DataSnowflakeWarehousesWarehousesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeWarehousesWarehouses | undefined;
    set internalValue(value: DataSnowflakeWarehousesWarehouses | undefined);
    get comment(): string;
    get name(): string;
    get scalingPolicy(): string;
    get size(): string;
    get state(): string;
    get type(): string;
}
export declare class DataSnowflakeWarehousesWarehousesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeWarehousesWarehousesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/warehouses snowflake_warehouses}
*/
export declare class DataSnowflakeWarehouses extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_warehouses";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/warehouses snowflake_warehouses} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeWarehousesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeWarehousesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _warehouses;
    get warehouses(): DataSnowflakeWarehousesWarehousesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-snowflake-warehouses.d.ts.map