"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileFormat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/file_format snowflake_file_format}
*/
class FileFormat extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/file_format snowflake_file_format} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FileFormatConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_file_format',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.33.1',
                providerVersionConstraint: ' ~> 0.25'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._allowDuplicate = config.allowDuplicate;
        this._binaryAsText = config.binaryAsText;
        this._binaryFormat = config.binaryFormat;
        this._comment = config.comment;
        this._compression = config.compression;
        this._database = config.database;
        this._dateFormat = config.dateFormat;
        this._disableAutoConvert = config.disableAutoConvert;
        this._disableSnowflakeData = config.disableSnowflakeData;
        this._emptyFieldAsNull = config.emptyFieldAsNull;
        this._enableOctal = config.enableOctal;
        this._encoding = config.encoding;
        this._errorOnColumnCountMismatch = config.errorOnColumnCountMismatch;
        this._escape = config.escape;
        this._escapeUnenclosedField = config.escapeUnenclosedField;
        this._fieldDelimiter = config.fieldDelimiter;
        this._fieldOptionallyEnclosedBy = config.fieldOptionallyEnclosedBy;
        this._fileExtension = config.fileExtension;
        this._formatType = config.formatType;
        this._id = config.id;
        this._ignoreUtf8Errors = config.ignoreUtf8Errors;
        this._name = config.name;
        this._nullIf = config.nullIf;
        this._preserveSpace = config.preserveSpace;
        this._recordDelimiter = config.recordDelimiter;
        this._replaceInvalidCharacters = config.replaceInvalidCharacters;
        this._schema = config.schema;
        this._skipBlankLines = config.skipBlankLines;
        this._skipByteOrderMark = config.skipByteOrderMark;
        this._skipHeader = config.skipHeader;
        this._stripNullValues = config.stripNullValues;
        this._stripOuterArray = config.stripOuterArray;
        this._stripOuterElement = config.stripOuterElement;
        this._timeFormat = config.timeFormat;
        this._timestampFormat = config.timestampFormat;
        this._trimSpace = config.trimSpace;
        this._validateUtf8 = config.validateUtf8;
    }
    get allowDuplicate() {
        return this.getBooleanAttribute('allow_duplicate');
    }
    set allowDuplicate(value) {
        this._allowDuplicate = value;
    }
    resetAllowDuplicate() {
        this._allowDuplicate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowDuplicateInput() {
        return this._allowDuplicate;
    }
    get binaryAsText() {
        return this.getBooleanAttribute('binary_as_text');
    }
    set binaryAsText(value) {
        this._binaryAsText = value;
    }
    resetBinaryAsText() {
        this._binaryAsText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryAsTextInput() {
        return this._binaryAsText;
    }
    get binaryFormat() {
        return this.getStringAttribute('binary_format');
    }
    set binaryFormat(value) {
        this._binaryFormat = value;
    }
    resetBinaryFormat() {
        this._binaryFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryFormatInput() {
        return this._binaryFormat;
    }
    get comment() {
        return this.getStringAttribute('comment');
    }
    set comment(value) {
        this._comment = value;
    }
    resetComment() {
        this._comment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commentInput() {
        return this._comment;
    }
    get compression() {
        return this.getStringAttribute('compression');
    }
    set compression(value) {
        this._compression = value;
    }
    resetCompression() {
        this._compression = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get compressionInput() {
        return this._compression;
    }
    get database() {
        return this.getStringAttribute('database');
    }
    set database(value) {
        this._database = value;
    }
    // Temporarily expose input value. Use with caution.
    get databaseInput() {
        return this._database;
    }
    get dateFormat() {
        return this.getStringAttribute('date_format');
    }
    set dateFormat(value) {
        this._dateFormat = value;
    }
    resetDateFormat() {
        this._dateFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dateFormatInput() {
        return this._dateFormat;
    }
    get disableAutoConvert() {
        return this.getBooleanAttribute('disable_auto_convert');
    }
    set disableAutoConvert(value) {
        this._disableAutoConvert = value;
    }
    resetDisableAutoConvert() {
        this._disableAutoConvert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableAutoConvertInput() {
        return this._disableAutoConvert;
    }
    get disableSnowflakeData() {
        return this.getBooleanAttribute('disable_snowflake_data');
    }
    set disableSnowflakeData(value) {
        this._disableSnowflakeData = value;
    }
    resetDisableSnowflakeData() {
        this._disableSnowflakeData = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableSnowflakeDataInput() {
        return this._disableSnowflakeData;
    }
    get emptyFieldAsNull() {
        return this.getBooleanAttribute('empty_field_as_null');
    }
    set emptyFieldAsNull(value) {
        this._emptyFieldAsNull = value;
    }
    resetEmptyFieldAsNull() {
        this._emptyFieldAsNull = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emptyFieldAsNullInput() {
        return this._emptyFieldAsNull;
    }
    get enableOctal() {
        return this.getBooleanAttribute('enable_octal');
    }
    set enableOctal(value) {
        this._enableOctal = value;
    }
    resetEnableOctal() {
        this._enableOctal = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableOctalInput() {
        return this._enableOctal;
    }
    get encoding() {
        return this.getStringAttribute('encoding');
    }
    set encoding(value) {
        this._encoding = value;
    }
    resetEncoding() {
        this._encoding = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get encodingInput() {
        return this._encoding;
    }
    get errorOnColumnCountMismatch() {
        return this.getBooleanAttribute('error_on_column_count_mismatch');
    }
    set errorOnColumnCountMismatch(value) {
        this._errorOnColumnCountMismatch = value;
    }
    resetErrorOnColumnCountMismatch() {
        this._errorOnColumnCountMismatch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get errorOnColumnCountMismatchInput() {
        return this._errorOnColumnCountMismatch;
    }
    get escape() {
        return this.getStringAttribute('escape');
    }
    set escape(value) {
        this._escape = value;
    }
    resetEscape() {
        this._escape = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get escapeInput() {
        return this._escape;
    }
    get escapeUnenclosedField() {
        return this.getStringAttribute('escape_unenclosed_field');
    }
    set escapeUnenclosedField(value) {
        this._escapeUnenclosedField = value;
    }
    resetEscapeUnenclosedField() {
        this._escapeUnenclosedField = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get escapeUnenclosedFieldInput() {
        return this._escapeUnenclosedField;
    }
    get fieldDelimiter() {
        return this.getStringAttribute('field_delimiter');
    }
    set fieldDelimiter(value) {
        this._fieldDelimiter = value;
    }
    resetFieldDelimiter() {
        this._fieldDelimiter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fieldDelimiterInput() {
        return this._fieldDelimiter;
    }
    get fieldOptionallyEnclosedBy() {
        return this.getStringAttribute('field_optionally_enclosed_by');
    }
    set fieldOptionallyEnclosedBy(value) {
        this._fieldOptionallyEnclosedBy = value;
    }
    resetFieldOptionallyEnclosedBy() {
        this._fieldOptionallyEnclosedBy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fieldOptionallyEnclosedByInput() {
        return this._fieldOptionallyEnclosedBy;
    }
    get fileExtension() {
        return this.getStringAttribute('file_extension');
    }
    set fileExtension(value) {
        this._fileExtension = value;
    }
    resetFileExtension() {
        this._fileExtension = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fileExtensionInput() {
        return this._fileExtension;
    }
    get formatType() {
        return this.getStringAttribute('format_type');
    }
    set formatType(value) {
        this._formatType = value;
    }
    // Temporarily expose input value. Use with caution.
    get formatTypeInput() {
        return this._formatType;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ignoreUtf8Errors() {
        return this.getBooleanAttribute('ignore_utf8_errors');
    }
    set ignoreUtf8Errors(value) {
        this._ignoreUtf8Errors = value;
    }
    resetIgnoreUtf8Errors() {
        this._ignoreUtf8Errors = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreUtf8ErrorsInput() {
        return this._ignoreUtf8Errors;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nullIf() {
        return this.getListAttribute('null_if');
    }
    set nullIf(value) {
        this._nullIf = value;
    }
    resetNullIf() {
        this._nullIf = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nullIfInput() {
        return this._nullIf;
    }
    get preserveSpace() {
        return this.getBooleanAttribute('preserve_space');
    }
    set preserveSpace(value) {
        this._preserveSpace = value;
    }
    resetPreserveSpace() {
        this._preserveSpace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preserveSpaceInput() {
        return this._preserveSpace;
    }
    get recordDelimiter() {
        return this.getStringAttribute('record_delimiter');
    }
    set recordDelimiter(value) {
        this._recordDelimiter = value;
    }
    resetRecordDelimiter() {
        this._recordDelimiter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recordDelimiterInput() {
        return this._recordDelimiter;
    }
    get replaceInvalidCharacters() {
        return this.getBooleanAttribute('replace_invalid_characters');
    }
    set replaceInvalidCharacters(value) {
        this._replaceInvalidCharacters = value;
    }
    resetReplaceInvalidCharacters() {
        this._replaceInvalidCharacters = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replaceInvalidCharactersInput() {
        return this._replaceInvalidCharacters;
    }
    get schema() {
        return this.getStringAttribute('schema');
    }
    set schema(value) {
        this._schema = value;
    }
    // Temporarily expose input value. Use with caution.
    get schemaInput() {
        return this._schema;
    }
    get skipBlankLines() {
        return this.getBooleanAttribute('skip_blank_lines');
    }
    set skipBlankLines(value) {
        this._skipBlankLines = value;
    }
    resetSkipBlankLines() {
        this._skipBlankLines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipBlankLinesInput() {
        return this._skipBlankLines;
    }
    get skipByteOrderMark() {
        return this.getBooleanAttribute('skip_byte_order_mark');
    }
    set skipByteOrderMark(value) {
        this._skipByteOrderMark = value;
    }
    resetSkipByteOrderMark() {
        this._skipByteOrderMark = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipByteOrderMarkInput() {
        return this._skipByteOrderMark;
    }
    get skipHeader() {
        return this.getNumberAttribute('skip_header');
    }
    set skipHeader(value) {
        this._skipHeader = value;
    }
    resetSkipHeader() {
        this._skipHeader = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipHeaderInput() {
        return this._skipHeader;
    }
    get stripNullValues() {
        return this.getBooleanAttribute('strip_null_values');
    }
    set stripNullValues(value) {
        this._stripNullValues = value;
    }
    resetStripNullValues() {
        this._stripNullValues = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stripNullValuesInput() {
        return this._stripNullValues;
    }
    get stripOuterArray() {
        return this.getBooleanAttribute('strip_outer_array');
    }
    set stripOuterArray(value) {
        this._stripOuterArray = value;
    }
    resetStripOuterArray() {
        this._stripOuterArray = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stripOuterArrayInput() {
        return this._stripOuterArray;
    }
    get stripOuterElement() {
        return this.getBooleanAttribute('strip_outer_element');
    }
    set stripOuterElement(value) {
        this._stripOuterElement = value;
    }
    resetStripOuterElement() {
        this._stripOuterElement = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stripOuterElementInput() {
        return this._stripOuterElement;
    }
    get timeFormat() {
        return this.getStringAttribute('time_format');
    }
    set timeFormat(value) {
        this._timeFormat = value;
    }
    resetTimeFormat() {
        this._timeFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeFormatInput() {
        return this._timeFormat;
    }
    get timestampFormat() {
        return this.getStringAttribute('timestamp_format');
    }
    set timestampFormat(value) {
        this._timestampFormat = value;
    }
    resetTimestampFormat() {
        this._timestampFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timestampFormatInput() {
        return this._timestampFormat;
    }
    get trimSpace() {
        return this.getBooleanAttribute('trim_space');
    }
    set trimSpace(value) {
        this._trimSpace = value;
    }
    resetTrimSpace() {
        this._trimSpace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get trimSpaceInput() {
        return this._trimSpace;
    }
    get validateUtf8() {
        return this.getBooleanAttribute('validate_utf8');
    }
    set validateUtf8(value) {
        this._validateUtf8 = value;
    }
    resetValidateUtf8() {
        this._validateUtf8 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get validateUtf8Input() {
        return this._validateUtf8;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_duplicate: cdktf.booleanToTerraform(this._allowDuplicate),
            binary_as_text: cdktf.booleanToTerraform(this._binaryAsText),
            binary_format: cdktf.stringToTerraform(this._binaryFormat),
            comment: cdktf.stringToTerraform(this._comment),
            compression: cdktf.stringToTerraform(this._compression),
            database: cdktf.stringToTerraform(this._database),
            date_format: cdktf.stringToTerraform(this._dateFormat),
            disable_auto_convert: cdktf.booleanToTerraform(this._disableAutoConvert),
            disable_snowflake_data: cdktf.booleanToTerraform(this._disableSnowflakeData),
            empty_field_as_null: cdktf.booleanToTerraform(this._emptyFieldAsNull),
            enable_octal: cdktf.booleanToTerraform(this._enableOctal),
            encoding: cdktf.stringToTerraform(this._encoding),
            error_on_column_count_mismatch: cdktf.booleanToTerraform(this._errorOnColumnCountMismatch),
            escape: cdktf.stringToTerraform(this._escape),
            escape_unenclosed_field: cdktf.stringToTerraform(this._escapeUnenclosedField),
            field_delimiter: cdktf.stringToTerraform(this._fieldDelimiter),
            field_optionally_enclosed_by: cdktf.stringToTerraform(this._fieldOptionallyEnclosedBy),
            file_extension: cdktf.stringToTerraform(this._fileExtension),
            format_type: cdktf.stringToTerraform(this._formatType),
            id: cdktf.stringToTerraform(this._id),
            ignore_utf8_errors: cdktf.booleanToTerraform(this._ignoreUtf8Errors),
            name: cdktf.stringToTerraform(this._name),
            null_if: cdktf.listMapper(cdktf.stringToTerraform)(this._nullIf),
            preserve_space: cdktf.booleanToTerraform(this._preserveSpace),
            record_delimiter: cdktf.stringToTerraform(this._recordDelimiter),
            replace_invalid_characters: cdktf.booleanToTerraform(this._replaceInvalidCharacters),
            schema: cdktf.stringToTerraform(this._schema),
            skip_blank_lines: cdktf.booleanToTerraform(this._skipBlankLines),
            skip_byte_order_mark: cdktf.booleanToTerraform(this._skipByteOrderMark),
            skip_header: cdktf.numberToTerraform(this._skipHeader),
            strip_null_values: cdktf.booleanToTerraform(this._stripNullValues),
            strip_outer_array: cdktf.booleanToTerraform(this._stripOuterArray),
            strip_outer_element: cdktf.booleanToTerraform(this._stripOuterElement),
            time_format: cdktf.stringToTerraform(this._timeFormat),
            timestamp_format: cdktf.stringToTerraform(this._timestampFormat),
            trim_space: cdktf.booleanToTerraform(this._trimSpace),
            validate_utf8: cdktf.booleanToTerraform(this._validateUtf8),
        };
    }
}
exports.FileFormat = FileFormat;
_a = JSII_RTTI_SYMBOL_1;
FileFormat[_a] = { fqn: "@cdktf/provider-snowflake.FileFormat", version: "0.2.0" };
// =================
// STATIC PROPERTIES
// =================
FileFormat.tfResourceType = "snowflake_file_format";
//# sourceMappingURL=data:application/json;base64,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